/*
 * Decompiled with CFR 0.152.
 */
package nc.handler;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.init.NCSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SoundHandler {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static Long2ObjectMap<ISound> soundMap = new Long2ObjectOpenHashMap();

    private static void playSound(ISound sound) {
        MC.func_147118_V().func_147682_a(sound);
    }

    public static ISound startTileSound(SoundEvent soundEvent, BlockPos pos, float volume, float pitch) {
        Object sound = (ISound)soundMap.get(pos.func_177986_g());
        if (sound == null || !MC.func_147118_V().func_147692_c(sound)) {
            sound = new PositionedSoundRecord(soundEvent.func_187503_a(), SoundCategory.BLOCKS, volume, pitch, true, 0, ISound.AttenuationType.LINEAR, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f){

                public float func_147653_e() {
                    if (this.field_184367_a == null) {
                        this.func_184366_a(MC.func_147118_V());
                    }
                    return super.func_147653_e();
                }

                public float func_147655_f() {
                    if (this.field_184367_a == null) {
                        this.func_184366_a(MC.func_147118_V());
                    }
                    return super.func_147655_f();
                }
            };
            SoundHandler.playSound(sound);
            sound = (ISound)soundMap.get(pos.func_177986_g());
        }
        return sound;
    }

    public static void stopTileSound(BlockPos pos) {
        long posKey = pos.func_177986_g();
        ISound sound = (ISound)soundMap.get(posKey);
        if (sound != null) {
            MC.func_147118_V().func_147683_b(sound);
            soundMap.remove(posKey);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTilePlaySound(PlaySoundEvent event) {
        Object resultSound = event.getResultSound();
        if (resultSound == null) {
            return;
        }
        ResourceLocation soundLoc = event.getSound().func_147650_b();
        if (!NCSounds.TICKABLE_SOUNDS.contains((Object)soundLoc.toString())) {
            return;
        }
        if (resultSound.func_184364_b() == null) {
            resultSound.func_184366_a(MC.func_147118_V());
        }
        resultSound = new TileSound(event.getSound(), resultSound.func_147653_e(), resultSound.func_147655_f());
        event.setResultSound(resultSound);
        BlockPos pos = new BlockPos((double)(resultSound.func_147649_g() - 0.5f), (double)(resultSound.func_147654_h() - 0.5f), (double)(resultSound.func_147651_i() - 0.5f));
        soundMap.put(pos.func_177986_g(), resultSound);
    }

    private static class TileSound
    implements ITickableSound {
        private final ISound sound;
        private final float volume;
        private final float pitch;
        private final boolean donePlaying = false;

        TileSound(ISound sound, float volume, float pitch) {
            this.sound = sound;
            this.volume = volume;
            this.pitch = pitch;
        }

        public void func_73660_a() {
        }

        public boolean func_147667_k() {
            return false;
        }

        @Nonnull
        public ResourceLocation func_147650_b() {
            return this.sound.func_147650_b();
        }

        @Nullable
        public SoundEventAccessor func_184366_a(net.minecraft.client.audio.SoundHandler handler) {
            return this.sound.func_184366_a(handler);
        }

        @Nonnull
        public Sound func_184364_b() {
            return this.sound.func_184364_b();
        }

        @Nonnull
        public SoundCategory func_184365_d() {
            return this.sound.func_184365_d();
        }

        public boolean func_147657_c() {
            return this.sound.func_147657_c();
        }

        public int func_147652_d() {
            return this.sound.func_147652_d();
        }

        public float func_147653_e() {
            return this.volume;
        }

        public float func_147655_f() {
            return this.pitch;
        }

        public float func_147649_g() {
            return this.sound.func_147649_g();
        }

        public float func_147654_h() {
            return this.sound.func_147654_h();
        }

        public float func_147651_i() {
            return this.sound.func_147651_i();
        }

        @Nonnull
        public ISound.AttenuationType func_147656_j() {
            return this.sound.func_147656_j();
        }
    }

    public static class SoundInfo {
        public ISound sound;
        public BlockPos pos;

        public SoundInfo(ISound sound, BlockPos pos) {
            this.sound = sound;
            this.pos = pos;
        }
    }
}

