/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.vanilla;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.enumm.MetaEnums;
import nc.init.NCArmor;
import nc.init.NCBlocks;
import nc.init.NCItems;
import nc.init.NCTools;
import nc.radiation.RadArmor;
import nc.recipe.vanilla.ingredient.BucketIngredient;
import nc.recipe.vanilla.recipe.ShapedEnergyRecipe;
import nc.recipe.vanilla.recipe.ShapedFluidRecipe;
import nc.recipe.vanilla.recipe.ShapelessArmorRadShieldingRecipe;
import nc.recipe.vanilla.recipe.ShapelessFluidRecipe;
import nc.util.ArmorHelper;
import nc.util.ItemStackHelper;
import nc.util.NCUtil;
import nc.util.OreDictHelper;
import nc.util.RegistryHelper;
import nc.util.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CraftingRecipeHandler {
    private static final Map<String, Integer> RECIPE_COUNT_MAP = new HashMap<String, Integer>();

    public static void registerCraftingRecipes() {
        for (int i = 0; i < MetaEnums.IngotType.values().length; ++i) {
            String type = StringHelper.capitalize(MetaEnums.IngotType.values()[i].func_176610_l());
            if (!NCConfig.ore_dict_raw_material_recipes) {
                CraftingRecipeHandler.blockCompress(NCBlocks.ingot_block, i, "block" + type, new ItemStack(NCItems.ingot, 1, i));
            } else {
                for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + type))) {
                    CraftingRecipeHandler.blockCompress(NCBlocks.ingot_block, i, "block" + type, ingot);
                }
            }
            if (!NCConfig.ore_dict_raw_material_recipes) {
                CraftingRecipeHandler.blockOpen(NCItems.ingot, i, "ingot" + type, new ItemStack(NCBlocks.ingot_block, 1, i));
                continue;
            }
            for (ItemStack block : OreDictionary.getOres((String)("block" + type))) {
                CraftingRecipeHandler.blockOpen(NCItems.ingot, i, "ingot" + type, block);
            }
        }
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_block, 4, 0), " P ", "PTP", " P ", Character.valueOf('P'), "plateBasic", Character.valueOf('T'), "ingotTough");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.reactor_casing_transparent, 4), "GPG", "PTP", "GPG", Character.valueOf('P'), "plateBasic", Character.valueOf('T'), "ingotTough", Character.valueOf('G'), "blockGlass");
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCBlocks.fission_block, 1, 0), NCBlocks.reactor_casing_transparent);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.reactor_casing_transparent, new ItemStack(NCBlocks.fission_block, 1, 0), "blockGlass");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fission_block, 4, 1), " P ", "POP", " P ", Character.valueOf('P'), "plateBasic", Character.valueOf('O'), "obsidian");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.cell_block, "TGT", "G G", "TGT", Character.valueOf('T'), "ingotTough", Character.valueOf('G'), "blockGlass");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 2, 0), "TIT", "I I", "TIT", Character.valueOf('T'), "ingotTough", Character.valueOf('I'), "ingotSteel");
        CraftingRecipeHandler.addShapelessFluidRecipe(new ItemStack(NCBlocks.cooler, 1, 1), new Object[]{new ItemStack(NCBlocks.cooler, 1, 0), new BucketIngredient("water")});
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 2), " B ", "RCR", " B ", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('R'), "dustRedstone", Character.valueOf('B'), "blockRedstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 2), " R ", "BCB", " R ", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('R'), "dustRedstone", Character.valueOf('B'), "blockRedstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 3), "DQD", "DCD", "DQD", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('Q'), "blockQuartz", Character.valueOf('D'), "dustQuartz");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 3), "DDD", "QCQ", "DDD", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('Q'), "blockQuartz", Character.valueOf('D'), "dustQuartz");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 3), "DQD", "DCD", "DQD", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('Q'), "blockQuartz", Character.valueOf('D'), "dustNetherQuartz");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 3), "DDD", "QCQ", "DDD", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('Q'), "blockQuartz", Character.valueOf('D'), "dustNetherQuartz");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 4), "GGG", "GCG", "GGG", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('G'), "ingotGold");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 5), "DGD", "DCD", "DGD", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('G'), "glowstone", Character.valueOf('D'), "dustGlowstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 5), "DDD", "GCG", "DDD", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('G'), "glowstone", Character.valueOf('D'), "dustGlowstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 6), "BCB", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('B'), "blockLapis");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 6), "B", "C", "B", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('B'), "blockLapis");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 7), "DDD", "DCD", "DDD", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('D'), "gemDiamond");
        CraftingRecipeHandler.addShapelessFluidRecipe(new ItemStack(NCBlocks.cooler, 1, 8), new Object[]{new ItemStack(NCBlocks.cooler, 1, 0), new BucketIngredient("liquidhelium")});
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 9), "EEE", "ECE", "EEE", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('E'), "ingotEnderium");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 10), "DDD", "DCD", "DDD", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('D'), "dustCryotheum");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 11), "III", "ICI", "III", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('I'), "ingotIron");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 12), "EEE", " C ", "EEE", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('E'), "gemEmerald");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 12), "E E", "ECE", "E E", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('E'), "gemEmerald");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 13), "III", "ICI", "III", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('I'), "ingotCopper");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 14), "TTT", "TCT", "TTT", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('T'), "ingotTin");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.cooler, 1, 15), "MMM", "MCM", "MMM", Character.valueOf('C'), new ItemStack(NCBlocks.cooler, 1, 0), Character.valueOf('M'), "ingotMagnesium");
        CraftingRecipeHandler.addShapedOreRecipe(NCItems.reactor_door, "CC", "CC", "CC", Character.valueOf('C'), new ItemStack(NCBlocks.fission_block, 1, 0));
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.reactor_trapdoor, "CCC", "CCC", Character.valueOf('C'), new ItemStack(NCBlocks.fission_block, 1, 0));
        CraftingRecipeHandler.blockCompress(NCBlocks.block_depleted_thorium, 0, "blockThorium230", "ingotThorium230");
        CraftingRecipeHandler.blockCompress(NCBlocks.block_depleted_uranium, 0, "blockUranium238", "ingotUranium238");
        CraftingRecipeHandler.blockCompress(NCBlocks.block_depleted_neptunium, 0, "blockNeptunium237", "ingotNeptunium237");
        CraftingRecipeHandler.blockCompress(NCBlocks.block_depleted_plutonium, 0, "blockPlutonium242", "ingotPlutonium242");
        CraftingRecipeHandler.blockCompress(NCBlocks.block_depleted_americium, 0, "blockAmericium243", "ingotAmericium243");
        CraftingRecipeHandler.blockCompress(NCBlocks.block_depleted_curium, 0, "blockCurium246", "ingotCurium246");
        CraftingRecipeHandler.blockCompress(NCBlocks.block_depleted_berkelium, 0, "blockBerkelium247", "ingotBerkelium247");
        CraftingRecipeHandler.blockCompress(NCBlocks.block_depleted_californium, 0, "blockCalifornium252", "ingotCalifornium252");
        CraftingRecipeHandler.blockOpen(NCItems.thorium, 0, "ingotThorium230", "blockThorium230");
        CraftingRecipeHandler.blockOpen(NCItems.uranium, 8, "ingotUranium238", "blockUranium238");
        CraftingRecipeHandler.blockOpen(NCItems.neptunium, 4, "ingotNeptunium237", "blockNeptunium237");
        CraftingRecipeHandler.blockOpen(NCItems.plutonium, 12, "ingotPlutonium242", "blockPlutonium242");
        CraftingRecipeHandler.blockOpen(NCItems.americium, 8, "ingotAmericium243", "blockAmericium243");
        CraftingRecipeHandler.blockOpen(NCItems.curium, 8, "ingotCurium246", "blockCurium246");
        CraftingRecipeHandler.blockOpen(NCItems.berkelium, 0, "ingotBerkelium247", "blockBerkelium247");
        CraftingRecipeHandler.blockOpen(NCItems.californium, 12, "ingotCalifornium252", "blockCalifornium252");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.nuclear_furnace_idle, "PTP", "TFT", "PTP", Character.valueOf('T'), "ingotTough", Character.valueOf('P'), "plateBasic", Character.valueOf('F'), Blocks.field_150460_al);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.manufactory_idle, "LRL", "FPF", "LCL", Character.valueOf('C'), "solenoidCopper", Character.valueOf('R'), "dustRedstone", Character.valueOf('L'), "ingotLead", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('F'), Items.field_151145_ak);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.alloy_furnace_idle, "PRP", "BFB", "PCP", Character.valueOf('C'), "solenoidCopper", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), "plateBasic", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('B'), Items.field_151118_aC);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.decay_hastener_idle, "PGP", "EME", "PCP", Character.valueOf('M'), "chassis", Character.valueOf('C'), "solenoidCopper", Character.valueOf('P'), "plateAdvanced", Character.valueOf('G'), "dustGlowstone", Character.valueOf('E'), Items.field_151079_bi);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.fuel_reprocessor_idle, "PBP", "TCT", "PAP", Character.valueOf('C'), "chassis", Character.valueOf('A'), "actuator", Character.valueOf('P'), "plateBasic", Character.valueOf('T'), "ingotTough", Character.valueOf('B'), "ingotBoron");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.isotope_separator_idle, "PMP", "RCR", "PMP", Character.valueOf('C'), "chassis", Character.valueOf('M'), "motor", Character.valueOf('P'), "plateBasic", Character.valueOf('R'), "dustRedstone");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.pressurizer_idle, "PTP", "ACA", "PTP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('T'), "ingotTough", Character.valueOf('A'), "actuator");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.salt_mixer_idle, "PSP", "BCB", "PMP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateBasic", Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('M'), "motor", Character.valueOf('S'), "ingotSteel");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.dissolver_idle, "PHP", "LCL", "PMP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('L'), "gemLapis", Character.valueOf('M'), "motor", Character.valueOf('H'), Blocks.field_150438_bZ);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.chemical_reactor_idle, "PMP", "GCG", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('G'), "dustGlowstone", Character.valueOf('M'), "motor", Character.valueOf('S'), "servo");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.electrolyser_idle, "PGP", "SCS", "PMP", Character.valueOf('C'), "chassis", Character.valueOf('S'), "solenoidCopper", Character.valueOf('P'), "plateAdvanced", Character.valueOf('G'), "ingotGraphite", Character.valueOf('M'), "motor");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.irradiator_idle, "PEP", "LCL", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateAdvanced", Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('L'), "solenoidCopper", Character.valueOf('S'), "servo");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.supercooler_idle, "PDP", "HCH", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('D'), "ingotMagnesiumDiboride", Character.valueOf('H'), "ingotHardCarbon", Character.valueOf('P'), "plateAdvanced", Character.valueOf('S'), "servo");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.ingot_former_idle, "PHP", "FCF", "PTP", Character.valueOf('C'), "chassis", Character.valueOf('P'), "plateBasic", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), Blocks.field_150438_bZ);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.melter_idle, "PNP", "NCN", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('N'), "ingotBrickNether", Character.valueOf('P'), "plateAdvanced", Character.valueOf('S'), "servo");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.crystallizer_idle, "PSP", "SCS", "PUP", Character.valueOf('C'), "chassis", Character.valueOf('S'), "solenoidCopper", Character.valueOf('U'), Items.field_151066_bu, Character.valueOf('P'), "plateAdvanced");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.infuser_idle, "PBP", "GCG", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('G'), "ingotGold", Character.valueOf('S'), "servo", Character.valueOf('P'), "plateAdvanced", Character.valueOf('B'), Items.field_151133_ar);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.extractor_idle, "PMP", "BCB", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('M'), "ingotMagnesium", Character.valueOf('S'), "servo", Character.valueOf('P'), "plateAdvanced", Character.valueOf('B'), Items.field_151133_ar);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.centrifuge_idle, "PFP", "MCM", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('M'), "motor", Character.valueOf('P'), "plateAdvanced", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('S'), "servo");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.rock_crusher_idle, "PMP", "ACA", "PTP", Character.valueOf('C'), "chassis", Character.valueOf('A'), "actuator", Character.valueOf('P'), "plateAdvanced", Character.valueOf('T'), "ingotTough", Character.valueOf('M'), "motor");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.machine_interface, " A ", "MCM", " S ", Character.valueOf('C'), "chassis", Character.valueOf('A'), "actuator", Character.valueOf('M'), "motor", Character.valueOf('S'), "servo");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.fission_controller_new_fixed, "PSP", "FCF", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('S'), "solenoidMagnesiumDiboride", Character.valueOf('P'), "plateAdvanced", Character.valueOf('F'), NCBlocks.nuclear_furnace_idle);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.fission_controller_new_fixed, NCBlocks.fission_controller_idle);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.buffer, "PSP", "BHB", "PSP", Character.valueOf('S'), "solenoidCopper", Character.valueOf('P'), "plateBasic", Character.valueOf('H'), Blocks.field_150438_bZ, Character.valueOf('B'), Items.field_151133_ar);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.fission_port, " S ", "RHR", " S ", Character.valueOf('S'), "solenoidCopper", Character.valueOf('R'), new ItemStack(NCBlocks.fission_block, 1, 0), Character.valueOf('H'), Blocks.field_150438_bZ);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.active_cooler, "PSP", "BCB", "PSP", Character.valueOf('S'), "ingotTin", Character.valueOf('P'), "plateBasic", Character.valueOf('C'), Items.field_151066_bu, Character.valueOf('B'), "ingotCopper");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.fusion_core, "PSP", "RCR", "PSP", Character.valueOf('C'), "chassis", Character.valueOf('S'), "solenoidMagnesiumDiboride", Character.valueOf('P'), "plateElite", Character.valueOf('R'), NCBlocks.chemical_reactor_idle);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.fusion_connector, "TPT", "PCP", "TPT", Character.valueOf('T'), "ingotTough", Character.valueOf('P'), "plateBasic", Character.valueOf('C'), "ingotCopper");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fusion_electromagnet_idle, 1), "SPS", "P P", "SPS", Character.valueOf('P'), "plateAdvanced", Character.valueOf('S'), "solenoidCopper");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.fusion_electromagnet_transparent_idle, 1), "SPS", "PGP", "SPS", Character.valueOf('P'), "plateAdvanced", Character.valueOf('S'), "solenoidCopper", Character.valueOf('G'), "blockGlass");
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.fusion_electromagnet_transparent_idle, NCBlocks.fusion_electromagnet_idle, "blockGlass");
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.fusion_electromagnet_idle, NCBlocks.fusion_electromagnet_transparent_idle);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.rtg_uranium, "PGP", "GUG", "PGP", Character.valueOf('G'), "ingotGraphite", Character.valueOf('P'), "plateBasic", Character.valueOf('U'), "blockUranium238");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.rtg_plutonium, "PGP", "GUG", "PGP", Character.valueOf('G'), "ingotGraphite", Character.valueOf('P'), "plateAdvanced", Character.valueOf('U'), "ingotPlutonium238");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.rtg_americium, "PGP", "GAG", "PGP", Character.valueOf('G'), "ingotGraphite", Character.valueOf('P'), "plateAdvanced", Character.valueOf('A'), "ingotAmericium241");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.rtg_californium, "PGP", "GCG", "PGP", Character.valueOf('G'), "ingotGraphite", Character.valueOf('P'), "plateAdvanced", Character.valueOf('C'), "ingotCalifornium250");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.solar_panel_basic, "GQG", "PLP", "CPC", Character.valueOf('G'), "dustGraphite", Character.valueOf('Q'), "dustQuartz", Character.valueOf('P'), Blocks.field_150443_bT, Character.valueOf('L'), "gemLapis", Character.valueOf('C'), "solenoidCopper");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.solar_panel_basic, "GQG", "PLP", "CPC", Character.valueOf('G'), "dustGraphite", Character.valueOf('Q'), "dustNetherQuartz", Character.valueOf('P'), Blocks.field_150443_bT, Character.valueOf('L'), "gemLapis", Character.valueOf('C'), "solenoidCopper");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.solar_panel_advanced, "PGP", "SSS", "PCP", Character.valueOf('S'), NCBlocks.solar_panel_basic, Character.valueOf('G'), "dustGraphite", Character.valueOf('P'), "plateAdvanced", Character.valueOf('C'), "solenoidCopper");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.solar_panel_du, "PGP", "SSS", "PMP", Character.valueOf('S'), NCBlocks.solar_panel_advanced, Character.valueOf('G'), "dustGraphite", Character.valueOf('P'), "plateDU", Character.valueOf('M'), "solenoidMagnesiumDiboride");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.solar_panel_elite, "PBP", "SSS", "PMP", Character.valueOf('S'), NCBlocks.solar_panel_du, Character.valueOf('B'), "gemBoronArsenide", Character.valueOf('P'), "plateElite", Character.valueOf('M'), "solenoidMagnesiumDiboride");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.decay_generator, "LCL", "CRC", "LCL", Character.valueOf('C'), "cobblestone", Character.valueOf('L'), "ingotLead", Character.valueOf('R'), "dustRedstone");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.voltaic_pile_basic, "PSP", "SMS", "PSP", Character.valueOf('P'), "plateBasic", Character.valueOf('S'), "solenoidCopper", Character.valueOf('M'), "blockMagnesium");
        CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.voltaic_pile_advanced, "PMP", "VVV", "PCP", Character.valueOf('V'), NCBlocks.voltaic_pile_basic, Character.valueOf('P'), "plateAdvanced", Character.valueOf('M'), "ingotMagnesium", Character.valueOf('C'), "ingotCopper");
        CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.voltaic_pile_du, "PMP", "VVV", "PCP", Character.valueOf('V'), NCBlocks.voltaic_pile_advanced, Character.valueOf('P'), "plateDU", Character.valueOf('M'), "ingotMagnesium", Character.valueOf('C'), "ingotCopper");
        CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.voltaic_pile_elite, "PMP", "VVV", "PCP", Character.valueOf('V'), NCBlocks.voltaic_pile_du, Character.valueOf('P'), "plateElite", Character.valueOf('M'), "ingotMagnesium", Character.valueOf('C'), "ingotCopper");
        CraftingRecipeHandler.addShapedOreRecipe(NCItems.lithium_ion_cell, "CCC", "FLF", "DDD", Character.valueOf('C'), "ingotHardCarbon", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('L'), "ingotLithium", Character.valueOf('D'), "ingotLithiumManganeseDioxide");
        CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.lithium_ion_battery_basic, "PCP", "CSC", "PCP", Character.valueOf('C'), NCItems.lithium_ion_cell, Character.valueOf('P'), "plateElite", Character.valueOf('S'), "solenoidMagnesiumDiboride");
        CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.lithium_ion_battery_advanced, "PDP", "LLL", "PSP", Character.valueOf('L'), NCBlocks.lithium_ion_battery_basic, Character.valueOf('P'), "plateAdvanced", Character.valueOf('D'), "ingotLithiumManganeseDioxide", Character.valueOf('S'), "solenoidMagnesiumDiboride");
        CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.lithium_ion_battery_du, "PDP", "LLL", "PSP", Character.valueOf('L'), NCBlocks.lithium_ion_battery_advanced, Character.valueOf('P'), "plateDU", Character.valueOf('D'), "ingotLithiumManganeseDioxide", Character.valueOf('S'), "solenoidMagnesiumDiboride");
        CraftingRecipeHandler.addShapedEnergyRecipe(NCBlocks.lithium_ion_battery_elite, "PDP", "LLL", "PSP", Character.valueOf('L'), NCBlocks.lithium_ion_battery_du, Character.valueOf('P'), "plateElite", Character.valueOf('D'), "ingotLithiumManganeseDioxide", Character.valueOf('S'), "solenoidMagnesiumDiboride");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.bin, "PZP", "Z Z", "PZP", Character.valueOf('P'), "plateBasic", Character.valueOf('Z'), "ingotZirconium");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.accelerator_electromagnet_idle, "SPS", "P P", "SPS", Character.valueOf('P'), "plateElite", Character.valueOf('S'), "solenoidMagnesiumDiboride");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.electromagnet_supercooler_idle, "TIT", "IEI", "TIT", Character.valueOf('T'), "ingotTin", Character.valueOf('I'), NCBlocks.block_ice, Character.valueOf('E'), NCBlocks.accelerator_electromagnet_idle);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.helium_collector, "PIP", "ITI", "PIP", Character.valueOf('I'), "ingotZirconium", Character.valueOf('P'), "plateBasic", Character.valueOf('T'), "blockThorium230");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.helium_collector_compact, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.helium_collector, Character.valueOf('I'), "ingotBronze");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.helium_collector_dense, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.helium_collector_compact, Character.valueOf('I'), "ingotGold");
        CraftingRecipeHandler.addShapedFluidRecipe(NCBlocks.cobblestone_generator, new Object[]{"PIP", "L W", "PIP", Character.valueOf('I'), "ingotTin", Character.valueOf('P'), "plateBasic", Character.valueOf('L'), new BucketIngredient("lava"), Character.valueOf('W'), new BucketIngredient("water")});
        CraftingRecipeHandler.addShapedFluidRecipe(NCBlocks.cobblestone_generator, new Object[]{"PIP", "W L", "PIP", Character.valueOf('I'), "ingotTin", Character.valueOf('P'), "plateBasic", Character.valueOf('L'), new BucketIngredient("lava"), Character.valueOf('W'), new BucketIngredient("water")});
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.cobblestone_generator_compact, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.cobblestone_generator, Character.valueOf('I'), "ingotBronze");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.cobblestone_generator_dense, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.cobblestone_generator_compact, Character.valueOf('I'), "ingotGold");
        CraftingRecipeHandler.addShapedFluidRecipe(NCBlocks.water_source, new Object[]{"PIP", "W W", "PIP", Character.valueOf('I'), "ingotTin", Character.valueOf('P'), "plateBasic", Character.valueOf('W'), new BucketIngredient("water")});
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.water_source_compact, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.water_source, Character.valueOf('I'), "ingotBronze");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.water_source_dense, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.water_source_compact, Character.valueOf('I'), "ingotGold");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.nitrogen_collector, "PIP", "B B", "PIP", Character.valueOf('I'), "ingotBeryllium", Character.valueOf('P'), "plateAdvanced", Character.valueOf('B'), Items.field_151133_ar);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.nitrogen_collector_compact, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.nitrogen_collector, Character.valueOf('I'), "ingotBronze");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.nitrogen_collector_dense, "CCC", "CIC", "CCC", Character.valueOf('C'), NCBlocks.nitrogen_collector_compact, Character.valueOf('I'), "ingotGold");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.salt_fission_controller, "PEP", "HFH", "PEP", Character.valueOf('P'), "plateElite", Character.valueOf('E'), "ingotExtreme", Character.valueOf('H'), "ingotHardCarbon", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_wall, 4), "STS", "TFT", "STS", Character.valueOf('S'), "ingotSteel", Character.valueOf('T'), "ingotTough", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.salt_fission_wall, NCBlocks.salt_fission_glass);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.salt_fission_glass, NCBlocks.salt_fission_wall, "blockGlass");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_frame, 4), "SWS", "W W", "SWS", Character.valueOf('S'), "ingotSteel", Character.valueOf('W'), NCBlocks.salt_fission_wall);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.salt_fission_beam, NCBlocks.salt_fission_wall);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.salt_fission_wall, NCBlocks.salt_fission_beam);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.salt_fission_moderator, "PSP", "SGS", "PSP", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), "plateElite", Character.valueOf('G'), "blockGraphite");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.salt_fission_moderator, "PSP", "SBS", "PSP", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), "plateElite", Character.valueOf('B'), "blockBeryllium");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.salt_fission_vent, 4), "STS", "VFV", "STS", Character.valueOf('S'), "ingotSteel", Character.valueOf('T'), "ingotTough", Character.valueOf('V'), "servo", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.salt_fission_vessel, "PTP", "ZFZ", "PSP", Character.valueOf('P'), "plateElite", Character.valueOf('T'), "ingotTough", Character.valueOf('Z'), "ingotZircaloy", Character.valueOf('F'), "steelFrame", Character.valueOf('S'), "servo");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.salt_fission_heater, "PEP", "TFT", "PSP", Character.valueOf('P'), "plateElite", Character.valueOf('T'), "ingotThermoconducting", Character.valueOf('E'), "ingotExtreme", Character.valueOf('F'), "steelFrame", Character.valueOf('S'), "servo");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.salt_fission_distributor, "PEP", "NVN", "PEP", Character.valueOf('P'), "plateElite", Character.valueOf('E'), "ingotExtreme", Character.valueOf('N'), Items.field_151061_bv, Character.valueOf('V'), NCBlocks.salt_fission_vent);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.salt_fission_retriever, "PTP", "NVN", "PTP", Character.valueOf('P'), "plateElite", Character.valueOf('T'), "ingotTough", Character.valueOf('N'), Items.field_151061_bv, Character.valueOf('V'), NCBlocks.salt_fission_vent);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.salt_fission_redstone_port, "SCS", "RFR", "SCS", Character.valueOf('S'), "ingotSteel", Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('R'), Items.field_151107_aW, Character.valueOf('F'), "steelFrame");
        if (ModCheck.openComputersLoaded()) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.salt_fission_computer_port, " M ", "CWC", " P ", Character.valueOf('M'), RegistryHelper.itemStackFromRegistry("opencomputers:material:7"), Character.valueOf('C'), RegistryHelper.blockStackFromRegistry("opencomputers:cable:0"), Character.valueOf('P'), RegistryHelper.itemStackFromRegistry("opencomputers:material:4"), Character.valueOf('W'), NCBlocks.salt_fission_wall);
        }
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.heat_exchanger_controller, "PTP", "SFS", "PTP", Character.valueOf('P'), "plateAdvanced", Character.valueOf('S'), "ingotSteel", Character.valueOf('T'), "ingotThermoconducting", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.heat_exchanger_wall, 4), "SNS", "NFN", "SNS", Character.valueOf('S'), "ingotSteel", Character.valueOf('N'), "stone", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.heat_exchanger_wall, NCBlocks.heat_exchanger_glass);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.heat_exchanger_glass, NCBlocks.heat_exchanger_wall, "blockGlass");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.heat_exchanger_frame, 4), "SWS", "W W", "SWS", Character.valueOf('S'), "ingotSteel", Character.valueOf('W'), NCBlocks.heat_exchanger_wall);
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.heat_exchanger_vent, 4), "SNS", "VFV", "SNS", Character.valueOf('S'), "ingotSteel", Character.valueOf('N'), "stone", Character.valueOf('V'), "servo", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.heat_exchanger_tube_copper, 4), "PCP", "CFC", "PSP", Character.valueOf('P'), "plateBasic", Character.valueOf('C'), "ingotCopper", Character.valueOf('F'), "steelFrame", Character.valueOf('S'), "servo");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.heat_exchanger_tube_hard_carbon, 4), "PHP", "HFH", "PSP", Character.valueOf('P'), "plateAdvanced", Character.valueOf('H'), "ingotHardCarbon", Character.valueOf('F'), "steelFrame", Character.valueOf('S'), "servo");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.heat_exchanger_tube_thermoconducting, 4), "PTP", "TFT", "PSP", Character.valueOf('P'), "plateElite", Character.valueOf('T'), "ingotThermoconducting", Character.valueOf('F'), "steelFrame", Character.valueOf('S'), "servo");
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.heat_exchanger_tube_copper, NCBlocks.heat_exchanger_condenser_tube_copper);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.heat_exchanger_tube_hard_carbon, NCBlocks.heat_exchanger_condenser_tube_hard_carbon);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.heat_exchanger_tube_thermoconducting, NCBlocks.heat_exchanger_condenser_tube_thermoconducting);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.heat_exchanger_condenser_tube_copper, NCBlocks.heat_exchanger_tube_copper);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.heat_exchanger_condenser_tube_hard_carbon, NCBlocks.heat_exchanger_tube_hard_carbon);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.heat_exchanger_condenser_tube_thermoconducting, NCBlocks.heat_exchanger_tube_thermoconducting);
        if (ModCheck.openComputersLoaded()) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.heat_exchanger_computer_port, " M ", "CWC", " P ", Character.valueOf('M'), RegistryHelper.itemStackFromRegistry("opencomputers:material:7"), Character.valueOf('C'), RegistryHelper.blockStackFromRegistry("opencomputers:cable:0"), Character.valueOf('P'), RegistryHelper.itemStackFromRegistry("opencomputers:material:4"), Character.valueOf('W'), NCBlocks.heat_exchanger_wall);
        }
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.turbine_controller, "PSP", "SFS", "PSP", Character.valueOf('P'), "plateAdvanced", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_wall, 4), "SSS", "SFS", "SSS", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.turbine_wall, NCBlocks.turbine_glass);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.turbine_glass, NCBlocks.turbine_wall, "blockGlass");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_frame, 4), "SWS", "W W", "SWS", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('W'), NCBlocks.turbine_wall);
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_rotor_shaft, 4), "STS", "STS", "STS", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('T'), "ingotTough");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_rotor_blade_steel, 4), "SSS", "HHH", "SSS", Character.valueOf('S'), "ingotSteel", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_rotor_blade_extreme, 4), "EEE", "HHH", "EEE", Character.valueOf('E'), "ingotExtreme", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_rotor_blade_sic_sic_cmc, 4), "SSS", "HHH", "SSS", Character.valueOf('S'), "ingotSiCSiCCMC", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_rotor_stator, 4), "SSS", "SSS", Character.valueOf('S'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.turbine_rotor_bearing, "SGS", "GFG", "SGS", Character.valueOf('G'), "nuggetGold", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_dynamo_coil, 1, 0), "MMM", "HTH", "MMM", Character.valueOf('M'), "ingotMagnesium", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_dynamo_coil, 1, 1), "BBB", "HTH", "BBB", Character.valueOf('B'), "ingotBeryllium", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_dynamo_coil, 1, 2), "AAA", "HTH", "AAA", Character.valueOf('A'), "ingotAluminum", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_dynamo_coil, 1, 3), "GGG", "HTH", "GGG", Character.valueOf('G'), "ingotGold", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_dynamo_coil, 1, 4), "CCC", "HTH", "CCC", Character.valueOf('C'), "ingotCopper", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_dynamo_coil, 1, 5), "SSS", "HTH", "SSS", Character.valueOf('S'), "ingotSilver", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_coil_connector, 4), "HHH", "HTH", "HHH", Character.valueOf('T'), "ingotTough", Character.valueOf('H'), "ingotHSLASteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_inlet, 4), "SSS", "TFT", "SVS", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('T'), "ingotTough", Character.valueOf('V'), "servo", Character.valueOf('F'), "steelFrame");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCBlocks.turbine_outlet, 4), "SSS", "VFV", "SSS", Character.valueOf('S'), "ingotHSLASteel", Character.valueOf('V'), "servo", Character.valueOf('F'), "steelFrame");
        if (ModCheck.openComputersLoaded()) {
            CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.turbine_computer_port, " M ", "CWC", " P ", Character.valueOf('M'), RegistryHelper.itemStackFromRegistry("opencomputers:material:7"), Character.valueOf('C'), RegistryHelper.blockStackFromRegistry("opencomputers:cable:0"), Character.valueOf('P'), RegistryHelper.itemStackFromRegistry("opencomputers:material:4"), Character.valueOf('W'), NCBlocks.turbine_wall);
        }
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 2, 0), "LG", "GL", Character.valueOf('L'), "ingotLead", Character.valueOf('G'), "dustGraphite");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 2, 0), "GL", "LG", Character.valueOf('L'), "ingotLead", Character.valueOf('G'), "dustGraphite");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 1), "RTR", "TPT", "RTR", Character.valueOf('R'), "dustRedstone", Character.valueOf('T'), "ingotTough", Character.valueOf('P'), "plateBasic");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 2), "SUS", "UPU", "SUS", Character.valueOf('S'), "dustSulfur", Character.valueOf('U'), "ingotUranium238", Character.valueOf('P'), "plateAdvanced");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 3), "RBR", "BPB", "RBR", Character.valueOf('R'), "dustCrystalBinder", Character.valueOf('B'), "ingotBoron", Character.valueOf('P'), "plateDU");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 2, 4), "CC", "II", "CC", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "ingotIron");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 2, 5), "MM", "TT", "MM", Character.valueOf('M'), "ingotMagnesiumDiboride", Character.valueOf('T'), "ingotTough");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 7), "F F", "RSR", "SCS", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('S'), "ingotSteel", Character.valueOf('C'), "ingotCopper", Character.valueOf('R'), "dustRedstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 8), "SSG", "CCI", "SSG", Character.valueOf('G'), "nuggetGold", Character.valueOf('S'), "ingotSteel", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "solenoidCopper");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 9), "  S", "FP ", "CF ", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('C'), "ingotCopper");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 10), "LSL", "STS", "LSL", Character.valueOf('L'), "ingotLead", Character.valueOf('T'), "ingotTough", Character.valueOf('S'), "ingotSteel");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 11), "PTP", "I I", "PTP", Character.valueOf('P'), "plateBasic", Character.valueOf('I'), "ingotIron", Character.valueOf('T'), "ingotTin");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.part, 1, 12), "STS", "TBT", "STS", Character.valueOf('S'), "ingotSteel", Character.valueOf('B'), "ingotBronze", Character.valueOf('T'), "ingotTough");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.upgrade, 1, 0), "LRL", "RPR", "LRL", Character.valueOf('L'), "gemLapis", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), Blocks.field_150443_bT);
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.upgrade, 1, 1), "OQO", "QPQ", "OQO", Character.valueOf('O'), "dustObsidian", Character.valueOf('Q'), "dustQuartz", Character.valueOf('P'), Blocks.field_150445_bS);
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.upgrade, 1, 1), "OQO", "QPQ", "OQO", Character.valueOf('O'), "dustObsidian", Character.valueOf('Q'), "dustNetherQuartz", Character.valueOf('P'), Blocks.field_150445_bS);
        CraftingRecipeHandler.itemCompress(NCItems.dust, 2, "dustLead", "tinyDustLead");
        CraftingRecipeHandler.tools("ingotBoron", NCTools.sword_boron, NCTools.pickaxe_boron, NCTools.shovel_boron, NCTools.axe_boron, NCTools.hoe_boron, NCTools.spaxelhoe_boron);
        CraftingRecipeHandler.tools("ingotTough", NCTools.sword_tough, NCTools.pickaxe_tough, NCTools.shovel_tough, NCTools.axe_tough, NCTools.hoe_tough, NCTools.spaxelhoe_tough);
        CraftingRecipeHandler.tools("ingotHardCarbon", NCTools.sword_hard_carbon, NCTools.pickaxe_hard_carbon, NCTools.shovel_hard_carbon, NCTools.axe_hard_carbon, NCTools.hoe_hard_carbon, NCTools.spaxelhoe_hard_carbon);
        CraftingRecipeHandler.tools("gemBoronNitride", NCTools.sword_boron_nitride, NCTools.pickaxe_boron_nitride, NCTools.shovel_boron_nitride, NCTools.axe_boron_nitride, NCTools.hoe_boron_nitride, NCTools.spaxelhoe_boron_nitride);
        CraftingRecipeHandler.armor("ingotBoron", NCArmor.helm_boron, NCArmor.chest_boron, NCArmor.legs_boron, NCArmor.boots_boron);
        CraftingRecipeHandler.armor("ingotTough", NCArmor.helm_tough, NCArmor.chest_tough, NCArmor.legs_tough, NCArmor.boots_tough);
        CraftingRecipeHandler.armor("ingotHardCarbon", NCArmor.helm_hard_carbon, NCArmor.chest_hard_carbon, NCArmor.legs_hard_carbon, NCArmor.boots_hard_carbon);
        CraftingRecipeHandler.armor("gemBoronNitride", NCArmor.helm_boron_nitride, NCArmor.chest_boron_nitride, NCArmor.legs_boron_nitride, NCArmor.boots_boron_nitride);
        CraftingRecipeHandler.itemCompress(NCItems.fuel_thorium, 0, "fuelTBU", "ingotThorium232");
        CraftingRecipeHandler.itemCompress(NCItems.fuel_thorium, 1, "fuelTBUOxide", "ingotThorium232Oxide");
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCItems.fuel_mixed_oxide, 1, 0), "ingotPlutonium239Oxide", "ingotUranium238", "ingotUranium238", "ingotUranium238", "ingotUranium238", "ingotUranium238", "ingotUranium238", "ingotUranium238", "ingotUranium238");
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCItems.fuel_mixed_oxide, 1, 1), "ingotPlutonium241Oxide", "ingotUranium238", "ingotUranium238", "ingotUranium238", "ingotUranium238", "ingotUranium238", "ingotUranium238", "ingotUranium238", "ingotUranium238");
        CraftingRecipeHandler.fissionClumpRecipes("Thorium", NCItems.thorium, 230, 232);
        CraftingRecipeHandler.fissionClumpRecipes("Uranium", NCItems.uranium, 233, 235, 238);
        CraftingRecipeHandler.fissionClumpRecipes("Neptunium", NCItems.neptunium, 236, 237);
        CraftingRecipeHandler.fissionClumpRecipes("Plutonium", NCItems.plutonium, 238, 239, 241, 242);
        CraftingRecipeHandler.fissionClumpRecipes("Americium", NCItems.americium, 241, 242, 243);
        CraftingRecipeHandler.fissionClumpRecipes("Curium", NCItems.curium, 243, 245, 246, 247);
        CraftingRecipeHandler.fissionClumpRecipes("Berkelium", NCItems.berkelium, 247, 248);
        CraftingRecipeHandler.fissionClumpRecipes("Californium", NCItems.californium, 249, 250, 251, 252);
        CraftingRecipeHandler.fissionFuelRecipes("Uranium", "U", NCItems.fuel_uranium, 238, 233, 235);
        CraftingRecipeHandler.fissionFuelRecipes("Neptunium", "N", NCItems.fuel_neptunium, 237, 236);
        CraftingRecipeHandler.fissionFuelRecipes("Plutonium", "P", NCItems.fuel_plutonium, 242, 239, 241);
        CraftingRecipeHandler.fissionFuelRecipes("Americium", "A", NCItems.fuel_americium, 243, 242);
        CraftingRecipeHandler.fissionFuelRecipes("Curium", "Cm", NCItems.fuel_curium, 246, 243, 245, 247);
        CraftingRecipeHandler.fissionFuelRecipes("Berkelium", "B", NCItems.fuel_berkelium, 247, 248);
        CraftingRecipeHandler.fissionFuelRecipes("Californium", "Cf", NCItems.fuel_californium, 252, 249, 251);
        CraftingRecipeHandler.tinyClumpRecipes("Boron", NCItems.boron, 10, 11);
        CraftingRecipeHandler.tinyClumpRecipes("Lithium", NCItems.lithium, 6, 7);
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCItems.compound, 2, 1), "dustRhodochrosite", "dustCalciumSulfate", "dustObsidian", "dustMagnesium");
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCItems.compound, 2, 2), "dustRedstone", "dustGlowstone");
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCItems.compound, 2, 8), "dustObsidian", "dustObsidian", "dustObsidian", "dustObsidian", "dustEndstone");
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCItems.compound, 2, 9), "dustGraphite", "dustManganese");
        CraftingRecipeHandler.addShapedOreRecipe(NCItems.portable_ender_chest, " S ", "WCW", "LWL", Character.valueOf('C'), "chestEnder", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, 10), Character.valueOf('S'), "string", Character.valueOf('L'), "ingotTough");
        CraftingRecipeHandler.addShapedOreRecipe(NCItems.portable_ender_chest, " S ", "WCW", "LWL", Character.valueOf('C'), "chestEnder", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, 15), Character.valueOf('S'), "string", Character.valueOf('L'), "ingotTough");
        CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(NCItems.dominos, 4), Items.field_151025_P, Items.field_151025_P, Items.field_151025_P, Items.field_151157_am, Items.field_151083_be, Items.field_151077_bg, Items.field_179557_bn, Blocks.field_150338_P, Blocks.field_150338_P);
        CraftingRecipeHandler.addShapelessOreRecipe(Blocks.field_150338_P, NCBlocks.glowing_mushroom);
        CraftingRecipeHandler.addShapelessOreRecipe(NCBlocks.glowing_mushroom, Blocks.field_150338_P, "dustGlowstone");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(Items.field_151106_aX, 12), "FCF", Character.valueOf('F'), "dustWheat", Character.valueOf('C'), "dustCocoa");
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.smore, NCItems.graham_cracker, "ingotChocolate", "ingotMarshmallow", NCItems.graham_cracker);
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.moresmore, NCItems.smore, "ingotChocolate", "ingotMarshmallow", NCItems.smore);
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.foursmore, NCItems.moresmore, "ingotChocolate", "ingotMarshmallow", NCItems.moresmore);
        CraftingRecipeHandler.addShapedOreRecipe(NCItems.geiger_counter, "SFF", "CRR", "BFF", Character.valueOf('S'), "ingotSteel", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('C'), "ingotCopper", Character.valueOf('R'), "dustRedstone", Character.valueOf('B'), "bioplastic");
        CraftingRecipeHandler.addShapedOreRecipe(NCItems.radiation_badge, " C ", "SRS", " L ", Character.valueOf('C'), "ingotCopper", Character.valueOf('S'), "string", Character.valueOf('R'), "dustRedstone", Character.valueOf('L'), "ingotLead");
        CraftingRecipeHandler.addShapedOreRecipe(NCItems.rad_x, "EPE", "PRP", "PBP", Character.valueOf('E'), "dustEnergetic", Character.valueOf('P'), "bioplastic", Character.valueOf('R'), NCItems.radaway, Character.valueOf('B'), Items.field_151065_br);
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.radiation_scrubber, "PCP", "CEC", "PCP", Character.valueOf('P'), "plateElite", Character.valueOf('E'), "ingotExtreme", Character.valueOf('C'), "dustBorax");
        CraftingRecipeHandler.addShapedOreRecipe(NCBlocks.geiger_block, " P ", "PGP", " P ", Character.valueOf('P'), "plateBasic", Character.valueOf('G'), NCItems.geiger_counter);
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.rad_shielding, 1, 0), "III", "CCC", "LLL", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "coal", Character.valueOf('L'), "ingotLead");
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.rad_shielding, 1, 1), "BBB", "RFR", "PPP", Character.valueOf('B'), "bioplastic", Character.valueOf('F'), "ingotFerroboron", Character.valueOf('P'), "plateBasic", Character.valueOf('R'), new ItemStack(NCItems.rad_shielding, 1, 0));
        CraftingRecipeHandler.addShapedOreRecipe(new ItemStack(NCItems.rad_shielding, 1, 2), "BBB", "RHR", "PPP", Character.valueOf('B'), "ingotBeryllium", Character.valueOf('H'), "ingotHardCarbon", Character.valueOf('P'), "plateDU", Character.valueOf('R'), new ItemStack(NCItems.rad_shielding, 1, 1));
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.record_wanderer, "record", "ingotTough");
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.record_end_of_the_world, "record", "ingotUranium235");
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.record_money_for_nothing, "record", "ingotSilver");
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.record_hyperspace, "record", "dustDimensional");
        CraftingRecipeHandler.addShapedOreRecipe(NCArmor.helm_hazmat, "YWY", "SLS", "BIB", Character.valueOf('Y'), "dyeYellow", Character.valueOf('W'), "wool", Character.valueOf('L'), Items.field_151024_Q, Character.valueOf('B'), "bioplastic", Character.valueOf('I'), "ingotSteel", Character.valueOf('S'), new ItemStack(NCItems.rad_shielding, 1, 2));
        CraftingRecipeHandler.addShapedOreRecipe(NCArmor.chest_hazmat, "WSW", "YLY", "SWS", Character.valueOf('Y'), "dyeYellow", Character.valueOf('W'), "wool", Character.valueOf('L'), Items.field_151027_R, Character.valueOf('S'), new ItemStack(NCItems.rad_shielding, 1, 2));
        CraftingRecipeHandler.addShapedOreRecipe(NCArmor.legs_hazmat, "YBY", "SLS", "W W", Character.valueOf('Y'), "dyeYellow", Character.valueOf('W'), "wool", Character.valueOf('L'), Items.field_151026_S, Character.valueOf('B'), "bioplastic", Character.valueOf('S'), new ItemStack(NCItems.rad_shielding, 1, 2));
        CraftingRecipeHandler.addShapedOreRecipe(NCArmor.boots_hazmat, "SDS", "BLB", Character.valueOf('D'), "dyeBlack", Character.valueOf('L'), Items.field_151021_T, Character.valueOf('B'), "bioplastic", Character.valueOf('S'), new ItemStack(NCItems.rad_shielding, 1, 2));
        CraftingRecipeHandler.addShapelessOreRecipe(NCItems.configuration_blueprint_empty, Items.field_151121_aF, "gemLapis", "dustGraphite");
    }

    public static void registerRadShieldingCraftingRecipes() {
        if (NCConfig.radiation_shielding_default_recipes) {
            for (Item item : ForgeRegistries.ITEMS.getValuesCollection()) {
                if (!ArmorHelper.isArmor(item, NCConfig.radiation_horse_armor_public)) continue;
                NonNullList stacks = NonNullList.func_191196_a();
                item.func_150895_a(CreativeTabs.field_78027_g, stacks);
                for (ItemStack stack : stacks) {
                    int packed = RecipeItemHelper.func_194113_b((ItemStack)stack);
                    if (RadArmor.ARMOR_STACK_SHIELDING_BLACKLIST.contains(packed)) continue;
                    RadArmor.addArmorShieldingRecipes(stack);
                }
            }
        }
        IntIterator intIterator = RadArmor.ARMOR_STACK_SHIELDING_LIST.iterator();
        while (intIterator.hasNext()) {
            int packed = (Integer)intIterator.next();
            RadArmor.addArmorShieldingRecipes(RecipeItemHelper.func_194115_b((int)packed));
        }
    }

    public static void fissionFuelRecipes(String element, String fuelLetter, Item fuelType, int fertileNo, int ... fissileNo) {
        for (int i = 0; i < fissileNo.length; ++i) {
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(fuelType, 1, 4 * i), "ingot" + element + fissileNo[i], "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo);
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(fuelType, 1, 1 + 4 * i), "ingot" + element + fissileNo[i] + "Oxide", "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo);
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(fuelType, 1, 2 + 4 * i), "ingot" + element + fissileNo[i], "ingot" + element + fissileNo[i], "ingot" + element + fissileNo[i], "ingot" + element + fissileNo[i], "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo);
            CraftingRecipeHandler.addShapelessOreRecipe(new ItemStack(fuelType, 1, 3 + 4 * i), "ingot" + element + fissileNo[i] + "Oxide", "ingot" + element + fissileNo[i] + "Oxide", "ingot" + element + fissileNo[i] + "Oxide", "ingot" + element + fissileNo[i] + "Oxide", "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo, "ingot" + element + fertileNo);
        }
    }

    public static void fissionClumpRecipes(String element, Item material, int ... types) {
        for (int i = 0; i < types.length; ++i) {
            CraftingRecipeHandler.itemCompress(material, 4 * i, "ingot" + element + types[i] + "Base", "nugget" + element + types[i]);
            CraftingRecipeHandler.itemCompress(material, 1 + 4 * i, "ingot" + element + types[i] + "Oxide", "nugget" + element + types[i] + "Oxide");
            CraftingRecipeHandler.blockOpen(material, 2 + 4 * i, "nugget" + element + types[i], "ingot" + element + types[i] + "Base");
            CraftingRecipeHandler.blockOpen(material, 3 + 4 * i, "nugget" + element + types[i] + "Oxide", "ingot" + element + types[i] + "Oxide");
        }
    }

    public static void tinyClumpRecipes(String element, Item material, int ... types) {
        for (int i = 0; i < types.length; ++i) {
            CraftingRecipeHandler.itemCompress(material, 2 * i, "ingot" + element + types[i], "nugget" + element + types[i]);
            CraftingRecipeHandler.blockOpen(material, 1 + 2 * i, "nugget" + element + types[i], "ingot" + element + types[i]);
        }
    }

    public static void itemCompress(Item itemOut, int metaOut, String itemOutOreName, Object itemIn) {
        CraftingRecipeHandler.addShapedOreRecipe(OreDictHelper.getPrioritisedCraftingStack(new ItemStack(itemOut, 1, metaOut), itemOutOreName), "III", "III", "III", Character.valueOf('I'), itemIn);
    }

    public static void blockCompress(Block blockOut, int metaOut, String itemOutOreName, Object itemIn) {
        CraftingRecipeHandler.addShapedOreRecipe(OreDictHelper.getPrioritisedCraftingStack(new ItemStack(blockOut, 1, metaOut), itemOutOreName), "III", "III", "III", Character.valueOf('I'), itemIn);
    }

    public static void blockOpen(Item itemOut, int metaOut, String itemOutOreName, Object itemIn) {
        CraftingRecipeHandler.addShapelessOreRecipe(OreDictHelper.getPrioritisedCraftingStack(new ItemStack(itemOut, 9, metaOut), itemOutOreName), itemIn);
    }

    public static void tools(Object material, Item sword, Item pick, Item shovel, Item axe, Item hoe, Item spaxelhoe) {
        CraftingRecipeHandler.addShapedOreRecipe(sword, "M", "M", "S", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(pick, "MMM", " S ", " S ", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(shovel, "M", "S", "S", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(axe, "MM", "MS", " S", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(axe, "MM", "SM", "S ", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(hoe, "MM", " S", " S", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(hoe, "MM", "S ", "S ", Character.valueOf('M'), material, Character.valueOf('S'), "stickWood");
        CraftingRecipeHandler.addShapedOreRecipe(spaxelhoe, "ASP", "HIW", " I ", Character.valueOf('A'), axe, Character.valueOf('S'), shovel, Character.valueOf('P'), pick, Character.valueOf('H'), hoe, Character.valueOf('W'), sword, Character.valueOf('I'), "ingotIron");
    }

    public static void armor(Object material, Item helm, Item chest, Item legs, Item boots) {
        CraftingRecipeHandler.addShapedOreRecipe(helm, "MMM", "M M", Character.valueOf('M'), material);
        CraftingRecipeHandler.addShapedOreRecipe(chest, "M M", "MMM", "MMM", Character.valueOf('M'), material);
        CraftingRecipeHandler.addShapedOreRecipe(legs, "MMM", "M M", "M M", Character.valueOf('M'), material);
        CraftingRecipeHandler.addShapedOreRecipe(boots, "M M", "M M", Character.valueOf('M'), material);
    }

    public static void addShapedOreRecipe(Object out, Object ... inputs) {
        CraftingRecipeHandler.registerRecipe(ShapedOreRecipe.class, out, inputs);
    }

    public static void addShapedEnergyRecipe(Object out, Object ... inputs) {
        CraftingRecipeHandler.registerRecipe(ShapedEnergyRecipe.class, out, inputs);
    }

    public static void addShapedFluidRecipe(Object out, Object ... inputs) {
        CraftingRecipeHandler.registerRecipe(ShapedFluidRecipe.class, out, inputs);
    }

    public static void addShapelessOreRecipe(Object out, Object ... inputs) {
        CraftingRecipeHandler.registerRecipe(ShapelessOreRecipe.class, out, inputs);
    }

    public static void addShapelessFluidRecipe(Object out, Object ... inputs) {
        CraftingRecipeHandler.registerRecipe(ShapelessFluidRecipe.class, out, inputs);
    }

    public static void addShapelessArmorUpgradeRecipe(Object out, Object ... inputs) {
        CraftingRecipeHandler.registerRecipe(ShapelessArmorRadShieldingRecipe.class, out, inputs);
    }

    public static void registerRecipe(Class<? extends IRecipe> clazz, Object out, Object ... inputs) {
        if (out == null || Arrays.asList(inputs).contains(null)) {
            return;
        }
        ItemStack outStack = ItemStackHelper.fixItemStack(out);
        if (!outStack.func_190926_b() && inputs != null) {
            String outName = outStack.func_77977_a();
            if (RECIPE_COUNT_MAP.containsKey(outName)) {
                int count = RECIPE_COUNT_MAP.get(outName);
                RECIPE_COUNT_MAP.put(outName, count + 1);
                outName = outName + "_" + count;
            } else {
                RECIPE_COUNT_MAP.put(outName, 1);
            }
            ResourceLocation location = new ResourceLocation("nuclearcraft", outName);
            try {
                IRecipe recipe = NCUtil.newInstance(clazz, location, outStack, inputs);
                recipe.setRegistryName(location);
                ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

