/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.inventory;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.tile.ITile;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.InventoryTileWrapper;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.util.BlockHelper;
import nc.util.NCInventoryHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public interface ITileInventory
extends ITile {
    @Nonnull
    public NonNullList<ItemStack> getInventoryStacks();

    default public boolean hasCustomName() {
        return false;
    }

    default public int getSizeInventory() {
        return this.getInventoryStacks().size();
    }

    default public boolean isEmpty() {
        for (ItemStack itemstack : this.getInventoryStacks()) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.getInventoryStacks().get(slot);
    }

    default public ItemStack decrStackSize(int slot, int count) {
        return ItemStackHelper.func_188382_a(this.getInventoryStacks(), (int)slot, (int)count);
    }

    default public ItemStack removeStackFromSlot(int slot) {
        return ItemStackHelper.func_188383_a(this.getInventoryStacks(), (int)slot);
    }

    default public void setInventorySlotContents(int slot, ItemStack stack) {
        boolean flag;
        ItemStack itemstack = (ItemStack)this.getInventoryStacks().get(slot);
        boolean bl = flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && nc.util.ItemStackHelper.areItemStackTagsEqual(stack, itemstack);
        if (stack.func_190916_E() > this.getInventoryStackLimit()) {
            stack.func_190920_e(this.getInventoryStackLimit());
        }
        this.getInventoryStacks().set(slot, (Object)stack);
        if (!flag) {
            this.markTileDirty();
        }
    }

    default public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return true;
    }

    default public int getInventoryStackLimit() {
        return 64;
    }

    default public void clear() {
        this.getInventoryStacks().clear();
    }

    default public boolean isUsableByPlayer(EntityPlayer player) {
        return this.getTileWorld().func_175625_s(this.getTilePos()) != this ? false : player.func_70092_e((double)this.getTilePos().func_177958_n() + 0.5, (double)this.getTilePos().func_177956_o() + 0.5, (double)this.getTilePos().func_177952_p() + 0.5) <= 64.0;
    }

    default public void openInventory(EntityPlayer player) {
    }

    default public void closeInventory(EntityPlayer player) {
    }

    default public int getField(int id) {
        return 0;
    }

    default public void setField(int id, int value) {
    }

    default public int getFieldCount() {
        return 0;
    }

    public String getName();

    public ITextComponent getDisplayName();

    default public int[] getSlotsForFace(EnumFacing side) {
        return this.getInventoryConnection(side).getSlotsForFace();
    }

    default public boolean canInsertItem(int slot, ItemStack stack, EnumFacing side) {
        return this.getItemSorption(side, slot).canReceive();
    }

    default public boolean canExtractItem(int slot, ItemStack stack, EnumFacing side) {
        return this.getItemSorption(side, slot).canExtract();
    }

    @Nonnull
    public InventoryConnection[] getInventoryConnections();

    public void setInventoryConnections(@Nonnull InventoryConnection[] var1);

    @Nonnull
    default public InventoryConnection getInventoryConnection(@Nonnull EnumFacing side) {
        return this.getInventoryConnections()[side.func_176745_a()];
    }

    @Nonnull
    default public ItemSorption getItemSorption(@Nonnull EnumFacing side, int slotNumber) {
        return this.getInventoryConnections()[side.func_176745_a()].getItemSorption(slotNumber);
    }

    default public void setItemSorption(@Nonnull EnumFacing side, int slotNumber, @Nonnull ItemSorption sorption) {
        this.getInventoryConnections()[side.func_176745_a()].setItemSorption(slotNumber, sorption);
    }

    default public void toggleItemSorption(@Nonnull EnumFacing side, int slotNumber, ItemSorption.Type type, boolean reverse) {
        if (!this.hasConfigurableInventoryConnections()) {
            return;
        }
        this.getInventoryConnection(side).toggleItemSorption(slotNumber, type, reverse);
        this.markDirtyAndNotify();
    }

    default public boolean canConnectInventory(@Nonnull EnumFacing side) {
        return this.getInventoryConnection(side).canConnect();
    }

    public static InventoryConnection[] inventoryConnectionAll(@Nonnull List<ItemSorption> sorptionList) {
        InventoryConnection[] array = new InventoryConnection[6];
        for (int i = 0; i < 6; ++i) {
            array[i] = new InventoryConnection(sorptionList);
        }
        return array;
    }

    public static InventoryConnection[] inventoryConnectionAll(ItemSorption sorption) {
        return ITileInventory.inventoryConnectionAll(Lists.newArrayList((Object[])new ItemSorption[]{sorption}));
    }

    default public boolean hasConfigurableInventoryConnections() {
        return false;
    }

    @Nonnull
    public InventoryTileWrapper getInventory();

    default public void pushStacks() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.pushStacksToSide(side);
        }
    }

    default public void pushStacksToSide(@Nonnull EnumFacing side) {
        IItemHandler adjInv;
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        IItemHandler iItemHandler = adjInv = tile == null ? null : (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
        if (adjInv == null || adjInv.getSlots() < 1) {
            return;
        }
        for (int i = 0; i < this.getInventoryStacks().size(); ++i) {
            ItemStack initialStack;
            ItemStack inserted;
            if (((ItemStack)this.getInventoryStacks().get(i)).func_190926_b() || (inserted = NCInventoryHelper.addStackToInventory(adjInv, initialStack = ((ItemStack)this.getInventoryStacks().get(i)).func_77946_l())).func_190916_E() >= initialStack.func_190916_E()) continue;
            ((ItemStack)this.getInventoryStacks().get(i)).func_190918_g(initialStack.func_190916_E() - inserted.func_190916_E());
            if (((ItemStack)this.getInventoryStacks().get(i)).func_190916_E() > 0) continue;
            this.getInventoryStacks().set(i, (Object)ItemStack.field_190927_a);
        }
    }

    default public NBTTagCompound writeInventory(NBTTagCompound nbt) {
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.getInventoryStacks());
        return nbt;
    }

    default public void readInventory(NBTTagCompound nbt) {
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.getInventoryStacks());
    }

    default public NBTTagCompound writeInventoryConnections(NBTTagCompound nbt) {
        return this.writeInventoryConnectionsNormalized(nbt, EnumFacing.WEST);
    }

    default public NBTTagCompound writeInventoryConnectionsNormalized(NBTTagCompound nbt, EnumFacing facing) {
        this.getInventoryConnection(BlockHelper.bottom(facing)).writeToNBT(nbt, EnumFacing.DOWN);
        this.getInventoryConnection(BlockHelper.top(facing)).writeToNBT(nbt, EnumFacing.UP);
        this.getInventoryConnection(BlockHelper.left(facing)).writeToNBT(nbt, EnumFacing.NORTH);
        this.getInventoryConnection(BlockHelper.right(facing)).writeToNBT(nbt, EnumFacing.SOUTH);
        this.getInventoryConnection(BlockHelper.front(facing)).writeToNBT(nbt, EnumFacing.WEST);
        this.getInventoryConnection(BlockHelper.back(facing)).writeToNBT(nbt, EnumFacing.EAST);
        return nbt;
    }

    default public void readInventoryConnections(NBTTagCompound nbt) {
        this.readInventoryConnectionsNormalized(nbt, EnumFacing.WEST);
    }

    default public void readInventoryConnectionsNormalized(NBTTagCompound nbt, EnumFacing facing) {
        if (!this.hasConfigurableInventoryConnections()) {
            return;
        }
        this.getInventoryConnection(BlockHelper.bottom(facing)).readFromNBT(nbt, EnumFacing.DOWN);
        this.getInventoryConnection(BlockHelper.top(facing)).readFromNBT(nbt, EnumFacing.UP);
        this.getInventoryConnection(BlockHelper.left(facing)).readFromNBT(nbt, EnumFacing.NORTH);
        this.getInventoryConnection(BlockHelper.right(facing)).readFromNBT(nbt, EnumFacing.SOUTH);
        this.getInventoryConnection(BlockHelper.front(facing)).readFromNBT(nbt, EnumFacing.WEST);
        this.getInventoryConnection(BlockHelper.back(facing)).readFromNBT(nbt, EnumFacing.EAST);
    }

    default public NBTTagCompound writeSlotSettings(NBTTagCompound nbt) {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            nbt.func_74768_a("itemOutputSetting" + i, this.getItemOutputSetting(i).ordinal());
        }
        return nbt;
    }

    default public void readSlotSettings(NBTTagCompound nbt) {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            this.setItemOutputSetting(i, ItemOutputSetting.values()[nbt.func_74762_e("itemOutputSetting" + i)]);
        }
    }

    public ItemOutputSetting getItemOutputSetting(int var1);

    public void setItemOutputSetting(int var1, ItemOutputSetting var2);

    default public boolean hasInventorySideCapability(@Nullable EnumFacing side) {
        return side == null || this.getInventoryConnection(side).canConnect();
    }

    default public IItemHandler getItemHandlerCapability(@Nullable EnumFacing side) {
        return (IItemHandler)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast(side == null ? new InvWrapper((IInventory)this.getInventory()) : new SidedInvWrapper((ISidedInventory)this.getInventory(), side));
    }
}

