/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.client.renderer.HeightMapRenderer;
import openblocks.common.HeightMapData;
import openblocks.common.MapDataManager;
import openblocks.common.tileentity.TileEntityProjector;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class TileEntityProjectorRenderer
extends TileEntitySpecialRenderer<TileEntityProjector> {
    private static final float BLOCK_CENTRE_TRANSLATION = 0.5f;
    private final ModelResourceLocation spinnerModelLocation;
    private IBakedModel bakedSpinnerModel;
    private static BlockModelRenderer blockModelRenderer;

    public TileEntityProjectorRenderer(ModelResourceLocation spinnerModel) {
        this.spinnerModelLocation = spinnerModel;
    }

    public void render(TileEntityProjector projector, double x, double y, double z, float partialTickTime, int destroyProgess, float alpha) {
        int pass = MinecraftForgeClient.getRenderPass();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        int mapId = projector.mapId();
        if (pass <= 0) {
            this.renderProjector(projector, partialTickTime, x, y, z);
        } else {
            TileEntityProjectorRenderer.renderMap(projector, mapId, x, y, z);
        }
    }

    private static void renderMap(TileEntityProjector projector, int mapId, double x, double y, double z) {
        HeightMapData data;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glRotated((double)(90 * projector.rotation()), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)0.0, (double)-0.5);
        World world = projector.func_145831_w();
        if (world != null && (data = MapDataManager.getMapData(world, mapId)).isValid()) {
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
            HeightMapRenderer.instance.render(mapId, data);
        }
        GL11.glPopMatrix();
    }

    private void renderProjector(TileEntityProjector projector, float partialTickTime, double x, double y, double z) {
        IExtendedBlockState exState;
        if (this.bakedSpinnerModel == null) {
            return;
        }
        if (!projector.hasCapability(CapabilityAnimation.ANIMATION_CAPABILITY, null)) {
            return;
        }
        if (blockModelRenderer == null) {
            blockModelRenderer = Minecraft.func_71410_x().func_175602_ab().func_175019_b();
        }
        BlockPos pos = projector.func_174877_v();
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)projector.func_145831_w(), (BlockPos)pos);
        IBlockState state = world.func_180495_p(pos);
        if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains(Properties.AnimationProperty)) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vb = tessellator.func_178180_c();
            this.func_147499_a(TextureMap.field_110575_b);
            RenderHelper.func_74518_a();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            float time = Animation.getWorldTime((World)this.func_178459_a(), (float)partialTickTime);
            Pair pair = ((IAnimationStateMachine)projector.getCapability(CapabilityAnimation.ANIMATION_CAPABILITY, null)).apply(time);
            exState = exState.withProperty(Properties.AnimationProperty, pair.getLeft());
            vb.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
            blockModelRenderer.func_178267_a((IBlockAccess)world, this.bakedSpinnerModel, (IBlockState)exState, pos, vb, false);
            vb.func_178969_c(0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            RenderHelper.func_74519_b();
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent evt) {
        IModel model = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)this.spinnerModelLocation);
        this.bakedSpinnerModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
    }
}

