/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model.json;

import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.model.ResourceLoaderContext;
import buildcraft.lib.client.model.json.JsonVariableModelPart;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import buildcraft.lib.misc.ExpressionCompat;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;

public abstract class JsonModelRule {
    public final IExpressionNode.INodeBoolean when;

    public JsonModelRule(IExpressionNode.INodeBoolean when) {
        this.when = when;
    }

    public static JsonModelRule deserialize(JsonElement json, FunctionContext fnCtx, ResourceLoaderContext ctx) {
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected an object, got " + json);
        }
        JsonObject obj = json.getAsJsonObject();
        String when = JsonUtils.func_151200_h((JsonObject)obj, (String)"when");
        IExpressionNode.INodeBoolean nodeWhen = JsonVariableModelPart.convertStringToBooleanNode(when, fnCtx);
        String type = JsonUtils.func_151200_h((JsonObject)obj, (String)"type");
        if (type.startsWith("builtin:")) {
            String builtin = type.substring("builtin:".length());
            if ("rotate_facing".equals(builtin)) {
                fnCtx = new FunctionContext(fnCtx, ExpressionCompat.ENUM_FACING);
                String from = JsonUtils.func_151200_h((JsonObject)obj, (String)"from");
                IExpressionNode.INodeObject<EnumFacing> nodeFrom = JsonVariableModelPart.convertStringToObjectNode(from, fnCtx, EnumFacing.class);
                String to = JsonUtils.func_151200_h((JsonObject)obj, (String)"to");
                IExpressionNode.INodeObject<EnumFacing> nodeTo = JsonVariableModelPart.convertStringToObjectNode(to, fnCtx, EnumFacing.class);
                IExpressionNode.INodeDouble[] origin = obj.has("origin") ? JsonVariableModelPart.readVariablePosition(obj, "origin", fnCtx) : RuleRotateFacing.DEFAULT_ORIGIN;
                return new RuleRotateFacing(nodeWhen, nodeFrom, nodeTo, origin);
            }
            if ("rotate".equals(builtin)) {
                IExpressionNode.INodeDouble[] origin = obj.has("origin") ? JsonVariableModelPart.readVariablePosition(obj, "origin", fnCtx) : RuleRotate.DEFAULT_ORIGIN;
                IExpressionNode.INodeDouble[] angles = JsonVariableModelPart.readVariablePosition(obj, "angle", fnCtx);
                return new RuleRotate(nodeWhen, origin, angles);
            }
            if ("scale".equals(builtin)) {
                IExpressionNode.INodeDouble[] origin = obj.has("origin") ? JsonVariableModelPart.readVariablePosition(obj, "origin", fnCtx) : RuleRotate.DEFAULT_ORIGIN;
                IExpressionNode.INodeDouble[] scales = JsonVariableModelPart.readVariablePosition(obj, "scale", fnCtx);
                return new RuleScale(nodeWhen, origin, scales);
            }
            throw new JsonSyntaxException("Unknown built in rule type '" + builtin + "'");
        }
        throw new JsonSyntaxException("Unknown rule type '" + type + "'");
    }

    public abstract void apply(List<MutableQuad> var1);

    public static class RuleScale
    extends JsonModelRule {
        private static final NodeConstantDouble CONST_ORIGIN = new NodeConstantDouble(0.5);
        public static final IExpressionNode.INodeDouble[] DEFAULT_ORIGIN = new IExpressionNode.INodeDouble[]{CONST_ORIGIN, CONST_ORIGIN, CONST_ORIGIN};
        public final IExpressionNode.INodeDouble[] origin;
        public final IExpressionNode.INodeDouble[] scale;

        public RuleScale(IExpressionNode.INodeBoolean when, IExpressionNode.INodeDouble[] origin, IExpressionNode.INodeDouble[] scale) {
            super(when);
            this.origin = origin;
            this.scale = scale;
        }

        @Override
        public void apply(List<MutableQuad> quads) {
            float ox = (float)this.origin[0].evaluate() / 16.0f;
            float oy = (float)this.origin[1].evaluate() / 16.0f;
            float oz = (float)this.origin[2].evaluate() / 16.0f;
            float sx = (float)this.scale[0].evaluate();
            float sy = (float)this.scale[1].evaluate();
            float sz = (float)this.scale[2].evaluate();
            if (sx == 1.0f && sy == 1.0f && sz == 1.0f) {
                return;
            }
            for (MutableQuad q : quads) {
                q.translatef(-ox, -oy, -oz);
                q.scalef(sx, sy, sz);
                q.translatef(ox, oy, oz);
            }
        }
    }

    public static class RuleRotate
    extends JsonModelRule {
        private static final NodeConstantDouble CONST_ORIGIN = new NodeConstantDouble(0.5);
        public static final IExpressionNode.INodeDouble[] DEFAULT_ORIGIN = new IExpressionNode.INodeDouble[]{CONST_ORIGIN, CONST_ORIGIN, CONST_ORIGIN};
        public final IExpressionNode.INodeDouble[] origin;
        public final IExpressionNode.INodeDouble[] angle;

        public RuleRotate(IExpressionNode.INodeBoolean when, IExpressionNode.INodeDouble[] origin, IExpressionNode.INodeDouble[] angle) {
            super(when);
            this.origin = origin;
            this.angle = angle;
        }

        @Override
        public void apply(List<MutableQuad> quads) {
            float ox = (float)this.origin[0].evaluate() / 16.0f;
            float oy = (float)this.origin[1].evaluate() / 16.0f;
            float oz = (float)this.origin[2].evaluate() / 16.0f;
            float ax = (float)Math.toRadians(this.angle[0].evaluate());
            float ay = (float)Math.toRadians(this.angle[1].evaluate());
            float az = (float)Math.toRadians(this.angle[2].evaluate());
            if (ax == 0.0f && ay == 0.0f && az == 0.0f) {
                return;
            }
            float cx = MathHelper.func_76134_b((float)ax);
            float cy = MathHelper.func_76134_b((float)ay);
            float cz = MathHelper.func_76134_b((float)az);
            float sx = MathHelper.func_76126_a((float)ax);
            float sy = MathHelper.func_76126_a((float)ay);
            float sz = MathHelper.func_76126_a((float)az);
            for (MutableQuad q : quads) {
                q.translatef(-ox, -oy, -oz);
                if (cx != 1.0f) {
                    q.rotateDirectlyX(cx, sx);
                }
                if (cy != 1.0f) {
                    q.rotateDirectlyY(cy, sy);
                }
                if (cz != 1.0f) {
                    q.rotateDirectlyZ(cz, sz);
                }
                q.translatef(ox, oy, oz);
            }
        }
    }

    public static class RuleRotateFacing
    extends JsonModelRule {
        private static final NodeConstantDouble CONST_ORIGIN = new NodeConstantDouble(8.0);
        public static final IExpressionNode.INodeDouble[] DEFAULT_ORIGIN = new IExpressionNode.INodeDouble[]{CONST_ORIGIN, CONST_ORIGIN, CONST_ORIGIN};
        public final IExpressionNode.INodeObject<EnumFacing> from;
        public final IExpressionNode.INodeObject<EnumFacing> to;
        public final IExpressionNode.INodeDouble[] origin;

        public RuleRotateFacing(IExpressionNode.INodeBoolean when, IExpressionNode.INodeObject<EnumFacing> from, IExpressionNode.INodeObject<EnumFacing> to, IExpressionNode.INodeDouble[] origin) {
            super(when);
            this.from = from;
            this.to = to;
            this.origin = origin;
        }

        @Override
        public void apply(List<MutableQuad> quads) {
            EnumFacing faceTo;
            EnumFacing faceFrom = this.from.evaluate();
            if (faceFrom == (faceTo = this.to.evaluate())) {
                return;
            }
            float ox = (float)this.origin[0].evaluate() / 16.0f;
            float oy = (float)this.origin[1].evaluate() / 16.0f;
            float oz = (float)this.origin[2].evaluate() / 16.0f;
            for (MutableQuad q : quads) {
                q.rotate(faceFrom, faceTo, ox, oy, oz);
            }
        }
    }
}

