/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.statements.StatementManager;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.transport.BCTransportConfig;
import buildcraft.transport.pipe.behaviour.PipeBehaviourEmzuli;
import buildcraft.transport.statements.ActionExtractionPreset;
import buildcraft.transport.statements.ActionParameterSignal;
import buildcraft.transport.statements.ActionPipeColor;
import buildcraft.transport.statements.ActionPipeDirection;
import buildcraft.transport.statements.ActionPipeSignal;
import buildcraft.transport.statements.ActionPowerLimit;
import buildcraft.transport.statements.ActionProviderPipes;
import buildcraft.transport.statements.TriggerFluidsTraversing;
import buildcraft.transport.statements.TriggerItemsTraversing;
import buildcraft.transport.statements.TriggerParameterSignal;
import buildcraft.transport.statements.TriggerPipeSignal;
import buildcraft.transport.statements.TriggerPowerRequested;
import buildcraft.transport.statements.TriggerProviderPipes;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;

public class BCTransportStatements {
    public static final TriggerPipeSignal[] TRIGGER_PIPE_SIGNAL = new TriggerPipeSignal[2 * ColourUtil.COLOURS.length];
    public static final TriggerPowerRequested TRIGGER_POWER_REQUESTED;
    public static final TriggerItemsTraversing TRIGGER_ITEMS_TRAVERSING;
    public static final TriggerFluidsTraversing TRIGGER_FLUIDS_TRAVERSING;
    public static final ActionPipeSignal[] ACTION_PIPE_SIGNAL;
    public static final ActionPipeColor[] ACTION_PIPE_COLOUR;
    public static final ActionExtractionPreset[] ACTION_EXTRACTION_PRESET;
    public static final ActionPipeDirection[] ACTION_PIPE_DIRECTION;
    public static final ActionPowerLimit.ActionIronPowerLimit[] ACTION_IRON_POWER_LIMIT;
    public static final ActionPowerLimit.ActionDiamondPowerLimit[] ACTION_DIAMOND_POWER_LIMIT;
    public static final ActionPowerLimit.ActionIronRfLimit[] ACTION_IRON_RF_LIMIT;
    public static final ActionPowerLimit.ActionDiamondRfLimit[] ACTION_DIAMOND_RF_LIMIT;

    public static void preInit() {
        StatementManager.registerTriggerProvider(TriggerProviderPipes.INSTANCE);
        StatementManager.registerActionProvider(ActionProviderPipes.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    static {
        for (EnumDyeColor enumDyeColor : ColourUtil.COLOURS) {
            BCTransportStatements.TRIGGER_PIPE_SIGNAL[enumDyeColor.ordinal() * 2 + 0] = new TriggerPipeSignal(true, enumDyeColor);
            BCTransportStatements.TRIGGER_PIPE_SIGNAL[enumDyeColor.ordinal() * 2 + 1] = new TriggerPipeSignal(false, enumDyeColor);
        }
        ACTION_PIPE_SIGNAL = new ActionPipeSignal[ColourUtil.COLOURS.length];
        for (EnumDyeColor enumDyeColor : ColourUtil.COLOURS) {
            BCTransportStatements.ACTION_PIPE_SIGNAL[enumDyeColor.ordinal()] = new ActionPipeSignal(enumDyeColor);
        }
        ACTION_PIPE_COLOUR = new ActionPipeColor[ColourUtil.COLOURS.length];
        for (EnumDyeColor enumDyeColor : ColourUtil.COLOURS) {
            BCTransportStatements.ACTION_PIPE_COLOUR[enumDyeColor.ordinal()] = new ActionPipeColor(enumDyeColor);
        }
        ACTION_EXTRACTION_PRESET = new ActionExtractionPreset[PipeBehaviourEmzuli.SlotIndex.VALUES.length];
        for (PipeBehaviourEmzuli.SlotIndex slotIndex : PipeBehaviourEmzuli.SlotIndex.VALUES) {
            BCTransportStatements.ACTION_EXTRACTION_PRESET[slotIndex.ordinal()] = new ActionExtractionPreset(slotIndex);
        }
        ACTION_PIPE_DIRECTION = new ActionPipeDirection[EnumFacing.field_82609_l.length];
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            BCTransportStatements.ACTION_PIPE_DIRECTION[enumFacing.ordinal()] = new ActionPipeDirection(enumFacing);
        }
        TRIGGER_POWER_REQUESTED = new TriggerPowerRequested();
        TRIGGER_ITEMS_TRAVERSING = new TriggerItemsTraversing();
        TRIGGER_FLUIDS_TRAVERSING = new TriggerFluidsTraversing();
        ACTION_IRON_POWER_LIMIT = new ActionPowerLimit.ActionIronPowerLimit[7];
        ACTION_DIAMOND_POWER_LIMIT = new ActionPowerLimit.ActionDiamondPowerLimit[7];
        ACTION_IRON_RF_LIMIT = new ActionPowerLimit.ActionIronRfLimit[7];
        ACTION_DIAMOND_RF_LIMIT = new ActionPowerLimit.ActionDiamondRfLimit[7];
        boolean bl = false;
        for (int shift = 6; shift >= 0; --shift) {
            void var0_6;
            BCTransportStatements.ACTION_IRON_POWER_LIMIT[var0_6] = new ActionPowerLimit.ActionIronPowerLimit(shift);
            BCTransportStatements.ACTION_DIAMOND_POWER_LIMIT[var0_6] = new ActionPowerLimit.ActionDiamondPowerLimit(shift);
            if (!BCTransportConfig.disableRfPipe) {
                BCTransportStatements.ACTION_IRON_RF_LIMIT[var0_6] = new ActionPowerLimit.ActionIronRfLimit(shift);
                BCTransportStatements.ACTION_DIAMOND_RF_LIMIT[var0_6] = new ActionPowerLimit.ActionDiamondRfLimit(shift);
            }
            ++var0_6;
        }
        StatementManager.registerParameter(TriggerParameterSignal::readFromNbt, TriggerParameterSignal::readFromBuf);
        StatementManager.registerParameter(ActionParameterSignal::readFromNbt);
    }
}

