/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.flow;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.pipe.IFlowRedstoneFlux;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeEventRedstoneFlux;
import buildcraft.api.transport.pipe.PipeFlow;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.AverageInt;
import buildcraft.transport.pipe.flow.IPipeTransportRfHook;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;

public class PipeFlowRedstoneFlux
extends PipeFlow
implements IFlowRedstoneFlux,
IDebuggable {
    private static final int DEFAULT_MAX_POWER = 100;
    public static final int NET_POWER_AMOUNTS = 2;
    public Vec3d clientDisplayFlowCentre = VecUtil.VEC_HALF;
    public Vec3d clientDisplayFlowCentreLast = VecUtil.VEC_HALF;
    public long clientLastDisplayTime = 0L;
    private int maxPower = -1;
    private boolean disabled = false;
    private long currentWorldTime;
    private boolean isReceiver = false;
    private final EnumMap<EnumFacing, Section> sections;

    public PipeFlowRedstoneFlux(IPipe pipe) {
        super(pipe);
        this.sections = new EnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            this.sections.put(face, new Section(face));
        }
    }

    public PipeFlowRedstoneFlux(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.isReceiver = nbt.func_74767_n("isReceiver");
        this.sections = new EnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            this.sections.put(face, new Section(face));
        }
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74757_a("isReceiver", this.isReceiver);
        return nbt;
    }

    @Override
    public void writePayload(int id, PacketBuffer buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && (id == 2 || id == 0)) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                Section s = this.sections.get(face);
                buffer.writeInt(s.displayPower);
                buffer.func_179249_a((Enum)s.displayFlow);
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBuffer buffer, Side side) throws IOException {
        super.readPayload(id, buffer, side);
        if (side == Side.CLIENT && (id == 2 || id == 0)) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                Section s = this.sections.get(face);
                s.displayPower = buffer.readInt();
                s.displayFlow = (EnumFlow)buffer.func_179257_a(EnumFlow.class);
            }
        }
    }

    @Override
    public boolean canConnect(EnumFacing face, PipeFlow other) {
        return other instanceof PipeFlowRedstoneFlux;
    }

    @Override
    public boolean canConnect(EnumFacing face, TileEntity oTile) {
        return oTile.hasCapability(CapabilityEnergy.ENERGY, face.func_176734_d());
    }

    @Override
    public void reconfigure() {
        PipeEventRedstoneFlux.Configure configure = new PipeEventRedstoneFlux.Configure(this.pipe.getHolder(), this);
        PipeApi.RedstoneFluxTransferInfo pti = PipeApi.getRfTransferInfo(this.pipe.getDefinition());
        configure.setReceiver(pti.isReceiver);
        configure.setMaxPower(pti.transferPerTick);
        this.pipe.getHolder().fireEvent(configure);
        this.isReceiver = configure.isReceiver();
        this.maxPower = configure.getMaxPower();
        this.disabled = configure.isTransferDisabled();
        if (this.maxPower <= 0) {
            this.maxPower = 100;
        }
    }

    @Override
    public int tryExtractPower(int maxExtracted, EnumFacing from) {
        if (!this.isReceiver || this.disabled) {
            return 0;
        }
        TileEntity tile = this.pipe.getConnectedTile(from);
        if (tile == null) {
            return 0;
        }
        IEnergyStorage storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, from.func_176734_d());
        if (storage == null) {
            return 0;
        }
        return 0;
    }

    @Override
    public boolean onFlowActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        return super.onFlowActivate(player, trace, hitX, hitY, hitZ, part);
    }

    public Section getSection(EnumFacing side) {
        return this.sections.get(side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (facing == null) {
            return null;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)(this.isReceiver ? CapabilityEnergy.ENERGY.cast((Object)this.sections.get(facing)) : null);
        }
        return null;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("maxPower = " + this.maxPower);
        left.add("isReceiver = " + this.isReceiver);
        left.add("internalPower = " + this.arrayToString(s -> s.internalPower) + " <- " + this.arrayToString(s -> s.internalNextPower));
        left.add("- powerQuery: " + this.arrayToString(s -> s.powerQuery) + " <- " + this.arrayToString(s -> s.nextPowerQuery));
        left.add("- power: IN " + this.arrayToString(s -> s.debugPowerInput) + ", OUT " + this.arrayToString(s -> s.debugPowerOutput));
        left.add("- power: OFFERED " + this.arrayToString(s -> s.debugPowerOffered));
    }

    private String arrayToString(ToIntFunction<Section> getter) {
        long[] arr = new long[6];
        for (EnumFacing face : EnumFacing.field_82609_l) {
            arr[face.ordinal()] = getter.applyAsInt(this.sections.get(face));
        }
        return Arrays.toString(arr);
    }

    @Override
    public void onTick() {
        Section s;
        if (this.maxPower == -1) {
            this.reconfigure();
        }
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            this.clientDisplayFlowCentreLast = this.clientDisplayFlowCentre;
            for (EnumFacing face : EnumFacing.field_82609_l) {
                Section s2 = this.sections.get(face);
                s2.clientDisplayFlowLast = s2.clientDisplayFlow;
                double diff = (double)s2.displayFlow.value * 2.4 * (double)face.func_176743_c().func_179524_a();
                s2.clientDisplayFlow += 16.0 + diff;
                s2.clientDisplayFlow %= 16.0;
                double cVal = VecUtil.getValue(this.clientDisplayFlowCentre, face.func_176740_k());
                cVal += 16.0 + diff / 2.0;
                this.clientDisplayFlowCentre = VecUtil.replaceValue(this.clientDisplayFlowCentre, face.func_176740_k(), cVal %= 16.0);
            }
            return;
        }
        EnumFlow[] lastFlows = new EnumFlow[6];
        int[] lastDisplayPower = new int[6];
        for (Object face : EnumFacing.field_82609_l) {
            s = this.sections.get(face);
            int i = face.ordinal();
            lastFlows[i] = s.displayFlow;
            lastDisplayPower[i] = s.displayPower;
        }
        this.step();
        this.init();
        for (Object face : EnumFacing.field_82609_l) {
            s = this.sections.get(face);
            if (s.internalPower <= 0) continue;
            int totalPowerQuery = 0;
            EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
            int n = enumFacingArray.length;
            for (int i = 0; i < n; ++i) {
                EnumFacing face2 = enumFacingArray[i];
                if (face == face2) continue;
                totalPowerQuery += this.sections.get((Object)face2).powerQuery;
            }
            boolean returnPower = false;
            if (totalPowerQuery <= 0 && s.powerQuery > 0) {
                totalPowerQuery = s.powerQuery;
                returnPower = true;
            }
            if (totalPowerQuery <= 0) continue;
            int unusedPowerQuery = totalPowerQuery;
            for (EnumFacing face2 : EnumFacing.field_82609_l) {
                if (face == face2 && !returnPower) continue;
                Section s2 = this.sections.get(face2);
                if (s2.powerQuery <= 0) continue;
                int watts = (int)Math.min((long)s.internalPower * (long)s2.powerQuery / (long)unusedPowerQuery, (long)s.internalPower);
                unusedPowerQuery -= s2.powerQuery;
                IPipe neighbour = this.pipe.getConnectedPipe(face2);
                int leftover = watts;
                if (neighbour != null && neighbour.getFlow() instanceof PipeFlowRedstoneFlux && neighbour.isConnected(face2.func_176734_d())) {
                    PipeFlowRedstoneFlux oFlow = (PipeFlowRedstoneFlux)neighbour.getFlow();
                    leftover = oFlow.sections.get(face2.func_176734_d()).receivePowerInternal(watts);
                } else {
                    IEnergyStorage receiver = (IEnergyStorage)this.pipe.getHolder().getCapabilityFromPipe(face2, CapabilityEnergy.ENERGY);
                    if (receiver != null && receiver.canReceive()) {
                        int accepted = receiver.receiveEnergy(watts, false);
                        leftover = watts - accepted;
                    }
                }
                int used = watts - leftover;
                s.internalPower -= used;
                s2.debugPowerOutput += used;
                s.powerAverage.push(used);
                s2.powerAverage.push(used);
                s.displayFlow = EnumFlow.OUT;
                s2.displayFlow = EnumFlow.IN;
            }
        }
        for (Section s3 : this.sections.values()) {
            s3.powerAverage.tick();
            double value = s3.powerAverage.getAverage() / (double)this.maxPower;
            value = Math.sqrt(value);
            s3.displayPower = (int)(value * (double)MjAPI.MJ);
        }
        for (Object face : EnumFacing.field_82609_l) {
            int requested;
            IEnergyStorage recv;
            if (this.pipe.getConnectedType((EnumFacing)face) != IPipe.ConnectedType.TILE || (recv = (IEnergyStorage)this.pipe.getHolder().getCapabilityFromPipe((EnumFacing)face, CapabilityEnergy.ENERGY)) == null || !recv.canReceive() || (requested = recv.getMaxEnergyStored() - recv.getEnergyStored()) <= 0) continue;
            this.requestPower((EnumFacing)face, requested);
        }
        int[] transferQueryTemp = new int[6];
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!this.pipe.isConnected(face)) continue;
            int query = 0;
            for (EnumFacing face2 : EnumFacing.field_82609_l) {
                if (face == face2) continue;
                query += this.sections.get((Object)face2).powerQuery;
            }
            transferQueryTemp[face.ordinal()] = query;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            IPipe oPipe;
            if (this.disabled || transferQueryTemp[face.ordinal()] <= 0 || !this.pipe.isConnected(face) || (oPipe = this.pipe.getHolder().getNeighbourPipe(face)) == null || !(oPipe.getFlow() instanceof PipeFlowRedstoneFlux)) continue;
            PipeFlowRedstoneFlux oFlow = (PipeFlowRedstoneFlux)oPipe.getFlow();
            oFlow.requestPower(face.func_176734_d(), transferQueryTemp[face.ordinal()]);
        }
        boolean didChange = false;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            Section s4 = this.sections.get(face);
            int i = face.ordinal();
            if (lastFlows[i] == s4.displayFlow && lastDisplayPower[i] == s4.displayPower) continue;
            didChange = true;
            break;
        }
        if (didChange) {
            this.sendPayload(2);
        }
    }

    private void step() {
        long now = this.pipe.getHolder().getPipeWorld().func_82737_E();
        if (this.currentWorldTime != now) {
            this.currentWorldTime = now;
            this.sections.values().forEach(Section::step);
        }
    }

    private void init() {
    }

    private void requestPower(EnumFacing from, int amount) {
        this.step();
        Section s = this.sections.get(from);
        s.nextPowerQuery = this.pipe.getBehaviour() instanceof IPipeTransportRfHook ? (s.nextPowerQuery += ((IPipeTransportRfHook)((Object)this.pipe.getBehaviour())).requestPower(from, amount)) : (s.nextPowerQuery += amount);
        s.nextPowerQuery = Math.min(s.nextPowerQuery, this.maxPower);
    }

    public int getPowerRequested(@Nullable EnumFacing side) {
        int req = 0;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (side != null && face == side) continue;
            req += this.sections.get((Object)face).powerQuery;
        }
        return req;
    }

    public double getMaxTransferForRender(float partialTicks) {
        return (double)this.maxPower / (double)MjAPI.MJ;
    }

    public static enum EnumFlow {
        IN(-1),
        OUT(1),
        STATIONARY(0);

        public final int value;

        private EnumFlow(int value) {
            this.value = value;
        }
    }

    public class Section
    implements IEnergyStorage {
        public final EnumFacing side;
        public final AverageInt clientDisplayAverage = new AverageInt(10);
        public double clientDisplayFlow;
        public double clientDisplayFlowLast;
        public int displayPower;
        public EnumFlow displayFlow = EnumFlow.STATIONARY;
        public int nextPowerQuery;
        public int internalNextPower;
        public final AverageInt powerAverage = new AverageInt(1);
        int powerQuery;
        int internalPower;
        int debugPowerInput;
        int debugPowerOutput;
        int debugPowerOffered;

        public Section(EnumFacing side) {
            this.side = side;
            this.clientDisplayFlow = (double)(side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 7 : 1) / 8.0;
        }

        void step() {
            this.powerQuery = this.nextPowerQuery;
            this.nextPowerQuery = 0;
            this.internalPower += this.internalNextPower;
            this.internalNextPower = 0;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return PipeFlowRedstoneFlux.this.isReceiver;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (PipeFlowRedstoneFlux.this.isReceiver) {
                if (!simulate) {
                    return maxReceive - this.receivePowerInternal(maxReceive);
                }
                return maxReceive;
            }
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return this.internalPower + this.internalNextPower;
        }

        public int getMaxEnergyStored() {
            return PipeFlowRedstoneFlux.this.maxPower;
        }

        int receivePowerInternal(int sent) {
            if (sent > 0) {
                PipeFlowRedstoneFlux.this.step();
                int max = PipeFlowRedstoneFlux.this.maxPower - this.internalNextPower;
                if (max < 0) {
                    return sent;
                }
                int accepted = Math.min(max, sent);
                this.debugPowerOffered += accepted;
                this.internalNextPower += accepted;
                return sent - accepted;
            }
            return sent;
        }
    }
}

