/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.tile;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import com.vladmarica.energymeters.energy.EnergyTypes;
import com.vladmarica.energymeters.energy.storage.MJStorage;
import com.vladmarica.energymeters.integration.BuildcraftIntegration;
import com.vladmarica.energymeters.tile.TileEntityEnergyMeterBase;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityEnergyMeterMJ
extends TileEntityEnergyMeterBase {
    private MJStorage inputMJStorage;
    private MJStorage outputMJStorage;

    public TileEntityEnergyMeterMJ() {
        super(EnergyTypes.MJ);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.inputMJStorage = new MJStorage(this, this.inputSide, false);
            this.outputMJStorage = new MJStorage(this, this.outputSide, true);
        }
    }

    @Override
    public int getEnergyScale() {
        return 10;
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        return true;
    }

    @Override
    public boolean canEmitEnergy(EnumFacing side) {
        return true;
    }

    @Override
    public long getRequestedEnergy(EnumFacing side) {
        BlockPos outputNeighbor;
        IMjReceiver outputReciever;
        if (!this.isFullyConnected() || this.isDisabled() || side == this.outputSide) {
            return 0L;
        }
        if (this.outputSide != null && (outputReciever = BuildcraftIntegration.getMJReciever(this.field_145850_b, outputNeighbor = this.field_174879_c.func_177972_a(this.outputSide), this.outputSide.func_176734_d())) != null && outputReciever.canReceive()) {
            long powerRequested = outputReciever.getPowerRequested();
            if (this.rateLimit != -1) {
                powerRequested = Math.min(powerRequested, (long)this.rateLimit * MjAPI.MJ);
            }
            return powerRequested;
        }
        return 0L;
    }

    @Override
    public long receiveEnergy(long amount, boolean simulate, EnumFacing side) {
        if (!this.isFullyConnected() || side != this.inputSide || this.isDisabled()) {
            return 0L;
        }
        long amountTransferred = 0L;
        BlockPos outputNeighbor = this.field_174879_c.func_177972_a(this.outputSide);
        IMjReceiver outputReciever = BuildcraftIntegration.getMJReciever(this.field_145850_b, outputNeighbor, this.outputSide.func_176734_d());
        if (outputReciever != null && outputReciever.canReceive()) {
            long amountToSend = this.rateLimit == -1 ? amount : Math.min(amount, (long)this.rateLimit * MjAPI.MJ);
            amountTransferred = amountToSend - outputReciever.receivePower(amountToSend, simulate);
        }
        if (!simulate) {
            long amountTransferredMJ = (long)((double)amountTransferred / (double)MjAPI.MJ * (double)this.getEnergyScale());
            this.totalEnergyTransferred += amountTransferredMJ;
        }
        return amountTransferred;
    }

    @Override
    protected void checkConnections() {
        boolean connected = false;
        if (this.inputSide != null && this.outputSide != null && this.inputMJStorage != null && this.outputMJStorage != null) {
            BlockPos inputNeighbor = this.field_174879_c.func_177972_a(this.inputSide);
            BlockPos outputNeightbor = this.field_174879_c.func_177972_a(this.outputSide);
            IMjConnector inputConnector = BuildcraftIntegration.getMJConnector(this.field_145850_b, inputNeighbor, this.inputSide.func_176734_d());
            IMjReceiver outputReciever = BuildcraftIntegration.getMJReciever(this.field_145850_b, outputNeightbor, this.outputSide.func_176734_d());
            boolean bl = connected = inputConnector != null && outputReciever != null && outputReciever.canReceive() && this.inputMJStorage.canConnect(inputConnector) && outputReciever.canConnect((IMjConnector)this.outputMJStorage);
        }
        if (connected != this.fullyConnected) {
            this.fullyConnected = connected;
            this.notifyUpdate();
        }
    }

    @Override
    public void handleSideUpdateRequest(@Nullable EnumFacing inputSide, @Nullable EnumFacing outputSide) {
        super.handleSideUpdateRequest(inputSide, outputSide);
        this.inputMJStorage = new MJStorage(this, this.inputSide, false);
        this.outputMJStorage = new MJStorage(this, this.outputSide, true);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == MjAPI.CAP_RECEIVER && facing == this.inputSide) {
            return true;
        }
        if (capability == MjAPI.CAP_CONNECTOR && this.doesSideAcceptConnection(facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MjAPI.CAP_RECEIVER && facing == this.inputSide) {
            return (T)MjAPI.CAP_RECEIVER.cast((Object)this.inputMJStorage);
        }
        if (capability == MjAPI.CAP_CONNECTOR) {
            if (facing == this.inputSide) {
                return (T)MjAPI.CAP_CONNECTOR.cast((Object)this.inputMJStorage);
            }
            if (facing == this.outputSide) {
                return (T)MjAPI.CAP_CONNECTOR.cast((Object)this.outputMJStorage);
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

