/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.refs.ICBMExplosives;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.client.mapper.BlockModelMapperExplosive;
import icbm.classic.client.mapper.ItemModelMapperExplosive;
import icbm.classic.client.render.entity.RenderExBlock;
import icbm.classic.client.render.entity.RenderExplosion;
import icbm.classic.client.render.entity.RenderFragments;
import icbm.classic.client.render.entity.RenderLightBeam;
import icbm.classic.client.render.entity.RenderMissile;
import icbm.classic.client.render.entity.RenderSeat;
import icbm.classic.client.render.entity.RenderSmoke;
import icbm.classic.client.render.entity.item.RenderAsItem;
import icbm.classic.config.ConfigItems;
import icbm.classic.content.blast.redmatter.EntityRedmatter;
import icbm.classic.content.blast.redmatter.render.RenderRedmatter;
import icbm.classic.content.blocks.emptower.TESREmpTower;
import icbm.classic.content.blocks.emptower.TileEMPTower;
import icbm.classic.content.blocks.emptower.TileEmpTowerFake;
import icbm.classic.content.blocks.launcher.base.TESRLauncherBase;
import icbm.classic.content.blocks.launcher.base.TileLauncherBase;
import icbm.classic.content.blocks.launcher.cruise.TESRCruiseLauncher;
import icbm.classic.content.blocks.launcher.cruise.TileCruiseLauncher;
import icbm.classic.content.cargo.balloon.EntityBalloon;
import icbm.classic.content.cargo.parachute.EntityParachute;
import icbm.classic.content.cargo.parachute.RenderParachute;
import icbm.classic.content.cluster.bomblet.EntityBombDroplet;
import icbm.classic.content.cluster.bomblet.RenderBombDroplet;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.entity.EntityExplosive;
import icbm.classic.content.entity.EntityFragments;
import icbm.classic.content.entity.EntityGrenade;
import icbm.classic.content.entity.EntityLightBeam;
import icbm.classic.content.entity.EntityPlayerSeat;
import icbm.classic.content.entity.EntitySmoke;
import icbm.classic.content.entity.flyingblock.EntityFlyingBlock;
import icbm.classic.content.entity.flyingblock.RenderEntityBlock;
import icbm.classic.content.items.ItemCrafting;
import icbm.classic.content.missile.entity.EntityMissile;
import icbm.classic.content.reg.BlockReg;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.colors.ColorHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="icbmclassic", value={Side.CLIENT})
public class ClientReg {
    private static final Map<IExplosiveData, ModelResourceLocation> grenadeModelMap = new HashMap<IExplosiveData, ModelResourceLocation>();
    private static final Map<IExplosiveData, ModelResourceLocation> missileModelMap = new HashMap<IExplosiveData, ModelResourceLocation>();
    private static final Map<IExplosiveData, Map<EnumFacing, ModelResourceLocation>> blockModelMap = new HashMap<IExplosiveData, Map<EnumFacing, ModelResourceLocation>>();
    private static final Map<IExplosiveData, ModelResourceLocation> itemBlockModelMap = new HashMap<IExplosiveData, ModelResourceLocation>();
    private static final Map<IExplosiveData, ModelResourceLocation> cartModelMap = new HashMap<IExplosiveData, ModelResourceLocation>();
    private static final Map<IExplosiveData, ModelResourceLocation> bombletModelMap = new HashMap<IExplosiveData, ModelResourceLocation>();

    private static void clearModelCache() {
        grenadeModelMap.clear();
        missileModelMap.clear();
        blockModelMap.clear();
        itemBlockModelMap.clear();
        cartModelMap.clear();
    }

    @SubscribeEvent
    public static void registerBlockColor(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (worldIn != null && pos != null) {
                TileEntity tile = worldIn.func_175625_s(pos);
                if (tile instanceof TileEMPTower) {
                    int red = (int)Math.floor(Math.cos(((TileEMPTower)tile).getChargePercentage()) * 255.0);
                    int blue = (int)Math.floor(Math.sin(((TileEMPTower)tile).getChargePercentage()) * 255.0);
                    return ColorHelper.toRGB(red, 0, blue);
                }
                if (tile instanceof TileEmpTowerFake && ((TileEmpTowerFake)tile).getHost() != null) {
                    int red = (int)Math.floor(Math.cos(((TileEmpTowerFake)tile).getHost().getChargePercentage()) * 255.0);
                    int blue = (int)Math.floor(Math.sin(((TileEmpTowerFake)tile).getHost().getChargePercentage()) * 255.0);
                    return ColorHelper.toRGB(red, 0, blue);
                }
            }
            return 0;
        }, new Block[]{BlockReg.blockEmpTower});
    }

    @SubscribeEvent
    public static void registerAllModels(ModelRegistryEvent event) {
        OBJLoader.INSTANCE.addDomain("icbmclassic");
        ClientReg.clearModelCache();
        ClientReg.newBlockModel(BlockReg.blockReinforcedGlass, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockGlassPlate, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockGlassButton, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockSpikes, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockSpikes, 1, "inventory", "_poison");
        ClientReg.newBlockModel(BlockReg.blockSpikes, 2, "inventory", "_fire");
        ClientReg.newBlockModel(BlockReg.blockConcrete, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockConcrete, 1, "inventory", "_compact");
        ClientReg.newBlockModel(BlockReg.blockConcrete, 2, "inventory", "_reinforced");
        ClientReg.newBlockModel(BlockReg.blockRadioactive, 0, "inventory", "_dirt");
        ClientReg.newBlockModel(BlockReg.blockRadioactive, 1, "inventory", "_stone");
        ClientReg.registerExBlockRenders();
        ClientReg.registerGrenadeRenders();
        ClientReg.registerCartRenders();
        ClientReg.registerMissileRenders();
        ClientReg.registerBombletRenders();
        ClientReg.newBlockModel(BlockReg.blockEmpTower, 0, "inventory_0", "");
        ClientReg.newBlockModel(BlockReg.blockEmpTower, 1, "inventory_1", "");
        ClientReg.newBlockModel(BlockReg.blockRadarStation, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockLaunchBase, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockLaunchScreen, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockLaunchSupport, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockLaunchConnector, 0, "inventory", "");
        ClientReg.newBlockModel(BlockReg.blockCruiseLauncher, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemPoisonPowder, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemSulfurDust, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemSaltpeterDust, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemSaltpeterBall, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemAntidote, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemDefuser, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemRadarGun, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemRemoteDetonator, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemLaserDetonator, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemRocketLauncher, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemBallisticLauncher, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemBattery, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemBombletEmpty, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemParachute, 0, "inventory", "");
        ClientReg.newItemModel(ItemReg.itemBalloon, 0, "render=2d", "");
        ClientReg.newItemModel(ItemReg.itemBalloon, 1, "render=3d", "");
        ModelLoader.setCustomModelResourceLocation((Item)ItemReg.itemSAM, (int)0, (ModelResourceLocation)new ModelResourceLocation("icbmclassic:missiles/surface_to_air", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ItemReg.itemClusterMissile, (int)0, (ModelResourceLocation)new ModelResourceLocation("icbmclassic:missiles/cluster", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ItemReg.heldItemMissile, (int)0, (ModelResourceLocation)new ModelResourceLocation("icbmclassic:missiles/held_item", "inventory"));
        if (ConfigItems.ENABLE_CRAFTING_ITEMS) {
            if (ConfigItems.ENABLE_INGOTS_ITEMS) {
                ClientReg.registerCraftingRender(ItemReg.itemIngot);
                ClientReg.registerCraftingRender(ItemReg.itemIngotClump);
            }
            if (ConfigItems.ENABLE_PLATES_ITEMS) {
                ClientReg.registerCraftingRender(ItemReg.itemPlate);
            }
            if (ConfigItems.ENABLE_CIRCUIT_ITEMS) {
                ClientReg.registerCraftingRender(ItemReg.itemCircuit);
            }
            if (ConfigItems.ENABLE_WIRES_ITEMS) {
                ClientReg.registerCraftingRender(ItemReg.itemWire);
            }
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityExplosive.class, RenderExBlock::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityRedmatter.class, RenderRedmatter::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityFlyingBlock.class, RenderEntityBlock::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityExplosion.class, RenderExplosion::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityGrenade.class, rm -> new RenderAsItem<EntityGrenade>(rm, EntityGrenade::renderItemStack).setBillboard(true));
        RenderingRegistry.registerEntityRenderingHandler(EntityParachute.class, RenderParachute::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBalloon.class, rm -> new RenderAsItem<EntityBalloon>(rm, EntityBalloon::getRenderItemStack));
        RenderingRegistry.registerEntityRenderingHandler(EntityLightBeam.class, RenderLightBeam::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityFragments.class, RenderFragments::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBombDroplet.class, RenderBombDroplet::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPlayerSeat.class, RenderSeat::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySmoke.class, RenderSmoke::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityMissile.class, manager -> {
            RenderMissile.INSTANCE = new RenderMissile(manager);
            return RenderMissile.INSTANCE;
        });
        ClientRegistry.bindTileEntitySpecialRenderer(TileLauncherBase.class, (TileEntitySpecialRenderer)new TESRLauncherBase());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCruiseLauncher.class, (TileEntitySpecialRenderer)new TESRCruiseLauncher());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEMPTower.class, (TileEntitySpecialRenderer)new TESREmpTower());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEmpTowerFake.class, (TileEntitySpecialRenderer)new TESREmpTower());
    }

    protected static void registerExBlockRenders() {
        for (IExplosiveData data : ICBMClassicAPI.EX_BLOCK_REGISTRY.getExplosives()) {
            HashMap<EnumFacing, ModelResourceLocation> facingModelMap = new HashMap<EnumFacing, ModelResourceLocation>();
            String resourcePath = data.getRegistryKey().func_110624_b() + ":explosives/" + data.getRegistryKey().func_110623_a();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                facingModelMap.put(facing, new ModelResourceLocation(resourcePath, "explosive=" + data.getRegistryKey().toString().replace(":", "_") + ",rotation=" + facing));
            }
            blockModelMap.put(data, facingModelMap);
            itemBlockModelMap.put(data, new ModelResourceLocation(resourcePath, "inventory"));
        }
        ModelLoader.setCustomStateMapper((Block)BlockReg.blockExplosive, (IStateMapper)new BlockModelMapperExplosive(blockModelMap, blockModelMap.get(ICBMExplosives.CONDENSED).get(EnumFacing.UP)));
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)BlockReg.blockExplosive), (ItemMeshDefinition)new ItemModelMapperExplosive(itemBlockModelMap, itemBlockModelMap.get(ICBMExplosives.CONDENSED)));
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)BlockReg.blockExplosive), (ResourceLocation[])itemBlockModelMap.values().stream().map(mrl -> new ResourceLocation(mrl.func_110624_b(), mrl.func_110623_a())).collect(Collectors.toList()).toArray(new ResourceLocation[itemBlockModelMap.values().size()]));
    }

    protected static void registerGrenadeRenders() {
        for (IExplosiveData data : ICBMClassicAPI.EX_GRENADE_REGISTRY.getExplosives()) {
            String resourcePath = data.getRegistryKey().func_110624_b() + ":grenades/" + data.getRegistryKey().func_110623_a();
            grenadeModelMap.put(data, new ModelResourceLocation(resourcePath, "inventory"));
        }
        ModelLoader.registerItemVariants((Item)ItemReg.itemGrenade, (ResourceLocation[])((ResourceLocation[])grenadeModelMap.values().stream().map(model -> new ResourceLocation(model.func_110624_b() + ":" + model.func_110623_a())).toArray(ResourceLocation[]::new)));
        ModelLoader.setCustomMeshDefinition((Item)ItemReg.itemGrenade, (ItemMeshDefinition)new ItemModelMapperExplosive(grenadeModelMap, grenadeModelMap.get(ICBMExplosives.CONDENSED)));
    }

    protected static void registerBombletRenders() {
        for (IExplosiveData data : ICBMClassicAPI.EX_GRENADE_REGISTRY.getExplosives()) {
            String resourcePath = "icbmclassic:explosive_bomblet";
            bombletModelMap.put(data, new ModelResourceLocation("icbmclassic:explosive_bomblet", "inventory"));
        }
        ModelLoader.registerItemVariants((Item)ItemReg.itemBombletExplosive, (ResourceLocation[])((ResourceLocation[])bombletModelMap.values().stream().map(model -> new ResourceLocation(model.func_110624_b() + ":" + model.func_110623_a())).toArray(ResourceLocation[]::new)));
        ModelLoader.setCustomMeshDefinition((Item)ItemReg.itemBombletExplosive, (ItemMeshDefinition)new ItemModelMapperExplosive(bombletModelMap, bombletModelMap.get(ICBMExplosives.CONDENSED)));
    }

    protected static void registerCartRenders() {
        for (IExplosiveData data : ICBMClassicAPI.EX_MINECART_REGISTRY.getExplosives()) {
            String resourcePath = data.getRegistryKey().func_110624_b() + ":bombcarts/" + data.getRegistryKey().func_110623_a();
            cartModelMap.put(data, new ModelResourceLocation(resourcePath, "inventory"));
        }
        ModelLoader.registerItemVariants((Item)ItemReg.itemBombCart, (ResourceLocation[])((ResourceLocation[])cartModelMap.values().stream().map(model -> new ResourceLocation(model.func_110624_b() + ":" + model.func_110623_a())).toArray(ResourceLocation[]::new)));
        ModelLoader.setCustomMeshDefinition((Item)ItemReg.itemBombCart, (ItemMeshDefinition)new ItemModelMapperExplosive(cartModelMap, cartModelMap.get(ICBMExplosives.CONDENSED)));
    }

    protected static void registerMissileRenders() {
        for (IExplosiveData data : ICBMClassicAPI.EX_MISSILE_REGISTRY.getExplosives()) {
            String resourcePath = data.getRegistryKey().func_110624_b() + ":missiles/" + data.getRegistryKey().func_110623_a();
            missileModelMap.put(data, new ModelResourceLocation(resourcePath, "inventory"));
        }
        ModelResourceLocation fallback = new ModelResourceLocation("icbmclassic:missiles/missile", "inventory");
        missileModelMap.put(ICBMExplosives.MISSILEMODULE, fallback);
        ModelLoader.registerItemVariants((Item)ItemReg.itemExplosiveMissile, (ResourceLocation[])((ResourceLocation[])missileModelMap.values().stream().map(model -> new ResourceLocation(model.func_110624_b() + ":" + model.func_110623_a())).toArray(ResourceLocation[]::new)));
        ModelLoader.setCustomMeshDefinition((Item)ItemReg.itemExplosiveMissile, (ItemMeshDefinition)new ItemModelMapperExplosive(missileModelMap, fallback));
    }

    protected static void registerCraftingRender(ItemCrafting itemCrafting) {
        if (itemCrafting != null) {
            String resourcePath = itemCrafting.getRegistryName().toString();
            for (int i = 0; i < itemCrafting.subItems.length; ++i) {
                String subItem = itemCrafting.subItems[i];
                ModelLoader.setCustomModelResourceLocation((Item)itemCrafting, (int)i, (ModelResourceLocation)new ModelResourceLocation(resourcePath, "name=" + subItem));
            }
        }
    }

    protected static void newBlockModel(Block block, int meta, String varient, String sub) {
        if (block != null) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName() + sub, varient));
        }
    }

    protected static void newItemModel(Item item, int meta, String varient, String sub) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + sub, varient));
        }
    }
}

