/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client;

import com.builtbroken.jlib.data.vector.IPos3D;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="icbmclassic")
public enum ICBMSounds {
    ANTIMATTER("antimatter"),
    BEAM_CHARGING("beamcharging"),
    COLLAPSE("collapse"),
    DEBILITATION("debilitation"),
    EMP("emp"),
    EXPLOSION("explosion"),
    EXPLOSION_FIRE("explosionfire"),
    GAS_LEAK("gasleak"),
    MACHINE_HUM("machinehum"),
    POWER_DOWN("powerdown"),
    REDMATTER("redmatter"),
    SONICWAVE("sonicwave"),
    MISSILE_LAUNCH("missilelaunch"),
    MISSILE_ENGINE("missileinair"),
    MEEP("meep", SoundCategory.NEUTRAL),
    RADIOACTIVE_TICK("radioactive_tick", SoundCategory.BLOCKS);

    private final ResourceLocation location;
    private final SoundCategory category;
    private SoundEvent sound;

    private ICBMSounds(String path) {
        this(path, SoundCategory.BLOCKS);
    }

    private ICBMSounds(String path, SoundCategory category) {
        this.category = category;
        this.location = new ResourceLocation("icbmclassic", path);
    }

    public void play(Entity entity, float volume, float pitch, boolean distanceDelay) {
        this.play(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, volume, pitch, distanceDelay);
    }

    public void play(World world, double x, double y, double z, float volume, float pitch, boolean distanceDelay) {
        if (world.field_72995_K) {
            world.func_184134_a(x, y, z, this.getSound(), this.category, volume, pitch, distanceDelay);
        } else {
            world.func_184148_a(null, x, y, z, this.getSound(), this.category, volume, pitch);
        }
    }

    public void play(World world, IPos3D pos, float volume, float pitch, boolean distanceDelay) {
        world.func_184148_a(null, pos.x(), pos.y(), pos.z(), this.getSound(), this.category, volume, pitch);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (ICBMSounds icbmSounds : ICBMSounds.values()) {
            icbmSounds.sound = (SoundEvent)new SoundEvent(icbmSounds.location).setRegistryName(icbmSounds.location);
            event.getRegistry().register((IForgeRegistryEntry)icbmSounds.sound);
        }
    }

    @Generated
    public SoundEvent getSound() {
        return this.sound;
    }
}

