/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.config;

import icbm.classic.content.actions.emp.EmpHandler;
import icbm.classic.content.cargo.CargoHolderHandler;
import icbm.classic.content.cluster.missile.ClusterMissileHandler;
import icbm.classic.content.entity.flyingblock.FlyingBlock;
import icbm.classic.content.gas.ProtectiveArmorHandler;
import icbm.classic.content.missile.entity.itemstack.item.HeldItemMissileHandler;
import icbm.classic.content.radioactive.RadioactiveHandler;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="icbmclassic", name="icbmclassic/main")
@Config.LangKey(value="config.icbmclassic:main.title")
@Mod.EventBusSubscriber(modid="icbmclassic")
public class ConfigMain {
    @Config.Name(value="use_energy")
    @Config.Comment(value={"Range of tier 1 launcher"})
    public static boolean REQUIRES_POWER = true;
    @Config.Name(value="protective_armor")
    @Config.Comment(value={"Settings for setting protection support on armor items"})
    public static ProtectiveArmorConfig protectiveArmor = new ProtectiveArmorConfig();

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("icbmclassic")) {
            ConfigManager.sync((String)"icbmclassic", (Config.Type)Config.Type.INSTANCE);
            FlyingBlock.loadFromConfig();
            ClusterMissileHandler.loadFromConfig();
            CargoHolderHandler.loadFromConfig();
            HeldItemMissileHandler.loadFromConfig();
            RadioactiveHandler.loadFromConfig();
            ProtectiveArmorHandler.loadFromConfig();
            EmpHandler.loadFromConfig();
        }
    }

    public static class ProtectiveArmorConfig {
        @Config.Name(value="min_chemical_gas_protection")
        @Config.Comment(value={"Minimal percentage of protection required to start guarding from chemical attacks"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float minProtectionChemicalGas = 0.5f;
        @Config.Name(value="min_viral_gas_protection")
        @Config.Comment(value={"Minimal percentage of protection required to start guarding from viral attacks"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float minProtectionViralGas = 0.8f;
        @Config.Name(value="min_radiation_protection")
        @Config.Comment(value={"Minimal percentage of protection required to start guarding from radiation attacks"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float minProtectionRadiation = 1.0f;
        @Config.Name(value="min_debilitation_gas_protection")
        @Config.Comment(value={"Minimal percentage of protection required to start guarding from debilitation attacks"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float minProtectionDebilitationGas = 0.1f;
        @Config.Name(value="require_helmet")
        @Config.Comment(value={"Is head slot required to count as protection"})
        public boolean requireHelmet = true;
        @Config.Name(value="item_ratings")
        @Config.Comment(value={"Item/ItemStack to percentage protection between 0.0 to 1.0 'domain:resource=floating_point', ex: 'minecraft:iron_helmet=0.02'"})
        public String[] ITEMS = new String[0];
    }
}

