/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.config.util;

import lombok.Generated;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockReplacementData {
    private IBlockState blockState;
    private NBTTagCompound blockNBT = null;
    private float chance = -1.0f;

    public void apply(World world, BlockPos pos) {
        if (this.shouldPlace(world)) {
            this.placeBlock(world, pos);
            this.applyNBT(world, pos);
        }
    }

    private boolean shouldPlace(World world) {
        return this.getChance() < 0.0f || world.field_73012_v.nextFloat() <= this.getChance();
    }

    private void placeBlock(World world, BlockPos pos) {
        if (this.getBlockState() != null) {
            world.func_180501_a(pos, this.getBlockState(), 3);
        }
    }

    private void applyNBT(World world, BlockPos pos) {
        TileEntity tileEntity;
        if (this.blockNBT != null && !this.blockNBT.func_82582_d() && (tileEntity = world.func_175625_s(pos)) != null) {
            NBTTagCompound existingSave = tileEntity.func_189515_b(new NBTTagCompound());
            this.blockNBT.func_82580_o("id");
            this.blockNBT.func_82580_o("x");
            this.blockNBT.func_82580_o("y");
            this.blockNBT.func_82580_o("z");
            existingSave.func_179237_a(this.blockNBT);
            tileEntity.func_145839_a(existingSave);
        }
    }

    @Generated
    public BlockReplacementData() {
    }

    @Generated
    public IBlockState getBlockState() {
        return this.blockState;
    }

    @Generated
    public NBTTagCompound getBlockNBT() {
        return this.blockNBT;
    }

    @Generated
    public float getChance() {
        return this.chance;
    }

    @Generated
    public BlockReplacementData setBlockState(IBlockState blockState) {
        this.blockState = blockState;
        return this;
    }

    @Generated
    public BlockReplacementData setBlockNBT(NBTTagCompound blockNBT) {
        this.blockNBT = blockNBT;
        return this;
    }

    @Generated
    public BlockReplacementData setChance(float chance) {
        this.chance = chance;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockReplacementData)) {
            return false;
        }
        BlockReplacementData other = (BlockReplacementData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getChance(), other.getChance()) != 0) {
            return false;
        }
        IBlockState this$blockState = this.getBlockState();
        IBlockState other$blockState = other.getBlockState();
        if (this$blockState == null ? other$blockState != null : !this$blockState.equals(other$blockState)) {
            return false;
        }
        NBTTagCompound this$blockNBT = this.getBlockNBT();
        NBTTagCompound other$blockNBT = other.getBlockNBT();
        return !(this$blockNBT == null ? other$blockNBT != null : !this$blockNBT.equals(other$blockNBT));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BlockReplacementData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getChance());
        IBlockState $blockState = this.getBlockState();
        result = result * 59 + ($blockState == null ? 43 : $blockState.hashCode());
        NBTTagCompound $blockNBT = this.getBlockNBT();
        result = result * 59 + ($blockNBT == null ? 43 : $blockNBT.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BlockReplacementData(blockState=" + this.getBlockState() + ", blockNBT=" + this.getBlockNBT() + ", chance=" + this.getChance() + ")";
    }
}

