/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.actions.emp;

import icbm.classic.api.actions.IActionData;
import icbm.classic.api.actions.cause.IActionSource;
import icbm.classic.api.actions.data.ActionField;
import icbm.classic.api.actions.data.ActionFields;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.api.caps.IEMPReceiver;
import icbm.classic.api.events.EmpEvent;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.blast.ConfigBlast;
import icbm.classic.config.util.BlockReplacementData;
import icbm.classic.content.actions.emp.EmpHandler;
import icbm.classic.lib.actions.ActionBase;
import icbm.classic.lib.actions.status.ActionResponses;
import icbm.classic.lib.capability.emp.CapabilityEMP;
import icbm.classic.lib.capability.emp.CapabilityEmpInventory;
import icbm.classic.lib.energy.system.EnergySystem;
import icbm.classic.lib.energy.system.IEnergySystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;

public class ActionEmpArea
extends ActionBase {
    static final List<ActionField> SUPPORTED_FIELDS = new ArrayList<ActionField<Float, NBTTagFloat>>(Collections.singleton(ActionFields.AREA_SIZE));
    private int size = 1;

    public ActionEmpArea(World world, Vec3d vec3d, IActionSource source, IActionData actionData) {
        super(world, vec3d, source, actionData);
    }

    @Override
    public <VALUE, TAG extends NBTBase> VALUE getValue(ActionField<VALUE, TAG> key) {
        if (key == ActionFields.AREA_SIZE) {
            return (VALUE)ActionFields.AREA_SIZE.cast(Float.valueOf(this.size));
        }
        return null;
    }

    public List<ActionField> getFields() {
        return SUPPORTED_FIELDS;
    }

    @Override
    public <VALUE, TAG extends NBTBase> boolean hasField(ActionField<VALUE, TAG> key) {
        return key == ActionFields.AREA_SIZE;
    }

    @Override
    @Nonnull
    public IActionStatus doAction() {
        if (!this.getWorld().field_72995_K) {
            this.empTiles();
            this.empEntities();
            ICBMSounds.EMP.play(this.getWorld(), this.getPosition().field_72450_a, this.getPosition().field_72448_b, this.getPosition().field_72449_c, 4.0f, (1.0f + (this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
        }
        return ActionResponses.COMPLETED;
    }

    protected void empTiles() {
        if (!ConfigBlast.emp.ALLOW_TILES) {
            return;
        }
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        for (int x = -this.size; x < this.size; ++x) {
            for (int y = -this.size; y < this.size; ++y) {
                for (int z = -this.size; z < this.size; ++z) {
                    currentPos.func_181079_c(this.getBlockPos().func_177958_n() + x, this.getBlockPos().func_177956_o() + y, this.getBlockPos().func_177952_p() + z);
                    if (!this.getWorld().func_175667_e((BlockPos)currentPos)) continue;
                    this.empTile((BlockPos)currentPos);
                }
            }
        }
    }

    protected void empTile(BlockPos blockPos) {
        if (blockPos.func_177956_o() == this.getBlockPos().func_177956_o()) {
            this.getWorld().func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
        IBlockState iBlockState = this.getWorld().func_180495_p(blockPos);
        float powerEntity = 1.0f;
        if (!MinecraftForge.EVENT_BUS.post((Event)new EmpEvent.BlockPre(this, this.getWorld(), blockPos, iBlockState))) {
            IBlockState blockState = this.getWorld().func_180495_p(blockPos);
            BlockReplacementData replacement = (BlockReplacementData)EmpHandler.empBlockSwaps.getValue(blockState);
            if (replacement != null) {
                replacement.apply(this.getWorld(), blockPos);
                return;
            }
            TileEntity tileEntity = this.getWorld().func_175625_s(blockPos);
            if (tileEntity != null) {
                IEnergySystem energySystem;
                boolean doInventory = true;
                if (tileEntity.hasCapability(CapabilityEMP.EMP, null)) {
                    IEMPReceiver receiver = (IEMPReceiver)tileEntity.getCapability(CapabilityEMP.EMP, null);
                    if (receiver != null) {
                        powerEntity = this.empEntity(tileEntity, powerEntity, receiver);
                        doInventory = receiver.shouldEmpSubObjects(this.getWorld(), tileEntity.func_174877_v().func_177958_n(), tileEntity.func_174877_v().func_177956_o(), tileEntity.func_174877_v().func_177952_p());
                    }
                } else if (ConfigBlast.emp.DRAIN_ENERGY_TILES && (energySystem = EnergySystem.getSystem(tileEntity, null)).canSetEnergyDirectly(tileEntity, null)) {
                    energySystem.setEnergy(tileEntity, null, 0, false);
                }
                if (doInventory && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                    powerEntity = this.empEntity(tileEntity, powerEntity, (IEMPReceiver)new CapabilityEmpInventory.TileInv(tileEntity));
                }
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new EmpEvent.BlockPost(this, this.getWorld(), blockPos, iBlockState));
    }

    protected void empEntities() {
        if (!ConfigBlast.emp.ALLOW_ENTITY) {
            return;
        }
        AxisAlignedBB bounds = new AxisAlignedBB((double)(this.getPos().func_177958_n() - this.size), (double)(this.getPos().func_177956_o() - this.size), (double)(this.getPos().func_177952_p() - this.size), (double)(this.getPos().func_177958_n() + this.size), (double)(this.getPos().func_177956_o() + this.size), (double)(this.getPos().func_177952_p() + this.size));
        List entities = this.getWorld().func_72872_a(Entity.class, bounds);
        for (Entity entity : entities) {
            IEnergySystem energySystem;
            float powerEntity = 1.0f;
            if (MinecraftForge.EVENT_BUS.post((Event)new EmpEvent.EntityPre(this, entity))) continue;
            boolean doInventory = true;
            if (entity.hasCapability(CapabilityEMP.EMP, null)) {
                IEMPReceiver receiver = (IEMPReceiver)entity.getCapability(CapabilityEMP.EMP, null);
                if (receiver != null) {
                    powerEntity = this.empEntity(entity, powerEntity, receiver);
                    doInventory = receiver.shouldEmpSubObjects(this.getWorld(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                }
            } else if (ConfigBlast.emp.DRAIN_ENERGY_ENTITY && (energySystem = EnergySystem.getSystem(entity, null)).canSetEnergyDirectly(entity, null)) {
                energySystem.setEnergy(entity, null, 0, false);
            }
            if (doInventory && entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                powerEntity = this.empEntity(entity, powerEntity, (IEMPReceiver)new CapabilityEmpInventory.EntityInv(entity));
            }
            MinecraftForge.EVENT_BUS.post((Event)new EmpEvent.EntityPost(this, entity));
        }
    }

    protected float empEntity(Entity entity, float powerEntity, IEMPReceiver receiver) {
        if (receiver != null) {
            powerEntity = receiver.applyEmpAction(this.getWorld(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this, powerEntity, true);
        }
        return powerEntity;
    }

    protected float empEntity(TileEntity entity, float powerEntity, IEMPReceiver receiver) {
        if (receiver != null) {
            powerEntity = receiver.applyEmpAction(this.getWorld(), entity.func_174877_v().func_177958_n(), entity.func_174877_v().func_177956_o(), entity.func_174877_v().func_177952_p(), this, powerEntity, true);
        }
        return powerEntity;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public ActionEmpArea setSize(int size) {
        this.size = size;
        return this;
    }
}

