/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.content.blast.Blast;
import icbm.classic.lib.network.packet.PacketSpawnBlockExplosion;
import icbm.classic.lib.transform.region.Cube;
import icbm.classic.lib.transform.vector.Pos;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlastTNT
extends Blast {
    private PushType pushType = PushType.NO_PUSH;
    private boolean destroyItem = false;
    public float damageToEntities = 10.0f;
    public int raysPerAxis = 16;

    public BlastTNT setPushType(PushType type) {
        this.pushType = type;
        return this;
    }

    public BlastTNT setDestroyItems() {
        this.destroyItem = true;
        return this;
    }

    @Override
    protected void clientRunBlast() {
    }

    @Override
    public boolean doExplode(int callCount) {
        this.calculateDamage();
        if (this.field_77287_j instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)this.field_77287_j;
            if (this.field_77280_f >= 2.0f) {
                worldServer.func_180505_a(EnumParticleTypes.EXPLOSION_HUGE, false, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1, 1.0, 0.0, 0.0, 1.0, new int[0]);
            } else {
                worldServer.func_180505_a(EnumParticleTypes.EXPLOSION_LARGE, false, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1, 1.0, 0.0, 0.0, 1.0, new int[0]);
            }
        }
        this.world().func_184148_a(null, this.location.x(), this.location.y(), this.location.z(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.pushType == PushType.NO_PUSH) {
            this.doDamageEntities(this.getBlastRadius(), this.damageToEntities, this.destroyItem);
        } else {
            this.pushEntities(12.0f, this.getBlastRadius() * 4.0f, this.pushType);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ExplosionEvent.Detonate(this.field_77287_j, (Explosion)this, new ArrayList()));
        this.doDestroyBlocks();
        return true;
    }

    protected void calculateDamage() {
        if (!this.world().field_72995_K) {
            for (int xs = 0; xs < this.raysPerAxis; ++xs) {
                for (int ys = 0; ys < this.raysPerAxis; ++ys) {
                    for (int zs = 0; zs < this.raysPerAxis; ++zs) {
                        if (xs != 0 && xs != this.raysPerAxis - 1 && ys != 0 && ys != this.raysPerAxis - 1 && zs != 0 && zs != this.raysPerAxis - 1) continue;
                        double xStep = (float)xs / ((float)this.raysPerAxis - 1.0f) * 2.0f - 1.0f;
                        double yStep = (float)ys / ((float)this.raysPerAxis - 1.0f) * 2.0f - 1.0f;
                        double zStep = (float)zs / ((float)this.raysPerAxis - 1.0f) * 2.0f - 1.0f;
                        double diagonalDistance = Math.sqrt(xStep * xStep + yStep * yStep + zStep * zStep);
                        xStep /= diagonalDistance;
                        yStep /= diagonalDistance;
                        zStep /= diagonalDistance;
                        double x = this.location.x();
                        double y = this.location.y();
                        double z = this.location.z();
                        float step = 0.3f;
                        for (float radialEnergy = this.getBlastRadius() * (0.7f + this.world().field_73012_v.nextFloat() * 0.6f); radialEnergy > 0.0f; radialEnergy -= step * 0.75f) {
                            int xi = MathHelper.func_76128_c((double)x);
                            int yi = MathHelper.func_76128_c((double)y);
                            int zi = MathHelper.func_76128_c((double)z);
                            BlockPos blockPos = new BlockPos(xi, yi, zi);
                            IBlockState blockState = this.field_77287_j.func_180495_p(blockPos);
                            Block block = blockState.func_177230_c();
                            if (blockState.func_185904_a() != Material.field_151579_a && (radialEnergy -= (block.getExplosionResistance(this.world(), blockPos, this.field_77283_e, (Explosion)this) + 0.3f) * step) > 0.0f && !this.func_180343_e().contains(blockPos)) {
                                this.func_180343_e().add(blockPos);
                            }
                            x += xStep * (double)step;
                            y += yStep * (double)step;
                            z += zStep * (double)step;
                        }
                    }
                }
            }
        }
    }

    protected void doDestroyBlocks() {
        if (!this.world().field_72995_K) {
            for (BlockPos blockDestroyedPos : this.func_180343_e()) {
                IBlockState blockState = this.world().func_180495_p(blockDestroyedPos);
                PacketSpawnBlockExplosion.sendToAllClients(this.world(), this.x(), this.y(), this.z(), this.getBlastRadius(), blockDestroyedPos);
                if (blockState.func_185904_a() == Material.field_151579_a) continue;
                try {
                    if (blockState.func_177230_c().func_149659_a((Explosion)this)) {
                        blockState.func_177230_c().func_180653_a(this.world(), blockDestroyedPos, blockState, 1.0f / this.getBlastRadius(), 0);
                    }
                    blockState.func_177230_c().onBlockExploded(this.world(), blockDestroyedPos, (Explosion)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void pushEntities(float radius, float force, PushType type) {
        Pos minCoord = this.location.toPos();
        minCoord = (Pos)minCoord.add(-radius - 1.0f);
        Pos maxCoord = this.location.toPos();
        maxCoord = (Pos)maxCoord.add(radius + 1.0f);
        Cube region = new Cube(minCoord, maxCoord);
        List entities = this.field_77287_j.func_72872_a(Entity.class, region.getAABB());
        for (Entity entity : entities) {
            double modifier;
            double distanceScale = entity.func_70011_f(this.location.x(), this.location.y(), this.location.z()) / (double)radius;
            if (!(distanceScale <= 1.0)) continue;
            double xDifference = entity.field_70165_t - this.location.x();
            double yDifference = entity.field_70163_u - this.location.y();
            double zDifference = entity.field_70161_v - this.location.z();
            double mag = MathHelper.func_76133_a((double)(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference));
            xDifference /= mag;
            yDifference /= mag;
            zDifference /= mag;
            if (type == PushType.ATTRACT) {
                modifier = distanceScale * (double)force * (entity instanceof EntityPlayer ? 0.5 : 1.0);
                entity.func_70024_g(-xDifference * modifier, -yDifference * modifier, -zDifference * modifier);
                continue;
            }
            if (type != PushType.REPEL) continue;
            modifier = (1.0 - distanceScale) * (double)force * (entity instanceof EntityPlayer ? 0.5 : 1.0);
            entity.func_70024_g(xDifference * modifier, yDifference * modifier, zDifference * modifier);
        }
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.pushType = PushType.values()[nbt.func_74762_e("pushType")];
        this.destroyItem = nbt.func_74767_n("destroyItem");
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74768_a("pushType", this.pushType.ordinal());
        nbt.func_74757_a("destroyItem", this.destroyItem);
    }

    @Generated
    public BlastTNT setDamageToEntities(float damageToEntities) {
        this.damageToEntities = damageToEntities;
        return this;
    }

    public static enum PushType {
        NO_PUSH,
        ATTRACT,
        REPEL;

    }
}

