/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.redmatter.render;

import icbm.classic.config.blast.ConfigBlast;
import icbm.classic.content.blast.redmatter.EntityRedmatter;
import icbm.classic.lib.colors.ColorB;
import icbm.classic.lib.colors.ColorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.glu.Sphere;

@SideOnly(value=Side.CLIENT)
public class RenderRedmatter
extends Render<EntityRedmatter> {
    public static final ResourceLocation TEXTURE_FILE = new ResourceLocation("icbmclassic", "textures/entity/redmatter/blackhole.png");
    public static ResourceLocation GREY_TEXTURE = new ResourceLocation("icbmclassic", "textures/models/grey.png");
    public static List<ColorB> randomColorsForBeams = new ArrayList<ColorB>();
    public ColorB colorIn = new ColorB(255, 255, 255);
    public ColorB colorOut = new ColorB(0, 0, 0);

    public RenderRedmatter(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityRedmatter redmatter, double x, double y, double z, float entityYaw, float partialTicks) {
        float visualSize = redmatter.clientLogic.getVisualSize();
        this.renderDisk(redmatter, x, y, z, visualSize);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderSphere(redmatter, x, y, z, visualSize);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBeams(redmatter, x, y, z, visualSize);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        redmatter.clientLogic.lerpSize(partialTicks);
    }

    public void renderSphere(EntityRedmatter redmatter, double x, double y, double z, float visualSize) {
        float radius = Math.max(ConfigBlast.redmatter.RENDER_SCALE * visualSize, 0.1f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_110776_a(GREY_TEXTURE);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        new Sphere().draw(radius * 0.8f, 32, 32);
        GlStateManager.func_179121_F();
        float ticks = redmatter.field_70173_aa % 40;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_110776_a(GREY_TEXTURE);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.2f, (float)0.8f);
        float scaleSize = 5.0E-4f;
        float fullSize = radius * 5.0E-4f * 20.0f;
        float scaleDelta = ticks > 20.0f ? fullSize - radius * 5.0E-4f * (ticks - 20.0f) : radius * 5.0E-4f * ticks;
        new Sphere().draw(radius + scaleDelta, 32, 32);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    public void renderDisk(EntityRedmatter redmatter, double x, double y, double z, float visualSize) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        float size = (float)Math.max(0.2, (double)(ConfigBlast.redmatter.RENDER_SCALE * visualSize * 3.0f));
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(-redmatter.field_70173_aa), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_110776_a(TEXTURE_FILE);
        GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(-size), 0.0, (double)(-size)).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(-size), 0.0, (double)size).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)size, 0.0, (double)size).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)size, 0.0, (double)(-size)).func_187315_a(1.0, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(-size), 0.0, (double)(-size)).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(-size), 0.0, (double)size).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)size, 0.0, (double)size).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)size, 0.0, (double)(-size)).func_187315_a(0.0, 1.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    public void renderBeams(EntityRedmatter redmatter, double x, double y, double z, float visualSize) {
        int totalAnimationTime = 4000;
        int rotationAnimationTime = 200;
        float animationPhaseTime = 2000.0f;
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderHelper.func_74518_a();
        int ticks = redmatter.field_70173_aa % 4000;
        float rotationScale = (float)(redmatter.field_70173_aa % 200) / 200.0f;
        float timeScale = (float)ticks < 2000.0f ? (float)ticks / 2000.0f : 2.0f - (float)ticks / 2000.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179118_c();
        GlStateManager.func_179089_o();
        Random redmatterBeamRandom = new Random(432L);
        int beamCount = (int)((timeScale + timeScale * timeScale) / 2.0f * 30.0f);
        for (int beamIndex = 0; beamIndex < beamCount; ++beamIndex) {
            GlStateManager.func_179094_E();
            float beamLength = (redmatterBeamRandom.nextFloat() + 1.0f) * visualSize;
            float beamWidth = (float)Math.max(0.1, (double)redmatterBeamRandom.nextFloat()) * visualSize / 10.0f;
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f + rotationScale * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            ColorB colorOut = this.colorOut;
            ColorB colorIn = this.colorIn;
            if (ConfigBlast.redmatter.RENDER_COLORED_BEAMS) {
                if (beamIndex < randomColorsForBeams.size()) {
                    colorOut = randomColorsForBeams.get(beamIndex);
                } else {
                    float hue = redmatterBeamRandom.nextFloat();
                    float saturation = 0.9f;
                    float luminance = 0.5f;
                    colorOut = ColorHelper.HSBtoRGB(hue, 0.9f, 0.5f);
                    randomColorsForBeams.add(colorOut);
                }
            }
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b((int)colorIn.getRed(), (int)colorIn.getGreen(), (int)colorIn.getBlue(), (int)colorIn.getAlpha()).func_181675_d();
            bufferbuilder.func_181662_b(-0.866 * (double)beamWidth, (double)beamLength, (double)(-0.5f * beamWidth)).func_181669_b((int)colorOut.getRed(), (int)colorOut.getGreen(), (int)colorOut.getBlue(), (int)colorOut.getAlpha()).func_181675_d();
            bufferbuilder.func_181662_b(0.866 * (double)beamWidth, (double)beamLength, (double)(-0.5f * beamWidth)).func_181669_b((int)colorOut.getRed(), (int)colorOut.getGreen(), (int)colorOut.getBlue(), (int)colorOut.getAlpha()).func_181675_d();
            bufferbuilder.func_181662_b(0.0, (double)beamLength, (double)(1.0f * beamWidth)).func_181669_b((int)colorOut.getRed(), (int)colorOut.getGreen(), (int)colorOut.getBlue(), (int)colorOut.getAlpha()).func_181675_d();
            bufferbuilder.func_181662_b(-0.866 * (double)beamWidth, (double)beamLength, (double)(-0.5f * beamWidth)).func_181669_b((int)colorOut.getRed(), (int)colorOut.getGreen(), (int)colorOut.getBlue(), (int)colorOut.getAlpha()).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityRedmatter entity) {
        return GREY_TEXTURE;
    }
}

