/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.threaded;

import icbm.classic.ICBMClassic;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.ConfigDebug;
import icbm.classic.config.blast.ConfigBlast;
import icbm.classic.content.blast.BlastHelpers;
import icbm.classic.content.blast.redmatter.EntityRedmatter;
import icbm.classic.content.blast.threaded.BlastThreaded;
import icbm.classic.lib.transform.BlockEditHandler;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;

public class BlastAntimatter
extends BlastThreaded {
    private final IBlockState replaceState = Blocks.field_150350_a.func_176223_P();

    @Override
    public boolean setupBlast() {
        super.setupBlast();
        ICBMSounds.ANTIMATTER.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 7.0f, (float)((double)this.world().field_73012_v.nextFloat() * 0.1 + (double)0.9f), true);
        return this.doDamageEntities(this.getBlastRadius() * 2.0f, ConfigBlast.antimatter.damage);
    }

    @Override
    public void destroyBlock(BlockPos blockPos) {
        IBlockState blockState = this.field_77287_j.func_180495_p(blockPos);
        if (!blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.field_77287_j, blockPos) && (blockState.func_185887_b(this.field_77287_j, blockPos) >= 0.0f || ConfigBlast.antimatter.damageUnbreakable)) {
            this.field_77287_j.func_180501_a(blockPos, this.replaceState, ConfigBlast.BLAST_DO_BLOCKUPDATES ? 3 : 2);
        }
    }

    @Override
    public boolean doRun(int loops, Consumer<BlockPos> edits) {
        long time = System.currentTimeMillis();
        BlastHelpers.forEachPosInRadius(this.getBlastRadius(), (x, y, z) -> {
            if (this.shouldEditPos(x, y, z)) {
                edits.accept(new BlockPos(this.xi() + x, this.yi() + y, this.zi() + z));
            }
        });
        time = System.currentTimeMillis() - time;
        if (ConfigDebug.DEBUG_EXPLOSIVES) {
            ICBMClassic.logger().info("Antimatter: thread calculations ran in " + time + "ms");
        }
        return false;
    }

    @Override
    protected void onWorkerThreadComplete(List<BlockPos> edits) {
        if (this.field_77287_j instanceof WorldServer) {
            long time = System.currentTimeMillis();
            edits.sort(this.buildSorter());
            time = System.currentTimeMillis() - time;
            if (ConfigDebug.DEBUG_EXPLOSIVES) {
                ICBMClassic.logger().info("Antimatter: sorting blocks ran in " + time + "ms");
            }
            time = System.currentTimeMillis();
            List removeFirst = edits.stream().filter(blockPos -> this.field_77287_j.func_175667_e(blockPos)).filter(this::isFluid).collect(Collectors.toList());
            time = System.currentTimeMillis() - time;
            if (ConfigDebug.DEBUG_EXPLOSIVES) {
                ICBMClassic.logger().info("Antimatter: filtering first edits ran in " + time + "ms");
            }
            ((WorldServer)this.field_77287_j).func_152344_a(() -> this.scheduledTask(removeFirst, edits));
        }
    }

    private void scheduledTask(List<BlockPos> removeFirst, List<BlockPos> edits) {
        long time = System.currentTimeMillis();
        removeFirst.forEach(blockPos -> this.field_77287_j.func_180501_a(blockPos, this.replaceState, 2));
        time = System.currentTimeMillis() - time;
        if (ConfigDebug.DEBUG_EXPLOSIVES) {
            ICBMClassic.logger().info("Antimatter: remove#first blocks ran in " + time + "ms,  edits:" + removeFirst.size());
        }
        time = System.currentTimeMillis();
        BlockEditHandler.queue(this.field_77287_j, edits, this::destroyBlock);
        time = System.currentTimeMillis() - time;
        if (ConfigDebug.DEBUG_EXPLOSIVES) {
            ICBMClassic.logger().info("Antimatter: remove#second ran in " + time + "ms,  edits:" + edits.size());
        }
        this.onPostThreadJoinWorld();
    }

    protected boolean isFluid(BlockPos blockPos) {
        IBlockState state = this.field_77287_j.func_180495_p(blockPos);
        return state.func_185904_a() == Material.field_151586_h || state.func_177230_c() instanceof BlockFalling;
    }

    protected boolean shouldEditPos(int x, int y, int z) {
        double distSQ = x * x + y * y + z * z;
        double blastSQ = this.getBlastRadius() * this.getBlastRadius();
        int featherEdge = (int)Math.floor(blastSQ * (double)0.05f);
        int delta = (int)Math.floor(blastSQ - distSQ);
        if (delta < featherEdge) {
            double p2 = 1.0 - (double)delta / (double)featherEdge;
            return (double)this.world().field_73012_v.nextFloat() > p2;
        }
        return true;
    }

    @Override
    public void onBlastCompleted() {
        super.onBlastCompleted();
        this.doDamageEntities(this.getBlastRadius() * 2.0f, ConfigBlast.antimatter.damage);
    }

    @Override
    protected boolean doDamageEntities(float radius, float power, boolean destroyItem) {
        if (!ConfigBlast.antimatter.damageOnRedmatterKill) {
            List<Entity> allEntities = this.getEntities(radius * 2.0f);
            long killed = allEntities.stream().filter(e -> e instanceof EntityRedmatter).peek(this::onDamageEntity).count();
            if (killed > 0L) {
                return false;
            }
            return this.doDamageEntities(allEntities, radius, power, destroyItem);
        }
        return super.doDamageEntities(radius, power, destroyItem);
    }

    @Override
    protected boolean onDamageEntity(Entity entity) {
        if (entity instanceof EntityRedmatter) {
            entity.func_70106_y();
            return true;
        }
        return false;
    }
}

