/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.cruise;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.actions.cause.IActionCause;
import icbm.classic.api.actions.status.ActionStatusTypes;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.api.launcher.ILauncherSolution;
import icbm.classic.api.missiles.ICapabilityMissileStack;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.blocks.launcher.FiringPackage;
import icbm.classic.content.blocks.launcher.LauncherBaseCapability;
import icbm.classic.content.blocks.launcher.cruise.TileCruiseLauncher;
import icbm.classic.content.blocks.launcher.status.FiringWithDelay;
import icbm.classic.content.blocks.launcher.status.LaunchedWithMissile;
import icbm.classic.content.blocks.launcher.status.LauncherStatus;
import icbm.classic.content.missile.logic.flight.DirectFlightLogic;
import icbm.classic.content.missile.logic.source.ActionSource;
import icbm.classic.content.missile.logic.source.cause.CausedByBlock;
import icbm.classic.content.reg.ItemReg;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;

public class CLauncherCapability
extends LauncherBaseCapability {
    private final TileCruiseLauncher host;

    @Override
    public IActionStatus getStatus() {
        if (!this.host.energyStorage.consumePower(this.host.getFiringCost(), true)) {
            return LauncherStatus.ERROR_POWER;
        }
        if (this.host.getFiringPackage() != null && !this.getHost().isAimed()) {
            return LauncherStatus.FIRING_AIMING;
        }
        if (this.host.missileHolder.getMissileStack().func_190926_b()) {
            return LauncherStatus.ERROR_EMPTY_STACK;
        }
        if (this.host.getFiringPackage() != null && this.host.getFiringPackage().getCountDown() > 0) {
            return new FiringWithDelay(this.host.getFiringPackage().getCountDown());
        }
        if (!this.host.canSpawnMissileWithNoCollision()) {
            return LauncherStatus.ERROR_SPAWN_COLLIDER;
        }
        return LauncherStatus.READY;
    }

    @Override
    public IActionStatus preCheckLaunch(IMissileTarget targetData, @Nullable IActionCause cause) {
        if (targetData == null || targetData.getPosition() == null) {
            return LauncherStatus.ERROR_TARGET_NULL;
        }
        if (this.host.isTooClose(targetData.getPosition())) {
            return LauncherStatus.ERROR_MIN_RANGE;
        }
        return this.getStatus();
    }

    @Override
    public IActionStatus launch(ILauncherSolution solution, @Nullable IActionCause cause, boolean simulate) {
        ICapabilityMissileStack capabilityMissileStack;
        IMissileTarget target = solution.getTarget(this);
        IActionStatus preCheck = this.preCheckLaunch(target, cause);
        if (preCheck.isType(ActionStatusTypes.BLOCKING)) {
            return preCheck;
        }
        if (simulate) {
            return LauncherStatus.LAUNCHED;
        }
        this.host.setTarget(target.getPosition());
        if (!this.host.isAimed()) {
            this.host.setFiringPackage(new FiringPackage(target, cause, 0));
            return LauncherStatus.FIRING_AIMING;
        }
        CausedByBlock selfCause = new CausedByBlock(this.host.func_145831_w(), this.host.func_174877_v(), this.host.getBlockState());
        selfCause.setPreviousCause(cause);
        ActionSource missileSource = new ActionSource(this.getHost().func_145831_w(), new Vec3d((double)this.host.func_174877_v().func_177958_n() + 0.5, (double)this.host.func_174877_v().func_177956_o() + 2.0, (double)this.host.func_174877_v().func_177952_p() + 0.5), selfCause);
        ItemStack inventoryStack = this.host.missileHolder.getMissileStack();
        if (inventoryStack.hasCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null) && (capabilityMissileStack = (ICapabilityMissileStack)inventoryStack.getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null)) != null) {
            if (this.host.isServer()) {
                IMissile missile = capabilityMissileStack.newMissile(this.host.func_145831_w());
                Entity entity = missile.getMissileEntity();
                entity.func_70107_b(missileSource.getPosition().field_72450_a, missileSource.getPosition().field_72448_b, missileSource.getPosition().field_72449_c);
                if (!this.host.missileHolder.consumeMissile()) {
                    return LauncherStatus.ERROR_INVALID_STACK;
                }
                if (!this.host.energyStorage.consumePower(this.host.getFiringCost(), true)) {
                    return LauncherStatus.ERROR_POWER;
                }
                this.host.energyStorage.consumePower(this.host.getFiringCost(), false);
                missile.setMissileSource(missileSource);
                missile.setTargetData(target);
                missile.setFlightLogic(new DirectFlightLogic(ConfigMissile.CRUISE_FUEL));
                missile.launch();
                if (!this.host.func_145831_w().func_72838_d(entity)) {
                    return LauncherStatus.ERROR_SPAWN;
                }
                return new LaunchedWithMissile().setMissile(missile);
            }
            return LauncherStatus.LAUNCHED;
        }
        return LauncherStatus.ERROR_GENERIC;
    }

    @Override
    public float getPayloadVelocity() {
        return this.host.getMissileHolder().getMissileStack().func_77973_b() == ItemReg.itemSAM ? ConfigMissile.SAM_MISSILE.FLIGHT_SPEED : ConfigMissile.DIRECT_FLIGHT_SPEED;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CLauncherCapability)) {
            return false;
        }
        CLauncherCapability other = (CLauncherCapability)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TileCruiseLauncher this$host = this.getHost();
        TileCruiseLauncher other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CLauncherCapability;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TileCruiseLauncher $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    @Generated
    public TileCruiseLauncher getHost() {
        return this.host;
    }

    @Generated
    public String toString() {
        return "CLauncherCapability(host=" + this.getHost() + ")";
    }

    @Generated
    public CLauncherCapability(TileCruiseLauncher host) {
        this.host = host;
    }
}

