/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.cruise;

import icbm.classic.api.radio.IRadioMessage;
import icbm.classic.api.radio.IRadioReceiver;
import icbm.classic.api.radio.IRadioSender;
import icbm.classic.api.radio.messages.ITargetMessage;
import icbm.classic.api.radio.messages.ITriggerActionMessage;
import icbm.classic.content.blocks.launcher.FiringPackage;
import icbm.classic.content.blocks.launcher.cruise.TileCruiseLauncher;
import icbm.classic.content.missile.logic.source.cause.EntityCause;
import icbm.classic.content.missile.logic.targeting.BasicTargetData;
import icbm.classic.lib.radio.imp.RadioTile;
import icbm.classic.lib.radio.messages.RadioTranslations;
import icbm.classic.lib.radio.messages.TextMessage;
import icbm.classic.prefab.FakeRadioSender;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.util.INBTSerializable;

public class RadioCruise
extends RadioTile<TileCruiseLauncher>
implements IRadioReceiver,
INBTSerializable<NBTTagCompound> {
    public RadioCruise(TileCruiseLauncher host) {
        super(host);
    }

    @Override
    public void onMessage(IRadioSender sender, IRadioMessage packet) {
        if (this.canReceive(sender, packet)) {
            if (packet instanceof ITargetMessage) {
                double vel = ((TileCruiseLauncher)this.host).launcher.getPayloadVelocity();
                Vec3d target = ((ITargetMessage)packet).getIntercept((double)((TileCruiseLauncher)this.host).func_174877_v().func_177958_n() + 0.5, (double)((TileCruiseLauncher)this.host).func_174877_v().func_177956_o() + 0.5, (double)((TileCruiseLauncher)this.host).func_174877_v().func_177952_p() + 0.5, vel);
                if (target != null) {
                    ((TileCruiseLauncher)this.host).setTarget(target);
                    if (!(packet instanceof ITriggerActionMessage)) {
                        sender.onMessageCallback(this, new TextMessage(this.getChannel(), RadioTranslations.RADIO_TARGET_SET, target.field_72450_a, target.field_72448_b, target.field_72449_c));
                    }
                } else {
                    sender.onMessageCallback(this, new TextMessage(this.getChannel(), RadioTranslations.RADIO_TARGET_NULL));
                }
            }
            if (packet instanceof ITriggerActionMessage && ((ITriggerActionMessage)packet).shouldTrigger()) {
                if (((TileCruiseLauncher)this.host).getFiringPackage() != null) {
                    sender.onMessageCallback(this, new TextMessage(this.getChannel(), "info.icbmclassic:launcher.error.missile.queued"));
                    return;
                }
                ((TileCruiseLauncher)this.host).setFiringPackage(this.getFiringPackage(sender, (ITriggerActionMessage)packet));
                sender.onMessageCallback(this, new TextMessage(this.getChannel(), RadioTranslations.RADIO_LAUNCH_TRIGGERED));
            }
        }
    }

    @Nonnull
    private FiringPackage getFiringPackage(IRadioSender sender, ITriggerActionMessage packet) {
        FiringPackage firingPackage = sender instanceof FakeRadioSender ? new FiringPackage(new BasicTargetData(((TileCruiseLauncher)this.host).getTarget()), new EntityCause((Entity)((FakeRadioSender)sender).player), 0) : new FiringPackage(new BasicTargetData(((TileCruiseLauncher)this.host).getTarget()), null, 0);
        firingPackage.setOnTriggerCallback(packet::onTriggerCallback);
        return firingPackage;
    }
}

