/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity;

import icbm.classic.content.blocks.launcher.base.TileLauncherBase;
import icbm.classic.lib.transform.rotation.EulerAngle;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityPlayerSeat
extends Entity
implements IEntityAdditionalSpawnData {
    private TileLauncherBase host;
    private BlockPos hostPos;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public float offsetZ = 0.0f;
    public EnumFacing prevFace;
    public EnumFacing prevRotation;
    public boolean prevRiding;

    public EntityPlayerSeat(World world) {
        super(world);
    }

    public void setHost(TileLauncherBase host) {
        this.host = host;
        this.hostPos = host != null ? host.func_174877_v() : null;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    protected void func_70088_a() {
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
    }

    public void func_184226_ay() {
        for (int i = this.func_184188_bt().size() - 1; i >= 0; --i) {
            Entity entity = (Entity)this.func_184188_bt().get(i);
            double prevX = entity.field_70165_t;
            double prevY = entity.field_70163_u;
            double prevZ = entity.field_70161_v;
            entity.func_184210_p();
            if (!(Math.abs(prevX - entity.field_70165_t) > 2.0) && !(Math.abs(prevY - entity.field_70161_v) > 2.0) && !(Math.abs(prevZ - entity.field_70161_v) > 2.0)) continue;
            entity.func_70107_b(prevX, prevY, prevZ);
        }
    }

    public void func_70030_z() {
        TileEntity tile;
        if (this.host == null && this.hostPos != null && (tile = this.field_70170_p.func_175625_s(this.hostPos)) instanceof TileLauncherBase) {
            this.host = (TileLauncherBase)tile;
            this.host.seat = this;
        }
        if (!this.field_70170_p.field_72995_K && (this.host == null || this.host.func_145837_r() || this.field_70163_u < -64.0)) {
            this.func_184226_ay();
            this.func_70106_y();
        }
        if (this.host != null && (this.prevFace != this.host.getLaunchDirection() || this.prevRotation != this.host.getSeatSide() || this.prevRiding != this.func_184207_aI())) {
            this.prevFace = this.host.getLaunchDirection();
            this.prevRotation = this.host.getSeatSide();
            this.prevRiding = this.func_184207_aI();
            this.updatePosition(this.host.getLaunchDirection(), this.host.getSeatSide());
            this.updateBox(this.host.getLaunchDirection(), this.host.getSeatSide());
        }
    }

    protected void updatePosition(EnumFacing face, EnumFacing rotation) {
        this.offsetX = (float)rotation.func_82601_c() * 0.2f;
        this.offsetY = (float)rotation.func_96559_d() * 0.2f;
        this.offsetZ = (float)rotation.func_82599_e() * 0.2f;
        this.offsetX += (float)face.func_82601_c() * 0.5f;
        this.offsetY += (float)face.func_96559_d() * 0.5f;
        this.offsetZ += (float)face.func_82599_e() * 0.5f;
        if (face == EnumFacing.DOWN) {
            this.offsetY -= this.field_70131_O;
        } else if (face == EnumFacing.EAST) {
            this.offsetX += this.field_70130_N / 2.0f;
            this.offsetY -= 0.6f;
        } else if (face == EnumFacing.WEST) {
            this.offsetX -= this.field_70130_N / 2.0f;
            this.offsetY -= 0.6f;
        } else if (face == EnumFacing.NORTH) {
            this.offsetZ -= this.field_70130_N / 2.0f;
            this.offsetY -= 0.6f;
        } else if (face == EnumFacing.SOUTH) {
            this.offsetZ += this.field_70130_N / 2.0f;
            this.offsetY -= 0.6f;
        }
        double posX = (double)this.host.func_174877_v().func_177958_n() + 0.5 + (double)face.func_82601_c() * 0.5;
        double posY = (double)this.host.func_174877_v().func_177956_o() + 0.5 + (double)face.func_96559_d() * 0.5;
        double posZ = (double)this.host.func_174877_v().func_177952_p() + 0.5 + (double)face.func_82599_e() * 0.5;
        this.func_70107_b(posX, posY, posZ);
        EulerAngle angle = new EulerAngle(rotation);
        this.field_70177_z = this.field_70126_B = (float)angle.yaw();
        this.field_70125_A = this.field_70127_C = (float)angle.pitch();
    }

    protected void updateBox(EnumFacing face, EnumFacing rotation) {
        float dimB;
        float dimA;
        if (face == EnumFacing.UP || face == EnumFacing.DOWN) {
            this.func_70105_a(0.5f, this.func_184207_aI() ? 0.5f : 2.5f);
            dimA = this.field_70130_N / 2.0f;
            dimB = this.field_70131_O;
        } else {
            this.func_70105_a(this.func_184207_aI() ? 0.5f : 2.5f, 0.5f);
            dimA = this.field_70131_O / 2.0f;
            dimB = this.field_70130_N;
        }
        if (face == EnumFacing.UP) {
            double minX = this.field_70165_t - (double)dimA;
            double minY = this.field_70163_u;
            double minZ = this.field_70161_v - (double)dimA;
            double maxX = this.field_70165_t + (double)dimA;
            double maxY = this.field_70163_u + (double)dimB;
            double maxZ = this.field_70161_v + (double)dimA;
            this.func_174826_a(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        } else if (face == EnumFacing.DOWN) {
            double minX = this.field_70165_t - (double)dimA;
            double minY = this.field_70163_u - (double)dimB;
            double minZ = this.field_70161_v - (double)dimA;
            double maxX = this.field_70165_t + (double)dimA;
            double maxY = this.field_70163_u;
            double maxZ = this.field_70161_v + (double)dimA;
            this.func_174826_a(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        } else if (face == EnumFacing.EAST) {
            double minX = this.field_70165_t;
            double minY = this.field_70163_u - (double)dimA;
            double minZ = this.field_70161_v - (double)dimA;
            double maxX = this.field_70165_t + (double)dimB;
            double maxY = this.field_70163_u + (double)dimA;
            double maxZ = this.field_70161_v + (double)dimA;
            this.func_174826_a(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        } else if (face == EnumFacing.WEST) {
            double minX = this.field_70165_t - (double)dimB;
            double minY = this.field_70163_u - (double)dimA;
            double minZ = this.field_70161_v - (double)dimA;
            double maxX = this.field_70165_t;
            double maxY = this.field_70163_u + (double)dimA;
            double maxZ = this.field_70161_v + (double)dimA;
            this.func_174826_a(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        } else if (face == EnumFacing.NORTH) {
            double minX = this.field_70165_t - (double)dimA;
            double minY = this.field_70163_u - (double)dimA;
            double minZ = this.field_70161_v - (double)dimB;
            double maxX = this.field_70165_t + (double)dimA;
            double maxY = this.field_70163_u + (double)dimA;
            double maxZ = this.field_70161_v;
            this.func_174826_a(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        } else if (face == EnumFacing.SOUTH) {
            double minX = this.field_70165_t - (double)dimA;
            double minY = this.field_70163_u - (double)dimA;
            double minZ = this.field_70161_v;
            double maxX = this.field_70165_t + (double)dimA;
            double maxY = this.field_70163_u + (double)dimA;
            double maxZ = this.field_70161_v + (double)dimB;
            this.func_174826_a(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        }
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72866_a((Entity)this, false);
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return false;
        }
        if (this.func_184207_aI()) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            ItemStack itemStack;
            if (player.func_184812_l_() && (itemStack = player.func_184586_b(hand)).func_77973_b() == Items.field_151143_au) {
                EntityMinecartEmpty cart = new EntityMinecartEmpty(this.field_70170_p);
                cart.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)cart);
                cart.func_184220_m((Entity)this);
                return true;
            }
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70105_a(float width, float height) {
        this.field_70130_N = width;
        this.field_70131_O = height;
    }

    public double func_70042_X() {
        return this.offsetY;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        if (this.func_184188_bt().contains(entityIn)) {
            return null;
        }
        return super.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        if (!this.func_184188_bt().isEmpty()) {
            return null;
        }
        return this.func_174813_aQ();
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger) && this.host != null) {
            double x = this.field_70165_t + (double)this.offsetX + passenger.func_70033_W() * (double)(this.prevFace != null ? this.prevFace.func_82601_c() : 0);
            double y = this.field_70163_u + (double)this.offsetY + passenger.func_70033_W() * (double)(this.prevFace != null ? this.prevFace.func_96559_d() : 0);
            double z = this.field_70161_v + (double)this.offsetZ + passenger.func_70033_W() * (double)(this.prevFace != null ? this.prevFace.func_82599_e() : 0);
            passenger.func_70107_b(x, y, z);
        }
    }

    public void func_70108_f(Entity p_70108_1_) {
    }

    public void func_70024_g(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
    }

    protected void func_70037_a(NBTTagCompound save) {
        if (save.func_74764_b("pos")) {
            this.hostPos = NBTUtil.func_186861_c((NBTTagCompound)save.func_74775_l("pos"));
        }
    }

    protected void func_70014_b(NBTTagCompound save) {
        if (this.hostPos != null) {
            save.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.hostPos));
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.host != null);
        if (this.host != null) {
            buffer.writeInt(this.host.func_174877_v().func_177958_n());
            buffer.writeInt(this.host.func_174877_v().func_177956_o());
            buffer.writeInt(this.host.func_174877_v().func_177952_p());
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        TileEntity tile;
        if (additionalData.readBoolean() && (tile = this.field_70170_p.func_175625_s(new BlockPos(additionalData.readInt(), additionalData.readInt(), additionalData.readInt()))) instanceof TileLauncherBase) {
            this.host = (TileLauncherBase)tile;
        }
    }
}

