/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity.flyingblock;

import icbm.classic.ICBMClassic;
import icbm.classic.config.ConfigFlyingBlocks;
import icbm.classic.content.entity.flyingblock.BlockCaptureData;
import icbm.classic.lib.projectile.EntityProjectile;
import icbm.classic.lib.saving.NbtSaveHandler;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityFlyingBlock
extends EntityProjectile<EntityFlyingBlock>
implements IEntityAdditionalSpawnData {
    private BlockCaptureData blockData;
    public float yawChange = 0.0f;
    public float pitchChange = 0.0f;
    private float gravity = 0.05f;
    private static final NbtSaveHandler<EntityFlyingBlock> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeFloat("gravity", EntityFlyingBlock::getGravity, EntityFlyingBlock::setGravity).nodeINBTSerializable("mimic_block", EntityFlyingBlock::getBlockData).base();

    public EntityFlyingBlock(World world) {
        super(world);
        this.field_70173_aa = 0;
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.func_70105_a(0.98f, 0.98f);
        this.inGroundKillTime = 20;
    }

    public void restoreGravity() {
        this.gravity = 0.05f;
    }

    public BlockCaptureData getBlockData() {
        if (this.blockData == null) {
            this.blockData = new BlockCaptureData();
        }
        return this.blockData;
    }

    @Nonnull
    public String func_70005_c_() {
        return "Flying Block [" + this.getBlockData().getBlockState() + ", " + this.hashCode() + "]";
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)this.getBlockData().serializeNBT());
        data.writeFloat(this.gravity);
        data.writeFloat(this.yawChange);
        data.writeFloat(this.pitchChange);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        this.getBlockData().deserializeNBT(ByteBufUtils.readTag((ByteBuf)data));
        this.gravity = data.readFloat();
        this.yawChange = data.readFloat();
        this.pitchChange = data.readFloat();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.yawChange > 0.0f) {
            this.field_70177_z += this.yawChange;
            this.yawChange -= 2.0f;
        }
        if (this.pitchChange > 0.0f) {
            this.field_70125_A += this.pitchChange;
            this.pitchChange -= 2.0f;
        }
    }

    @Override
    protected boolean shouldExpire() {
        return super.shouldExpire() || this.field_70163_u > 400.0;
    }

    @Override
    protected void destroy() {
        this.placeBlockIntoWorld(this.getPos(), new RayTraceResult(this.func_174791_d(), EnumFacing.UP));
        this.func_70106_y();
    }

    @Override
    protected boolean shouldCollideWith(Entity entity) {
        return super.shouldCollideWith(entity) && !(entity instanceof EntityFlyingBlock);
    }

    @Override
    protected void onImpact(@Nonnull RayTraceResult impactLocation) {
        if (this.ticksInAir < 5) {
            return;
        }
        if (impactLocation.field_72308_g == null) {
            this.placeBlockIntoWorld(new BlockPos(impactLocation.field_72307_f), impactLocation);
        } else {
            this.dropSourceStack(this.getBlockData().getSourceStack());
        }
    }

    public void placeBlockIntoWorld(BlockPos pos, RayTraceResult hit) {
        this.func_70106_y();
        if (!this.field_70170_p.field_72995_K && this.isServer() && !this.tryPlacement(pos, hit)) {
            this.dropSourceStack(this.getBlockData().getSourceStack());
        }
    }

    protected boolean tryPlacement(BlockPos pos, RayTraceResult hit) {
        IBlockState blockState;
        ItemStack sourceStack = this.blockData.getSourceStack();
        if (!sourceStack.func_190926_b()) {
            FakePlayer player = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_70170_p));
            player.func_184611_a(EnumHand.MAIN_HAND, sourceStack);
            EnumActionResult result = sourceStack.func_77973_b().func_180614_a((EntityPlayer)player, this.field_70170_p, pos, EnumHand.MAIN_HAND, hit.field_178784_b, (float)hit.field_72307_f.field_72450_a, (float)hit.field_72307_f.field_72448_b, (float)hit.field_72307_f.field_72449_c);
            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            if (result == EnumActionResult.SUCCESS) {
                return true;
            }
        }
        if (this.field_70170_p.func_190527_a((blockState = this.getBlockData().getBlockState()).func_177230_c(), pos, true, EnumFacing.UP, (Entity)this)) {
            NBTTagCompound currentSave;
            TileEntity tileentity;
            if (!this.field_70170_p.func_180501_a(pos, blockState, 11)) {
                return false;
            }
            if (this.getBlockData().getTileEntityData() != null && (tileentity = this.field_70170_p.func_175625_s(pos)) != null && (currentSave = tileentity.func_189515_b(new NBTTagCompound())).func_74779_i("id").equals(this.getBlockData().getTileEntityData().func_74779_i("id"))) {
                currentSave.func_179237_a(this.getBlockData().getTileEntityData());
                currentSave.func_74768_a("x", pos.func_177958_n());
                currentSave.func_74768_a("y", pos.func_177956_o());
                currentSave.func_74768_a("z", pos.func_177952_p());
                tileentity.func_145839_a(currentSave);
                tileentity.func_70296_d();
            }
            SoundType soundtype = blockState.func_177230_c().getSoundType(blockState, this.field_70170_p, pos, (Entity)this);
            this.field_70170_p.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            return true;
        }
        return false;
    }

    protected void dropSourceStack(ItemStack itemStack) {
        if (itemStack != null && !itemStack.func_190926_b()) {
            EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityItem.func_92058_a(itemStack);
            if (!this.field_70170_p.func_72838_d((Entity)entityItem)) {
                ICBMClassic.logger().error("EntityFlyingBlock: Failed to drop source stack '{}' at dim[{}] pos[{}]", (Object)itemStack, (Object)this.field_70170_p.field_73011_w.getDimension(), (Object)this.getPos());
            }
        }
    }

    @Override
    protected DamageSource getImpactDamageSource(Entity entityHit, float velocity, RayTraceResult hit) {
        return DamageSource.field_82729_p;
    }

    @Override
    protected float getImpactDamage(Entity entityHit, float velocity, RayTraceResult hit) {
        return MathHelper.func_76123_f((float)(velocity * ConfigFlyingBlocks.damageScale));
    }

    @Override
    public void func_70014_b(NBTTagCompound save) {
        super.func_70014_b(save);
        SAVE_LOGIC.save(this, save);
    }

    @Override
    public void func_70037_a(NBTTagCompound save) {
        super.func_70037_a(save);
        SAVE_LOGIC.load(this, save);
    }

    public boolean func_70104_M() {
        return true;
    }

    @Override
    protected boolean func_70041_e_() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    @Generated
    void setBlockData(BlockCaptureData blockData) {
        this.blockData = blockData;
    }

    @Override
    @Generated
    public float getGravity() {
        return this.gravity;
    }

    @Generated
    public void setGravity(float gravity) {
        this.gravity = gravity;
    }
}

