/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.gas;

import icbm.classic.config.ConfigMain;
import icbm.classic.config.util.ItemStackConfigList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ProtectiveArmorHandler {
    public static final ItemStackConfigList.FloatOut protectionValues = new ItemStackConfigList.FloatOut("[CargoHolder][Ban/Allow Config]", configList -> {
        configList.setDefault(new ResourceLocation("atomicscience", "hazmat_color_mask"), Float.valueOf(0.75f), 1);
        configList.setDefault(new ResourceLocation("atomicscience", "hazmat_color_body"), Float.valueOf(0.15f), 1);
        configList.setDefault(new ResourceLocation("atomicscience", "hazmat_color_leggings"), Float.valueOf(0.05f), 1);
        configList.setDefault(new ResourceLocation("atomicscience", "hazmat_color_boots"), Float.valueOf(0.05f), 1);
        configList.setDefault(new ResourceLocation("atomicscience", "hazmat_mask"), Float.valueOf(0.75f), 1);
        configList.setDefault(new ResourceLocation("atomicscience", "hazmat_body"), Float.valueOf(0.15f), 1);
        configList.setDefault(new ResourceLocation("atomicscience", "hazmat_leggings"), Float.valueOf(0.05f), 1);
        configList.setDefault(new ResourceLocation("atomicscience", "hazmat_boots"), Float.valueOf(0.05f), 1);
        configList.load("icbmclassic/main/protective_armor/item_ratings", ConfigMain.protectiveArmor.ITEMS);
    });

    public static void setup() {
        ProtectiveArmorHandler.loadFromConfig();
    }

    public static float getValue(ItemStack itemStack) {
        Float value = (Float)protectionValues.getValue(itemStack);
        return value != null ? Math.min(1.0f, Math.max(0.0f, value.floatValue())) : 0.0f;
    }

    public static void loadFromConfig() {
        protectionValues.reload();
    }

    public static float getProtectionRating(EntityLivingBase entityLivingBase) {
        if (ConfigMain.protectiveArmor.requireHelmet && entityLivingBase.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
            return 0.0f;
        }
        float value = 0.0f;
        for (ItemStack armorStack : entityLivingBase.func_184193_aE()) {
            value += ProtectiveArmorHandler.getValue(armorStack);
        }
        return value;
    }
}

