/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.entity;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IEMPReceiver;
import icbm.classic.api.events.MissileEvent;
import icbm.classic.api.events.MissileRideEvent;
import icbm.classic.api.missiles.parts.IMissileFlightLogic;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.missile.entity.CapabilityEmpMissile;
import icbm.classic.content.missile.entity.CapabilityMissile;
import icbm.classic.content.missile.logic.flight.BallisticFlightLogicOld;
import icbm.classic.content.missile.logic.flight.DeadFlightLogic;
import icbm.classic.lib.CalculationHelpers;
import icbm.classic.lib.capability.chicken.CapSpaceChicken;
import icbm.classic.lib.capability.emp.CapabilityEMP;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.lambda.PacketCodexReg;
import icbm.classic.lib.network.lambda.entity.PacketCodexEntity;
import icbm.classic.lib.projectile.EntityProjectile;
import icbm.classic.lib.radar.RadarRegistry;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.saving.NbtSaveNode;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityMissile<E extends EntityMissile<E>>
extends EntityProjectile<E>
implements IEntityAdditionalSpawnData,
IPacketIDReceiver {
    private final HashSet<Entity> collisionIgnoreList = new HashSet();
    private final CapabilityMissile missileCapability = new CapabilityMissile(this);
    private final IEMPReceiver empCapability = new CapabilityEmpMissile(this.getMissileCapability());
    protected boolean hasImpacted = false;
    protected boolean syncClient = false;
    private static final NbtSaveHandler<EntityMissile> SAVE_LOGIC = new NbtSaveHandler().mainRoot().node(new NbtSaveNode<EntityMissile, NBTTagCompound>("missile", missile -> missile.getMissileCapability().serializeNBT(), (missile, data) -> missile.getMissileCapability().deserializeNBT((NBTTagCompound)data))).base();
    public static final PacketCodexEntity<EntityMissile, EntityMissile> PACKET_DESC = (PacketCodexEntity)new PacketCodexEntity(new ResourceLocation("icbmclassic", "missile"), "description").nodeNbtCompound(SAVE_LOGIC::save, SAVE_LOGIC::load);

    public EntityMissile(World world) {
        super(world);
        this.hasHealth = true;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEMP.EMP) {
            return (T)this.getEmpCapability();
        }
        if (capability == ICBMClassicAPI.MISSILE_CAPABILITY) {
            return (T)this.getMissileCapability();
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEMP.EMP || capability == ICBMClassicAPI.MISSILE_CAPABILITY || super.hasCapability(capability, facing);
    }

    public EntityMissile<E> ignore(Entity entity) {
        this.collisionIgnoreList.add(entity);
        return this;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.syncClient) {
            this.syncClient = false;
            PACKET_DESC.sendToAllAround(this);
        }
    }

    @Override
    protected void updateMotion() {
        if (this.getMissileCapability().canRunFlightLogic()) {
            Optional.ofNullable(this.getMissileCapability().getFlightLogic()).ifPresent(logic -> {
                logic.onEntityTick(this, this.missileCapability, this.ticksInAir);
                if (logic.shouldRunEngineEffects(this)) {
                    ICBMClassic.proxy.spawnMissileSmoke(this, (IMissileFlightLogic)logic, this.ticksInAir);
                    ICBMSounds.MISSILE_ENGINE.play(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, Math.min(1.0f, (float)this.ticksInAir / 40.0f), (1.0f + CalculationHelpers.randFloatRange(this.field_70170_p.field_73012_v, 0.2f)) * 0.7f, true);
                }
            });
            ICBMClassicAPI.EX_MISSILE_REGISTRY.triggerFlightUpdate(this.getMissileCapability());
        }
        super.updateMotion();
    }

    @Override
    protected void decreaseMotion() {
        if (this.getMissileCapability().getFlightLogic() == null || this.getMissileCapability().getFlightLogic().shouldDecreaseMotion(this)) {
            super.decreaseMotion();
        }
    }

    @Override
    protected void handleEntityCollision(@Nonnull RayTraceResult hit, @Nonnull Entity entityHit) {
        if (entityHit instanceof EntityChicken) {
            if (this.func_184187_bx() == null) {
                CapSpaceChicken cap;
                ICBMSounds.MEEP.play(entityHit, 2.0f, 1.0f, true);
                entityHit.func_184205_a((Entity)this, true);
                if (entityHit.hasCapability(CapSpaceChicken.INSTANCE, null) && (cap = (CapSpaceChicken)entityHit.getCapability(CapSpaceChicken.INSTANCE, null)) != null) {
                    cap.setSpace(true);
                }
            }
        } else {
            this.onImpactEntity(entityHit, (float)this.getVelocity().magnitude(), hit);
        }
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (this.collisionIgnoreList.contains(entity)) {
            return null;
        }
        return this.func_174813_aQ();
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            RadarRegistry.remove(this);
        }
        super.func_70106_y();
    }

    public boolean func_70067_L() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72321_a(5.0, 5.0, 5.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityMissile.func_184183_bd()) * d0;
    }

    @Override
    public boolean shouldAlignWithMotion() {
        return Optional.ofNullable(this.missileCapability.getFlightLogic()).map(logic -> logic.shouldAlignWithMotion(this)).orElse(false);
    }

    public boolean func_184230_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (!(this.field_70170_p.field_72995_K || this.func_184187_bx() != null && this.func_184187_bx() != player || MinecraftForge.EVENT_BUS.post((Event)new MissileRideEvent.Start(this.getMissileCapability(), player)))) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    public double func_70042_X() {
        if (this.ticksInAir <= 0 && this.getMissileCapability().getFlightLogic() instanceof BallisticFlightLogicOld) {
            return this.field_70131_O;
        }
        if (this.getMissileCapability().getFlightLogic() instanceof DeadFlightLogic) {
            return this.field_70131_O / 10.0f;
        }
        return (double)(this.field_70131_O / 2.0f) + this.field_70181_x;
    }

    @Override
    protected boolean ignoreImpact(RayTraceResult hit) {
        return MinecraftForge.EVENT_BUS.post((Event)new MissileEvent.PreImpact(this.getMissileCapability(), this, hit));
    }

    @Override
    protected void postImpact(RayTraceResult hit) {
        MinecraftForge.EVENT_BUS.post((Event)new MissileEvent.PostImpact(this.getMissileCapability(), this, hit));
    }

    @Override
    protected boolean shouldCollideWith(Entity entityHit) {
        return super.shouldCollideWith(entityHit) && !this.isRider(entityHit) && entityHit != this.shootingEntity;
    }

    public boolean isRider(Entity entity) {
        return entity != null && (entity.func_184187_bx() == this || this.isRider(entity.func_184187_bx()));
    }

    public boolean hasPlayerRiding() {
        return EntityMissile.hasPlayerRiding(this);
    }

    public static boolean hasPlayerRiding(Entity entity) {
        return entity.func_184188_bt().stream().anyMatch(e -> e instanceof EntityPlayer || EntityMissile.hasPlayerRiding(e));
    }

    @Override
    protected final void onImpact(@Nonnull RayTraceResult impactLocation) {
        if (!this.hasImpacted) {
            this.hasImpacted = true;
            this.logImpact(impactLocation.field_72307_f);
            this.actionOnImpact(impactLocation);
        }
    }

    protected void actionOnImpact(RayTraceResult impactLocation) {
        this.destroy();
    }

    protected void logImpact(Vec3d impactLocation) {
        String formatString = "Missile[%s] (%sx, %sy, %sz, %sd) impacted at (%s, %s, %s)";
        String formattedMessage = String.format("Missile[%s] (%sx, %sy, %sz, %sd) impacted at (%s, %s, %s)", this.func_145782_y(), this.xi(), this.yi(), this.zi(), this.world().field_73011_w.getDimension(), impactLocation.field_72450_a, impactLocation.field_72448_b, impactLocation.field_72449_c);
        ICBMClassic.logger().info(formattedMessage);
    }

    @Override
    protected float getImpactDamage(Entity entityHit, float velocity, RayTraceResult hit) {
        if (ConfigMissile.DAMAGE_LIMIT >= 0) {
            return Math.min(MathHelper.func_76123_f((float)(velocity * ConfigMissile.DAMAGE_SCALE)), ConfigMissile.DAMAGE_LIMIT);
        }
        return MathHelper.func_76123_f((float)(velocity * ConfigMissile.DAMAGE_SCALE));
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, IPacket type) {
        if (id == 1) {
            this.readSpawnData(buf);
            return true;
        }
        return false;
    }

    @Override
    public void writeSpawnData(ByteBuf additionalMissileData) {
        super.writeSpawnData(additionalMissileData);
        NBTTagCompound saveData = SAVE_LOGIC.save(this, new NBTTagCompound());
        ByteBufUtils.writeTag((ByteBuf)additionalMissileData, (NBTTagCompound)saveData);
    }

    @Override
    public void readSpawnData(ByteBuf additionalMissileData) {
        super.readSpawnData(additionalMissileData);
        NBTTagCompound saveData = ByteBufUtils.readTag((ByteBuf)additionalMissileData);
        SAVE_LOGIC.load(this, saveData);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        SAVE_LOGIC.save(this, nbt);
    }

    public abstract ItemStack toStack();

    @Generated
    public CapabilityMissile getMissileCapability() {
        return this.missileCapability;
    }

    @Generated
    public IEMPReceiver getEmpCapability() {
        return this.empCapability;
    }

    static {
        PacketCodexReg.register(PACKET_DESC);
    }
}

