/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.entity.itemstack;

import com.google.common.collect.Multimap;
import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.ICapabilityMissileStack;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.missile.entity.EntityMissile;
import icbm.classic.content.missile.entity.itemstack.HeldActionMode;
import icbm.classic.content.missile.entity.itemstack.item.CapabilityHeldItemMissile;
import icbm.classic.content.missile.entity.itemstack.item.HeldItemMissileHandler;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.world.IProjectileBlockInteraction;
import icbm.classic.lib.world.ProjectileBlockInteraction;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class EntityHeldItemMissile
extends EntityMissile<EntityHeldItemMissile>
implements IEntityAdditionalSpawnData {
    private ItemStack renderStackCache;
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(1);
    private HeldActionMode actionMode = HeldActionMode.PRIMARY_FIRST;
    boolean hasUsedAction = false;
    private static final NbtSaveHandler<EntityHeldItemMissile> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeINBTSerializable("inventory", EntityHeldItemMissile::getItemStackHandler).nodeEnumString("action_mode", EntityHeldItemMissile::getActionMode, EntityHeldItemMissile::setActionMode, HeldActionMode::valueOf).base();

    public EntityHeldItemMissile(World world) {
        super(world);
        this.setMaxHealth(ConfigMissile.TIER_2_HEALTH);
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
        super.func_70071_h_();
    }

    @Override
    protected IProjectileBlockInteraction.EnumHitReactions specialHandleBlock(RayTraceResult hit, double velocity) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack held = this.itemStackHandler.getStackInSlot(0);
            if (!this.hasUsedAction && !held.func_190926_b() && HeldItemMissileHandler.isAllowed(held)) {
                try {
                    if (this.actionMode == HeldActionMode.PRIMARY || this.actionMode == HeldActionMode.PRIMARY_FIRST) {
                        this.usePrimaryOnPosition(held, hit, velocity);
                        if (this.actionMode == HeldActionMode.PRIMARY_FIRST) {
                            this.useSecondaryOnPosition(held, hit);
                        }
                    } else {
                        this.useSecondaryOnPosition(held, hit);
                        if (this.actionMode == HeldActionMode.SECONDARY_FIRST) {
                            this.usePrimaryOnPosition(held, hit, velocity);
                        }
                    }
                }
                catch (Exception e) {
                    this.hasUsedAction = true;
                    ICBMClassic.logger().error("Failed to mimic player interaction during missile impact. Missile: {}", (Object)this);
                    ICBMClassic.logger().error("Impact error", (Throwable)e);
                }
            }
            if (this.hasUsedAction) {
                return IProjectileBlockInteraction.EnumHitReactions.CONTINUE;
            }
            return ProjectileBlockInteraction.handleSpecialInteraction(this.field_70170_p, this.getInGroundData().getPos(), hit.field_72307_f, this.getInGroundData().getSide(), this.getInGroundData().getState(), this);
        }
        return IProjectileBlockInteraction.EnumHitReactions.PASS;
    }

    @Override
    protected void actionOnImpact(RayTraceResult hit) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70089_S()) {
                this.func_70099_a(this.toStack(), 0.0f);
            }
            this.destroy();
        }
    }

    private void usePrimaryOnPosition(ItemStack held, RayTraceResult hit, double velocity) {
        FakePlayer player = this.getFakePlayer(new Vec3d(hit.field_72307_f.field_72450_a + (double)hit.field_178784_b.func_82601_c(), hit.field_72307_f.field_72448_b + (double)hit.field_178784_b.func_96559_d(), hit.field_72307_f.field_72449_c + (double)hit.field_178784_b.func_82599_e()));
        player.func_184611_a(EnumHand.MAIN_HAND, held.func_77946_l());
        BlockPos pos = hit.func_178782_a();
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if (held.func_77973_b().onBlockStartBreak(held, pos, (EntityPlayer)player)) {
            this.hasUsedAction = true;
        } else if (state.func_177230_c().canHarvestBlock((IBlockAccess)this.field_70170_p, pos, (EntityPlayer)player)) {
            float digSpeed;
            if (player.func_184614_ca().func_77973_b().getToolClasses(held).isEmpty()) {
                this.resetFakePlayer(player);
                return;
            }
            float toolSpeed = player.func_184614_ca().func_150997_a(state);
            float hardness = state.func_185887_b(this.field_70170_p, pos);
            if (hardness <= (digSpeed = toolSpeed * (float)velocity * ConfigMissile.HELD_ITEM_MISSILE.BLOCK_DAMAGE_MULTIPLIER)) {
                this.hasUsedAction = true;
                String clazzName = state.func_177230_c().getClass().getName();
                if (clazzName.startsWith("com.ferreusveritas.dynamictrees.blocks.") && clazzName.contains("Branch")) {
                    this.handleDynamicTreeBreak(state, this.field_70170_p, pos, (EntityLivingBase)player);
                } else if (state.func_177230_c().removedByPlayer(state, this.field_70170_p, pos, (EntityPlayer)player, true)) {
                    state.func_177230_c().func_180657_a(this.field_70170_p, (EntityPlayer)player, pos, state, this.world().func_175625_s(pos), player.func_184586_b(EnumHand.MAIN_HAND));
                    state.func_177230_c().func_176206_d(this.field_70170_p, pos, state);
                }
            }
        }
        if (this.hasUsedAction) {
            this.itemStackHandler.setStackInSlot(0, player.func_184614_ca());
        }
        this.resetFakePlayer(player);
    }

    private void handleDynamicTreeBreak(IBlockState state, World world, BlockPos pos, EntityLivingBase player) {
        try {
            Class<?> clazz = state.func_177230_c().getClass();
            Method method = clazz.getMethod("futureBreak", IBlockState.class, World.class, BlockPos.class, EntityLivingBase.class);
            method.invoke((Object)state.func_177230_c(), state, world, pos, player);
        }
        catch (Exception e) {
            ICBMClassic.logger().error("Failed to handle breaking dynamic tree. Missile: " + this, (Throwable)e);
        }
    }

    private void useSecondaryOnPosition(ItemStack held, RayTraceResult hit) {
        FakePlayer player = this.getFakePlayer(new Vec3d(hit.field_72307_f.field_72450_a + (double)hit.field_178784_b.func_82601_c(), hit.field_72307_f.field_72448_b + (double)hit.field_178784_b.func_96559_d(), hit.field_72307_f.field_72449_c + (double)hit.field_178784_b.func_82599_e()));
        player.func_184611_a(EnumHand.MAIN_HAND, held.func_77946_l());
        EnumActionResult ret = held.onItemUseFirst((EntityPlayer)player, this.field_70170_p, hit.func_178782_a(), EnumHand.MAIN_HAND, hit.field_178784_b, 0.0f, 0.0f, 0.0f);
        if (ret == EnumActionResult.PASS) {
            held.func_179546_a((EntityPlayer)player, this.field_70170_p, hit.func_178782_a(), EnumHand.MAIN_HAND, hit.field_178784_b, 0.0f, 0.0f, 0.0f);
        }
        this.itemStackHandler.setStackInSlot(0, player.func_184586_b(EnumHand.MAIN_HAND));
        this.resetFakePlayer(player);
    }

    @Override
    protected void onImpactEntity(@Nonnull Entity entityHit, float velocity, @Nonnull RayTraceResult hit) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack held = this.itemStackHandler.getStackInSlot(0);
            FakePlayer player = this.getFakePlayer(hit.field_72307_f);
            if (!held.func_190926_b() && HeldItemMissileHandler.isAllowed(held)) {
                if (this.actionMode == HeldActionMode.PRIMARY || this.actionMode == HeldActionMode.PRIMARY_FIRST) {
                    this.useItemPrimaryOnEntity(player, held, entityHit, velocity);
                    if (this.actionMode == HeldActionMode.PRIMARY_FIRST) {
                        this.useItemSecondaryOnEntity(player, held, entityHit);
                    }
                } else {
                    this.useItemSecondaryOnEntity(player, held, entityHit);
                    if (this.actionMode == HeldActionMode.SECONDARY_FIRST) {
                        this.useItemPrimaryOnEntity(player, held, entityHit, velocity);
                    }
                }
            }
            this.onImpact(hit);
        }
    }

    private void useItemSecondaryOnEntity(FakePlayer player, ItemStack held, Entity entityHit) {
        player.func_184611_a(EnumHand.MAIN_HAND, held.func_77946_l());
        if (entityHit instanceof EntityLivingBase) {
            boolean bl = this.hasUsedAction = player.func_190775_a(entityHit, EnumHand.MAIN_HAND) == EnumActionResult.SUCCESS;
            if (!this.hasUsedAction) {
                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                player.func_184611_a(EnumHand.OFF_HAND, held.func_77946_l());
                boolean bl2 = this.hasUsedAction = player.func_190775_a(entityHit, EnumHand.OFF_HAND) == EnumActionResult.SUCCESS;
                if (this.hasUsedAction) {
                    this.itemStackHandler.setStackInSlot(0, player.func_184586_b(EnumHand.OFF_HAND));
                }
            } else {
                this.itemStackHandler.setStackInSlot(0, player.func_184586_b(EnumHand.MAIN_HAND));
            }
        }
        this.resetFakePlayer(player);
    }

    private FakePlayer getFakePlayer(Vec3d pos) {
        FakePlayer player = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_70170_p));
        player.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        this.resetFakePlayer(player);
        return player;
    }

    private void resetFakePlayer(FakePlayer player) {
        player.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
        player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        player.func_184210_p();
    }

    private void useItemPrimaryOnEntity(FakePlayer player, ItemStack held, Entity entityHit, float velocity) {
        player.func_184611_a(EnumHand.MAIN_HAND, held.func_77946_l());
        if (entityHit instanceof EntityLivingBase) {
            Multimap attributes = held.func_111283_C(EntityEquipmentSlot.MAINHAND);
            if (attributes.containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
                int j;
                AttributeMap attributeMap = new AttributeMap();
                attributeMap.func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
                attributeMap.func_111147_b(attributes);
                IAttributeInstance attributeInstance = attributeMap.func_111151_a(SharedMonsterAttributes.field_111264_e);
                double damage = attributeInstance.func_111126_e();
                damage += (double)EnchantmentHelper.func_152377_a((ItemStack)held, (EnumCreatureAttribute)((EntityLivingBase)entityHit).func_70668_bt());
                damage *= (double)velocity;
                if (damage > 0.0) {
                    FakePlayer attacker = this.shootingEntity instanceof EntityLivingBase ? (EntityLivingBase)this.shootingEntity : player;
                    entityHit.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)attacker), (float)damage);
                }
                if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)player)) > 0) {
                    entityHit.func_70015_d(j * 4);
                }
                this.func_174815_a((EntityLivingBase)player, entityHit);
            }
            this.hasUsedAction = held.func_77973_b().func_77644_a(held, (EntityLivingBase)entityHit, (EntityLivingBase)player);
            if (this.hasUsedAction) {
                this.itemStackHandler.setStackInSlot(0, player.func_184586_b(EnumHand.MAIN_HAND));
            }
        }
        this.resetFakePlayer(player);
    }

    @Override
    protected float getImpactDamage(Entity entityHit, float velocity, RayTraceResult hit) {
        return 0.0f;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemStackHandler;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public ItemStack toStack() {
        if (this.field_70170_p.field_72995_K) {
            if (this.renderStackCache == null) {
                this.renderStackCache = this.genItem();
            }
            return this.renderStackCache;
        }
        return this.genItem();
    }

    private ItemStack genItem() {
        ItemStack stack = new ItemStack((Item)ItemReg.heldItemMissile);
        ICapabilityMissileStack capabilityMissileStack = (ICapabilityMissileStack)stack.getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null);
        if (capabilityMissileStack instanceof CapabilityHeldItemMissile) {
            ((CapabilityHeldItemMissile)capabilityMissileStack).setHeldItem(this.itemStackHandler.getStackInSlot(0));
            ((CapabilityHeldItemMissile)capabilityMissileStack).setActionMode(this.getActionMode());
        }
        return stack;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        SAVE_LOGIC.save(this, nbt);
    }

    @Override
    public void writeSpawnData(ByteBuf additionalMissileData) {
        super.writeSpawnData(additionalMissileData);
        NBTTagCompound saveData = SAVE_LOGIC.save(this, new NBTTagCompound());
        ByteBufUtils.writeTag((ByteBuf)additionalMissileData, (NBTTagCompound)saveData);
    }

    @Override
    public void readSpawnData(ByteBuf additionalMissileData) {
        super.readSpawnData(additionalMissileData);
        NBTTagCompound saveData = ByteBufUtils.readTag((ByteBuf)additionalMissileData);
        SAVE_LOGIC.load(this, saveData);
    }

    @Generated
    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    @Generated
    public HeldActionMode getActionMode() {
        return this.actionMode;
    }

    @Generated
    public void setActionMode(HeldActionMode actionMode) {
        this.actionMode = actionMode;
    }
}

