/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.flight;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.missiles.parts.IMissileFlightLogic;
import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.api.reg.obj.IBuilderRegistry;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.missile.entity.EntityMissile;
import icbm.classic.content.missile.entity.explosive.EntityExplosiveMissile;
import icbm.classic.content.missile.tracker.MissileTrackerHandler;
import icbm.classic.lib.buildable.BuildableObject;
import icbm.classic.lib.saving.NbtSaveHandler;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@Deprecated
public class BallisticFlightLogicOld
extends BuildableObject<BallisticFlightLogicOld, IBuilderRegistry<IMissileFlightLogic>>
implements IMissileFlightLogic {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "ballistic");
    public static final int PAD_WARM_UP_TIME = 40;
    public static final double MISSILE_CLIMB_HEIGHT = 2.0;
    public boolean hasStartedFlight = false;
    public double lockHeight = 0.0;
    private int missileFlightTime;
    private float acceleration;
    private int padWarmUpTimer = 40;
    private double climbHeight = 2.0;
    private double deltaPathX;
    private double deltaPathY;
    private double deltaPathZ;
    private double startX;
    private double startY;
    private double startZ;
    private double endX;
    private double endY;
    private double endZ;
    private boolean flightUpAlways = false;
    private int ticksFlight = 0;
    private boolean wasSimulationBlocked = false;
    private static final NbtSaveHandler<BallisticFlightLogicOld> SAVE_LOGIC = new NbtSaveHandler().addRoot("flags").nodeBoolean("flight_started", bl -> bl.hasStartedFlight, (bl, data) -> {
        bl.hasStartedFlight = data;
    }).nodeBoolean("block_simulation", bl -> bl.wasSimulationBlocked, (bl, data) -> {
        bl.wasSimulationBlocked = data;
    }).base().addRoot("inputs").nodeDouble("start_x", bl -> bl.startX, (bl, i) -> {
        bl.startX = i;
    }).nodeDouble("start_y", bl -> bl.startY, (bl, i) -> {
        bl.startY = i;
    }).nodeDouble("start_z", bl -> bl.startZ, (bl, i) -> {
        bl.startZ = i;
    }).nodeDouble("end_x", bl -> bl.endX, (bl, i) -> {
        bl.endX = i;
    }).nodeDouble("end_y", bl -> bl.endY, (bl, i) -> {
        bl.endY = i;
    }).nodeDouble("end_z", bl -> bl.endZ, (bl, i) -> {
        bl.endZ = i;
    }).base().addRoot("calculated").nodeInteger("flight_time", bl -> bl.missileFlightTime, (bl, data) -> {
        bl.missileFlightTime = data;
    }).nodeFloat("acceleration", bl -> Float.valueOf(bl.acceleration), (bl, data) -> {
        bl.acceleration = data.floatValue();
    }).nodeDouble("delta_x", bl -> bl.deltaPathX, (bl, data) -> {
        bl.deltaPathX = data;
    }).nodeDouble("delta_y", bl -> bl.deltaPathY, (bl, data) -> {
        bl.deltaPathY = data;
    }).nodeDouble("delta_z", bl -> bl.deltaPathZ, (bl, data) -> {
        bl.deltaPathZ = data;
    }).base().addRoot("timers").nodeInteger("engine_warm_up", bl -> bl.padWarmUpTimer, (bl, data) -> {
        bl.padWarmUpTimer = data;
    }).nodeDouble("climb_height", bl -> bl.climbHeight, (bl, data) -> {
        bl.climbHeight = data;
    }).nodeDouble("lock_height", bl -> bl.lockHeight, (bl, i) -> {
        bl.lockHeight = i;
    }).nodeInteger("flight", bl -> bl.ticksFlight, (bl, i) -> {
        bl.ticksFlight = i;
    }).base();

    public BallisticFlightLogicOld(int lockHeight) {
        this();
        this.lockHeight = lockHeight;
    }

    public BallisticFlightLogicOld() {
        super(REG_NAME, ICBMClassicAPI.MISSILE_FLIGHT_LOGIC_REGISTRY, SAVE_LOGIC);
    }

    @Override
    public void calculateFlightPath(World world, double startX, double startY, double startZ, IMissileTarget targetData) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        if (targetData != null) {
            this.endX = targetData.getX();
            this.endY = targetData.getY();
            this.endZ = targetData.getZ();
        }
    }

    protected void calculatePath() {
        this.deltaPathX = this.endX - this.startX;
        this.deltaPathY = this.endY - this.startY;
        this.deltaPathZ = this.endZ - this.startZ;
        float flatDistance = (float)Math.sqrt(this.deltaPathX * this.deltaPathX + this.deltaPathZ * this.deltaPathZ);
        if (flatDistance < 200.0f) {
            float ticksPerMeterFlat = 2.0f;
            float heightToDistanceScale = flatDistance > 1000.0f ? 3.0f : 1.0f;
            float maxHeight = 1000.0f;
            float initialArcHeight = flatDistance > 100.0f ? 160.0f : 0.0f;
            float arcHeightMax = Math.min(1000.0f, initialArcHeight + flatDistance * heightToDistanceScale);
            this.missileFlightTime = (int)Math.ceil(2.0f * flatDistance);
            double heightToDistance = arcHeightMax / flatDistance;
            double heightToTime = arcHeightMax / (float)this.missileFlightTime;
            double timeToDistance = (float)this.missileFlightTime / flatDistance;
            this.acceleration = (float)(((double)arcHeightMax - heightToDistance) * heightToDistance / ((double)this.missileFlightTime / timeToDistance) / (heightToTime * (double)flatDistance));
        } else {
            this.flightUpAlways = true;
        }
    }

    @Override
    public void onEntityTick(Entity entity, IMissile missile, int ticksInAir) {
        if (this.padWarmUpTimer > 0) {
            --this.padWarmUpTimer;
            this.idleMissileOnPad(entity, ticksInAir);
        } else if (this.climbHeight > 0.0) {
            this.doSlowClimb(entity, ticksInAir);
        } else if (this.lockHeight > 0.0) {
            this.handleLockHeight(entity, ticksInAir);
        } else if (!this.hasStartedFlight) {
            this.hasStartedFlight = true;
            this.startX = entity.field_70165_t;
            this.startY = entity.field_70163_u;
            this.startZ = entity.field_70161_v;
            this.calculatePath();
            if (!this.flightUpAlways) {
                entity.field_70181_x = this.acceleration * ((float)this.missileFlightTime / 2.0f);
                entity.field_70159_w = this.deltaPathX / (double)this.missileFlightTime;
                entity.field_70179_y = this.deltaPathZ / (double)this.missileFlightTime;
            } else {
                float flatDistance = (float)Math.sqrt(this.deltaPathX * this.deltaPathX + this.deltaPathZ * this.deltaPathZ);
                float hortSpeed = 0.05f;
                float vertSpeed = 2.0f;
                entity.field_70159_w = this.deltaPathX / (double)flatDistance * (double)0.05f;
                entity.field_70179_y = this.deltaPathZ / (double)flatDistance * (double)0.05f;
                entity.field_70181_x = 2.0;
            }
        } else {
            this.runFlightLogic(entity, ticksInAir);
        }
    }

    protected void runFlightLogic(Entity entity, int ticksInAir) {
        ++this.ticksFlight;
        if (!entity.field_70170_p.field_72995_K) {
            if (!this.flightUpAlways) {
                entity.field_70181_x -= (double)this.acceleration;
            }
            if (Math.abs(entity.field_70165_t - this.endX) <= (double)0.1f && Math.abs(entity.field_70161_v - this.endZ) <= (double)0.1f) {
                entity.field_70159_w = 0.0;
                entity.field_70179_y = 0.0;
            }
            this.alignWithMotion(entity);
            if (entity instanceof EntityExplosiveMissile && this.shouldSimulate(entity)) {
                this.wasSimulationBlocked = !MissileTrackerHandler.simulateMissile((EntityExplosiveMissile)entity);
            }
        }
    }

    @Override
    public boolean canSafelyExitLogic() {
        return this.hasStartedFlight;
    }

    protected void handleLockHeight(Entity entity, int ticksInAir) {
        entity.field_70181_x += (double)0.1f;
        entity.field_70159_w = 0.0;
        entity.field_70179_y = 0.0;
        this.lockHeight -= entity.field_70181_x;
    }

    protected void alignWithMotion(Entity entity) {
        entity.field_70125_A = (float)(Math.atan(entity.field_70181_x / Math.sqrt(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y)) * 180.0 / Math.PI);
        entity.field_70177_z = (float)(Math.atan2(entity.field_70159_w, entity.field_70179_y) * 180.0 / Math.PI);
    }

    protected void doSlowClimb(Entity entity, int ticksInAir) {
        entity.field_70181_x += (double)0.005f;
        this.lockHeight -= entity.field_70181_x;
        this.climbHeight -= entity.field_70181_x;
    }

    protected void idleMissileOnPad(Entity entity, int ticksInAir) {
        entity.field_70127_C = 90.0f;
        entity.field_70125_A = 90.0f;
        ICBMClassic.proxy.spawnPadSmoke(entity, this, ticksInAir);
    }

    @Override
    public boolean shouldRunEngineEffects(Entity entity) {
        return this.padWarmUpTimer <= 0;
    }

    protected boolean shouldSimulate(Entity entity) {
        if (this.wasSimulationBlocked || EntityMissile.hasPlayerRiding(entity)) {
            return false;
        }
        if (entity.field_70163_u >= (double)ConfigMissile.SIMULATION_EXIT_HEIGHT) {
            return true;
        }
        BlockPos futurePos = this.predictPosition(entity, BlockPos::new, 2);
        return !entity.field_70170_p.func_175707_a(entity.func_180425_c(), futurePos);
    }

    @Override
    public <V> V predictPosition(Entity entity, IMissileFlightLogic.VecBuilderFunc<V> builder, int ticks) {
        double x = entity.field_70165_t;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v;
        double motionY = entity.field_70181_x;
        while (ticks-- > 0) {
            x += entity.field_70159_w;
            y += (motionY -= (double)this.acceleration);
            z += entity.field_70179_y;
        }
        return builder.apply(x, y, z);
    }

    @Deprecated
    public int getPadWarmUpTimer() {
        return this.padWarmUpTimer;
    }

    @Override
    public boolean shouldDecreaseMotion(Entity entity) {
        return false;
    }
}

