/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.tracker;

import icbm.classic.content.missile.entity.explosive.EntityExplosiveMissile;
import icbm.classic.datafix.EntityMissileDataFixer;
import icbm.classic.lib.transform.vector.Pos;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MissileTrackerData {
    public int preLoadChunkTimer;
    public int ticksLeftToTarget;
    public Pos targetPos;
    public NBTTagCompound missileData;

    public MissileTrackerData(EntityExplosiveMissile missile) {
        this.targetPos = new Pos(missile.getMissileCapability().getTargetData().getPosition());
        this.missileData = new NBTTagCompound();
        missile.func_184198_c(this.missileData);
        this.missileData.func_82580_o("Pos");
    }

    public MissileTrackerData(NBTTagCompound tagCompound) {
        this.readFromNBT(tagCompound);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.ticksLeftToTarget = nbt.func_74762_e("ticks");
        this.targetPos = new Pos(nbt.func_74775_l("target"));
        this.missileData = nbt.func_74775_l("data");
        if (!this.missileData.func_74764_b("id")) {
            this.missileData.func_74778_a("id", "icbmclassic:missile");
            this.missileData = EntityMissileDataFixer.INSTANCE.func_188217_a(this.missileData);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("ticks", this.ticksLeftToTarget);
        nbt.func_74782_a("target", (NBTBase)this.targetPos.writeNBT(new NBTTagCompound()));
        nbt.func_74782_a("data", (NBTBase)this.missileData);
        return nbt;
    }
}

