/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.actions.status;

import icbm.classic.api.actions.status.ActionStatusTypes;
import icbm.classic.lib.actions.status.ImmutableStatus;
import icbm.classic.lib.saving.NbtSaveHandler;
import lombok.Generated;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.util.INBTSerializable;

public final class MissingFieldStatus
extends ImmutableStatus
implements INBTSerializable<NBTTagCompound> {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "missing.field");
    private String source;
    private String field;
    private static final NbtSaveHandler<MissingFieldStatus> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeString("source", MissingFieldStatus::getSource, MissingFieldStatus::setSource).nodeString("field", MissingFieldStatus::getField, MissingFieldStatus::setField).base();

    public MissingFieldStatus() {
        super(REG_NAME, ActionStatusTypes.BLOCKING, ActionStatusTypes.ERROR);
    }

    public MissingFieldStatus(ResourceLocation regName, String source, String field) {
        super(regName, ActionStatusTypes.BLOCKING, ActionStatusTypes.ERROR);
        this.source = source;
        this.field = field;
    }

    @Override
    public ITextComponent message() {
        if (this.textComponent == null) {
            this.textComponent = new TextComponentTranslation(this.translationKey, new Object[]{this.source, this.field});
        }
        return this.textComponent;
    }

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public MissingFieldStatus setSource(String source) {
        this.source = source;
        return this;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public MissingFieldStatus setField(String field) {
        this.field = field;
        return this;
    }

    @Generated
    public String getField() {
        return this.field;
    }
}

