/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.projectile;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.projectile.IProjectileData;
import icbm.classic.api.missiles.projectile.IProjectileDataRegistry;
import icbm.classic.api.missiles.projectile.IProjectileStack;
import icbm.classic.lib.buildable.BuildableObjectRegistry;
import icbm.classic.lib.projectile.CachedProjectileData;
import icbm.classic.lib.projectile.ProjectileItemConversion;
import icbm.classic.lib.projectile.vanilla.ArrowProjectileData;
import icbm.classic.lib.projectile.vanilla.EntitySpawnProjectileData;
import icbm.classic.lib.projectile.vanilla.ItemProjectileData;
import icbm.classic.lib.projectile.vanilla.SpectralArrowProjectileData;
import icbm.classic.lib.projectile.vanilla.TippedArrowProjectileData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ProjectileDataRegistry
extends BuildableObjectRegistry<IProjectileData>
implements IProjectileDataRegistry {
    private final Map<Item, List<ProjectileItemConversion>> itemConversions = new HashMap<Item, List<ProjectileItemConversion>>();

    public ProjectileDataRegistry() {
        super("PROJECTILE", "projectile");
    }

    @Override
    public void lock() {
        super.lock();
    }

    public void registerVanillaDefaults() {
        if (!this.isLocked()) {
            this.register(ItemProjectileData.NAME, ItemProjectileData::new);
            this.register(EntitySpawnProjectileData.NAME, EntitySpawnProjectileData::new);
            ArrowProjectileData arrowData = new ArrowProjectileData();
            this.register(ArrowProjectileData.NAME, () -> arrowData);
            this.registerItemStackConversation(new ItemStack(Items.field_151032_g), itemStack -> arrowData);
            SpectralArrowProjectileData spectralArrowData = new SpectralArrowProjectileData();
            this.register(SpectralArrowProjectileData.NAME, () -> spectralArrowData);
            this.registerItemStackConversation(new ItemStack(Items.field_185166_h), itemStack -> spectralArrowData);
            this.register(TippedArrowProjectileData.NAME, TippedArrowProjectileData::new);
            this.registerItemStackConversation(new ItemStack(Items.field_185167_i), itemStack -> new TippedArrowProjectileData().setArrowItem((ItemStack)itemStack));
            this.registerItemStackConversation(new ItemStack(Items.field_151126_ay), new CachedProjectileData(() -> new EntitySpawnProjectileData("minecraft:snowball")));
            this.registerItemStackConversation(new ItemStack(Items.field_151110_aK), new CachedProjectileData(() -> new EntitySpawnProjectileData("minecraft:egg")));
            this.registerItemStackConversation(new ItemStack(Items.field_151063_bx), itemStack -> {
                EntitySpawnProjectileData projectileData = new EntitySpawnProjectileData(ItemMonsterPlacer.func_190908_h((ItemStack)itemStack));
                if (itemStack.func_82837_s()) {
                    projectileData.setEntityDisplayTag(itemStack.func_82833_r());
                }
                if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_150297_b("EntityTag", 10)) {
                    projectileData.setEntityData(itemStack.func_77978_p().func_74775_l("EntityTag"));
                }
                return projectileData;
            });
        }
    }

    public IProjectileData find(ItemStack itemStack) {
        IProjectileStack data;
        if (this.itemConversions.containsKey(itemStack.func_77973_b())) {
            List<ProjectileItemConversion> possibleConversions = this.itemConversions.get(itemStack.func_77973_b());
            for (ProjectileItemConversion conversion : possibleConversions) {
                IProjectileData data2 = conversion.getBuilder().apply(itemStack);
                if (data2 == null) continue;
                return data2;
            }
        }
        if (itemStack.hasCapability(ICBMClassicAPI.PROJECTILE_STACK_CAPABILITY, null) && (data = (IProjectileStack)itemStack.getCapability(ICBMClassicAPI.PROJECTILE_STACK_CAPABILITY, null)) != null) {
            return data.getProjectileData();
        }
        return new ItemProjectileData().setItemStack(itemStack.func_77946_l());
    }

    @Override
    public void registerItemStackConversation(ItemStack itemStack, Function<ItemStack, IProjectileData> builder) {
        this.itemConversions.computeIfAbsent(itemStack.func_77973_b(), k -> new ArrayList());
        this.itemConversions.get(itemStack.func_77973_b()).add(new ProjectileItemConversion(itemStack, builder));
    }

    @Override
    public Entity spawnProjectile(ResourceLocation key, World world, double x, double y, double z, @Nullable Entity source, boolean allowItemPickup, @Nullable Consumer<Entity> preSpawnCallback) {
        return this.spawnProjectile((IProjectileData)this.getOrBuild(key), world, x, y, z, source, allowItemPickup, preSpawnCallback);
    }

    @Override
    public Entity spawnProjectile(ItemStack item, World world, double x, double y, double z, @Nullable Entity source, boolean allowItemPickup, @Nullable Consumer<Entity> preSpawnCallback) {
        return this.spawnProjectile(this.find(item), world, x, y, z, source, allowItemPickup, preSpawnCallback);
    }

    @Override
    public <E extends Entity> E spawnProjectile(IProjectileData<E> data, World world, double x, double y, double z, Entity source, boolean allowItemPickup, Consumer<E> preSpawnCallback) {
        if (data == null) {
            return null;
        }
        E entity = data.newEntity(world, allowItemPickup);
        if (entity == null) {
            return null;
        }
        entity.func_70107_b(x, y, z);
        if (preSpawnCallback != null) {
            preSpawnCallback.accept(entity);
        }
        if (world.func_72838_d(entity)) {
            data.onEntitySpawned(entity, source, EnumHand.MAIN_HAND);
            return entity;
        }
        return null;
    }
}

