/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.draw_bridge.block;

import info.u_team.draw_bridge.init.DrawBridgeCreativeTabs;
import info.u_team.draw_bridge.property.UnlistedPropertyItemStack;
import info.u_team.draw_bridge.tileentity.TileEntityDrawBridge;
import info.u_team.draw_bridge.util.BlockStateUtil;
import info.u_team.u_team_core.block.UBlockTileEntity;
import info.u_team.u_team_core.tileentity.UTileEntityProvider;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public class BlockDrawBridge
extends UBlockTileEntity {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final UnlistedPropertyItemStack ITEMSTACK = UnlistedPropertyItemStack.create("item");

    public BlockDrawBridge(String name) {
        super(name, Material.field_151573_f, DrawBridgeCreativeTabs.tab, new UTileEntityProvider(new ResourceLocation("drawbridge", name), TileEntityDrawBridge.class, new Object[0]));
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(1.5f);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block ourBlock, BlockPos neighborPos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityDrawBridge drawbridge = this.getDrawBridge((IBlockAccess)world, pos);
        if (drawbridge == null) {
            return;
        }
        drawbridge.neighborChanged();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.openContainer("drawbridge", 0, world, pos, player, true);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityDrawBridge drawbridge = this.getDrawBridge((IBlockAccess)world, pos);
        if (drawbridge == null) {
            return;
        }
        InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)drawbridge);
        world.func_175666_e(pos, (Block)this);
        super.func_180663_b(world, pos, state);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState renderState = this.getRenderBlockState(world, pos);
        if (renderState == null) {
            return 0;
        }
        return renderState.getLightOpacity(world, pos);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState renderState = this.getRenderBlockState(world, pos);
        if (renderState == null) {
            return 0;
        }
        return renderState.getLightValue(world, pos);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!(state instanceof IExtendedBlockState)) {
            return state;
        }
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        ItemStack stack = this.getRenderItemStack(world, pos);
        if (stack == ItemStack.field_190927_a) {
            return extendedState;
        }
        return extendedState.withProperty((IUnlistedProperty)ITEMSTACK, (Object)stack);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).add(new IUnlistedProperty[]{ITEMSTACK}).build();
    }

    public TileEntityDrawBridge getDrawBridge(IBlockAccess world, BlockPos pos) {
        Pair pair = this.isTileEntityFromProvider(world, pos);
        return (Boolean)pair.getLeft() != false ? (TileEntityDrawBridge)((Object)pair.getRight()) : null;
    }

    public ItemStack getRenderItemStack(IBlockAccess world, BlockPos pos) {
        TileEntityDrawBridge drawbridge = this.getDrawBridge(world, pos);
        if (drawbridge == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = drawbridge.getRenderSlot().func_70301_a(0);
        if (stack == null || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public IBlockState getRenderBlockState(IBlockAccess world, BlockPos pos) {
        return BlockStateUtil.getBlockState(this.getRenderItemStack(world, pos));
    }
}

