/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.draw_bridge.tileentity;

import info.u_team.draw_bridge.block.BlockDrawBridge;
import info.u_team.draw_bridge.init.DrawBridgeBlocks;
import info.u_team.draw_bridge.inventory.InventoryOneSlotImplemention;
import info.u_team.u_team_core.api.ISyncedContainerTileEntity;
import info.u_team.u_team_core.tileentity.UTileEntity;
import info.u_team.u_team_core.util.NonNullListUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDrawBridge
extends UTileEntity
implements ITickable,
IInventory,
ISyncedContainerTileEntity {
    private final NonNullList<ItemStack> itemstacks;
    private boolean powered;
    private int speed;
    private boolean needsrs = true;
    private int extended;
    private boolean[] ourBlocks = new boolean[10];
    private final InventoryOneSlotImplemention renderSlot;
    private int localSpeed;

    public TileEntityDrawBridge() {
        this.itemstacks = NonNullListUtil.withSize((int)10, (Object)ItemStack.field_190927_a);
        this.renderSlot = new InventoryOneSlotImplemention((TileEntity)this, 1);
    }

    public void neighborChanged() {
        boolean newPowered = this.field_145850_b.func_175640_z(this.field_174879_c);
        this.updatePoweredState(newPowered);
        HashSet<TileEntityDrawBridge> drawBridges = new HashSet<TileEntityDrawBridge>();
        this.collect(drawBridges, this, 0);
        boolean newPoweredState = drawBridges.stream().anyMatch(drawBridge -> this.field_145850_b.func_175640_z(drawBridge.field_174879_c)) | newPowered;
        drawBridges.stream().forEach(drawBridge -> drawBridge.updatePoweredState(newPoweredState));
    }

    private void updatePoweredState(boolean powered) {
        this.powered = this.needsrs ? powered : !powered;
    }

    private void collect(Set<TileEntityDrawBridge> tileEntites, TileEntityDrawBridge callerTileEntity, int depth) {
        if (depth >= 20) {
            return;
        }
        this.getNeighbors(callerTileEntity.field_174879_c).stream().forEach(neighbor -> {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(neighbor);
            if (!(tileEntity instanceof TileEntityDrawBridge)) {
                return;
            }
            TileEntityDrawBridge drawBridge = (TileEntityDrawBridge)tileEntity;
            if (tileEntites.add(drawBridge)) {
                drawBridge.collect(tileEntites, drawBridge, depth + 1);
            }
        });
    }

    private List<BlockPos> getNeighbors(BlockPos except) {
        return this.getPosExcept(this.field_174879_c, except).filter(pos -> this.field_145850_b.func_180495_p(pos).func_177230_c() == DrawBridgeBlocks.draw_bridge).collect(Collectors.toList());
    }

    private Stream<BlockPos> getPosExcept(BlockPos start, BlockPos except) {
        return Stream.of(EnumFacing.field_82609_l).map(arg_0 -> ((BlockPos)start).func_177972_a(arg_0)).filter(pos -> !pos.equals((Object)except));
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.localSpeed <= 1) {
            this.localSpeed = this.speed;
            if (this.powered && this.extended < 10) {
                if (this.localSpeed == 0) {
                    for (int i = this.extended; i < 10; ++i) {
                        this.extend();
                    }
                } else {
                    this.extend();
                }
                this.func_70296_d();
            } else if (!this.powered && this.extended > 0) {
                if (this.localSpeed == 0) {
                    for (int i = this.extended; i > 0; --i) {
                        this.retract();
                    }
                } else {
                    this.retract();
                }
                this.func_70296_d();
            }
        }
        --this.localSpeed;
    }

    private void extend() {
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockDrawBridge.FACING);
        this.trySetBlock(facing);
        ++this.extended;
    }

    private void trySetBlock(EnumFacing facing) {
        BlockPos newPos = this.field_174879_c.func_177967_a(facing, this.extended + 1);
        if (this.field_145850_b.func_175623_d(newPos) || this.field_145850_b.func_180495_p(newPos).func_177230_c() instanceof BlockLiquid) {
            ItemStack itemstack = this.func_70301_a(this.extended);
            Block block = Block.func_149634_a((Item)itemstack.func_77973_b());
            this.field_145850_b.func_180501_a(newPos, block.func_176203_a(itemstack.func_77960_j()), 2);
            this.func_70304_b(this.extended);
            this.ourBlocks[this.extended] = true;
        } else {
            this.ourBlocks[this.extended] = false;
        }
    }

    private void retract() {
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockDrawBridge.FACING);
        --this.extended;
        this.tryRemoveBlock(facing);
    }

    private void tryRemoveBlock(EnumFacing facing) {
        BlockPos newPos;
        if (this.ourBlocks[this.extended] && !this.field_145850_b.func_175623_d(newPos = this.field_174879_c.func_177967_a(facing, this.extended + 1))) {
            IBlockState state = this.field_145850_b.func_180495_p(newPos);
            Block block = state.func_177230_c();
            ItemStack stack = new ItemStack(block, 1, block.func_176201_c(state));
            this.func_70299_a(this.extended, stack);
            this.field_145850_b.func_180501_a(newPos, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }

    public void getChunkLoadServerSyncData(NBTTagCompound compound) {
        this.writeRenderSlot(compound);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleChunkLoadClientSyncData(NBTTagCompound compound) {
        this.readRenderSlot(compound);
    }

    public void getServerSyncContainerData(NBTTagCompound compound) {
        compound.func_74768_a("extended", this.extended);
        compound.func_74768_a("speed", this.speed);
        compound.func_74757_a("needsrs", this.needsrs);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleFromServerSyncContainerData(NBTTagCompound compound) {
        this.extended = compound.func_74762_e("extended");
        this.speed = compound.func_74762_e("speed");
        this.needsrs = compound.func_74767_n("needsrs");
    }

    @SideOnly(value=Side.CLIENT)
    public void getClientSyncContainerData(NBTTagCompound compound) {
        compound.func_74768_a("speed", this.speed);
        compound.func_74757_a("needsrs", this.needsrs);
    }

    public void handleFromClientSyncContainerData(NBTTagCompound compound) {
        this.speed = Math.min(100, compound.func_74762_e("speed"));
        this.needsrs = compound.func_74767_n("needsrs");
        this.neighborChanged();
    }

    public void forceRerendering() {
        this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public boolean isExtended() {
        return this.extended > 0;
    }

    public InventoryOneSlotImplemention getRenderSlot() {
        return this.renderSlot;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public boolean needsRedstone() {
        return this.needsrs;
    }

    public void setNeedsRedstone(boolean needsrs) {
        this.needsrs = needsrs;
    }

    public void readNBT(NBTTagCompound compound) {
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.itemstacks);
        this.powered = compound.func_74767_n("powered");
        this.extended = compound.func_74762_e("extended");
        this.speed = compound.func_74762_e("speed");
        this.needsrs = compound.func_74767_n("needsrs");
        NBTTagCompound ourBlocksTag = compound.func_74775_l("ourBlocks");
        for (int i = 0; i < this.ourBlocks.length; ++i) {
            this.ourBlocks[i] = ourBlocksTag.func_74764_b("" + i) ? ourBlocksTag.func_74767_n("" + i) : false;
        }
        this.readRenderSlot(compound);
    }

    public void writeNBT(NBTTagCompound compound) {
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.itemstacks);
        compound.func_74757_a("powered", this.powered);
        compound.func_74768_a("extended", this.extended);
        compound.func_74768_a("speed", this.speed);
        compound.func_74757_a("needsrs", this.needsrs);
        NBTTagCompound ourBlocksTag = new NBTTagCompound();
        for (int i = 0; i < this.ourBlocks.length; ++i) {
            ourBlocksTag.func_74757_a("" + i, this.ourBlocks[i]);
        }
        compound.func_74782_a("ourBlocks", (NBTBase)ourBlocksTag);
        this.writeRenderSlot(compound);
    }

    private void readRenderSlot(NBTTagCompound compound) {
        NBTTagCompound renderSlotTag = compound.func_74775_l("renderSlot");
        if (renderSlotTag != null && !renderSlotTag.func_82582_d()) {
            this.renderSlot.func_70299_a(0, new ItemStack(renderSlotTag));
        }
    }

    private void writeRenderSlot(NBTTagCompound compound) {
        NBTTagCompound renderSlotTag = new NBTTagCompound();
        this.renderSlot.func_70301_a(0).func_77955_b(renderSlotTag);
        compound.func_74782_a("renderSlot", (NBTBase)renderSlotTag);
    }

    public String func_70005_c_() {
        return "drawbridge";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.itemstacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.itemstacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.itemstacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.itemstacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.itemstacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.itemstacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.itemstacks.clear();
    }
}

