/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity.logic;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import pcl.opensecurity.common.items.ItemCooldownUpgrade;
import pcl.opensecurity.common.items.ItemDamageUpgrade;
import pcl.opensecurity.common.items.ItemEnergyUpgrade;
import pcl.opensecurity.common.items.ItemMovementUpgrade;

public class EnergyTurretStats {
    private float damage;
    private float energyFactor;
    private float movePerTick;
    private int cooldownTicks;

    public EnergyTurretStats() {
        this.loadDefaults();
    }

    private void loadDefaults() {
        this.damage = 5.0f;
        this.cooldownTicks = 1;
        this.energyFactor = 1.0f;
        this.movePerTick = 0.005f;
    }

    public void loadFromInventory(ItemStackHandler inventory) {
        this.loadDefaults();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            this.checkItem(stack.func_77973_b());
        }
    }

    private void checkItem(Item item) {
        if (item instanceof ItemDamageUpgrade) {
            this.damage *= 3.0f;
        }
        if (item instanceof ItemEnergyUpgrade) {
            this.energyFactor = (float)((double)this.energyFactor * 0.7);
        }
        if (item instanceof ItemMovementUpgrade) {
            this.movePerTick += 2.5f;
        }
        if (item instanceof ItemCooldownUpgrade) {
            this.cooldownTicks += 3;
        }
    }

    public float getDamage() {
        return this.damage;
    }

    public float getEnergyUsage() {
        return 2.0f * this.getDamage() * this.energyFactor;
    }

    public int getCooldown() {
        return this.cooldownTicks;
    }

    public float getMoveSpeed() {
        return this.movePerTick;
    }
}

