/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CauldronHelper {
    private static int LEVELS = 3;
    private static FluidStack WATER = new FluidStack(FluidRegistry.WATER, 1000);

    public static boolean isCauldron(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockCauldron;
    }

    public static boolean fillCauldron(IFluidHandler eTank, World world, BlockPos pos, boolean drainTank) {
        FluidStack fluidStack;
        IBlockState state;
        Block block;
        if (eTank != null && (block = (state = world.func_180495_p(pos)).func_177230_c()) instanceof BlockCauldron && block.func_180641_l(state, world, pos) == 0 && (fluidStack = eTank.drain(WATER, false)) != null && fluidStack.amount == 1000) {
            ((BlockCauldron)block).func_176590_a(world, pos, state, LEVELS);
            if (drainTank) {
                eTank.drain(fluidStack, true);
            }
            return true;
        }
        return false;
    }

    public static boolean drainCauldron(IFluidHandler eTank, World world, BlockPos pos, boolean fillTank) {
        IBlockState state;
        Block block;
        if (eTank != null && (block = (state = world.func_180495_p(pos)).func_177230_c()) instanceof BlockCauldron && block.func_180641_l(state, world, pos) == LEVELS && eTank.fill(WATER, false) == 1000) {
            ((BlockCauldron)block).func_176590_a(world, pos, state, 0);
            if (fillTank) {
                eTank.fill(WATER, true);
            }
            return true;
        }
        return false;
    }
}

