/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.programs;

import java.util.List;
import me.desht.pneumaticcraft.common.recipes.AssemblyRecipe;
import me.desht.pneumaticcraft.common.recipes.programs.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ProgramDrill
extends AssemblyProgram {
    @Override
    public AssemblyProgram.EnumMachine[] getRequiredMachines() {
        return new AssemblyProgram.EnumMachine[]{AssemblyProgram.EnumMachine.PLATFORM, AssemblyProgram.EnumMachine.IO_UNIT_EXPORT, AssemblyProgram.EnumMachine.IO_UNIT_IMPORT, AssemblyProgram.EnumMachine.DRILL};
    }

    @Override
    public boolean executeStep(TileEntityAssemblyController.AssemblySystem system) {
        boolean useAir = true;
        if (!system.getPlatform().getHeldStack().func_190926_b()) {
            if (this.canItemBeDrilled(system.getPlatform().getHeldStack())) {
                system.getDrill().goDrilling();
            } else if (system.getDrill().isIdle()) {
                useAir = system.getExportUnit().pickupItem(null);
            }
        } else {
            useAir = !system.getExportUnit().isIdle() ? system.getExportUnit().pickupItem(null) : system.getImportUnit().pickupItem(this.getRecipeList());
        }
        return useAir;
    }

    private boolean canItemBeDrilled(ItemStack item) {
        for (AssemblyRecipe recipe : this.getRecipeList()) {
            if (!ProgramDrill.isValidInput(recipe, item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public List<AssemblyRecipe> getRecipeList() {
        return AssemblyRecipe.drillRecipes;
    }

    @Override
    protected int getItemMeta() {
        return 0;
    }
}

