/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.item;

import cassiokf.industrialrenewal.entity.EntityTenderBase;
import cassiokf.industrialrenewal.entity.LocomotiveBase;
import cassiokf.industrialrenewal.handlers.CouplingHandler;
import cassiokf.industrialrenewal.item.ItemBase;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.enums.EnumCouplingType;
import cassiokf.industrialrenewal.util.interfaces.ICoupleCart;
import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.UUID;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;

public class ItemCartLinkable
extends ItemBase {
    static final UUID NULL_UUID = new UUID(0L, 0L);
    private static final Map<EntityPlayer, EntityMinecart> linkMap = new MapMaker().weakKeys().weakValues().makeMap();

    public ItemCartLinkable(String name, CreativeTabs tab) {
        super(name, tab);
    }

    public static void onPlayerUseLinkableItemOnCart(EntityPlayer player, EntityMinecart cart) {
        EntityMinecart last = linkMap.remove(player);
        if (last != null && last.func_70089_S()) {
            if (CouplingHandler.isConnected(cart, last)) {
                CouplingHandler.removeConnection(cart, last);
                Utils.sendChatMessage(player, "Carts Decoupled");
                return;
            }
            if (ItemCartLinkable.CoupleCarts(last, cart)) {
                Utils.sendChatMessage(player, "Carts Coupled");
                Utils.sendConsoleMessage("player " + player.getDisplayNameString() + " Connected " + last.func_70005_c_() + " to " + cart.func_70005_c_());
                return;
            }
            Utils.sendChatMessage(player, "Coupling Fail");
        } else {
            linkMap.put(player, cart);
            Utils.sendChatMessage(player, "Coupling Start");
        }
    }

    public static boolean CoupleCarts(EntityMinecart cart1, EntityMinecart cart2) {
        if (ItemCartLinkable.canCoupleCarts(cart1, cart2)) {
            ItemCartLinkable.setConnection(cart1, cart2);
            ItemCartLinkable.setConnection(cart2, cart1);
            return true;
        }
        return false;
    }

    private static void setConnection(EntityMinecart from, EntityMinecart to) {
        for (EnumCouplingType link : EnumCouplingType.VALUES) {
            if (!ItemCartLinkable.hasFreeConnectionIn(from, link)) continue;
            if (from instanceof EntityTenderBase && to instanceof LocomotiveBase) {
                ((LocomotiveBase)to).setTender((EntityTenderBase)from);
            }
            UUID id = to.getPersistentID();
            from.getEntityData().func_74772_a(link.tagMostSigBits, id.getMostSignificantBits());
            from.getEntityData().func_74772_a(link.tagLeastSigBits, id.getLeastSignificantBits());
            return;
        }
    }

    private static boolean canCoupleCarts(EntityMinecart cart1, EntityMinecart cart2) {
        if (cart1 == cart2 || ItemCartLinkable.thereIsNoConnectionLeft(cart1) && ItemCartLinkable.thereIsNoConnectionLeft(cart2) || CouplingHandler.isConnected(cart1, cart2)) {
            return false;
        }
        return cart1.func_70068_e((Entity)cart2) <= (double)ItemCartLinkable.getMaxCouplingDistance(cart1, cart2);
    }

    public static boolean thereIsNoConnectionLeft(EntityMinecart cart) {
        return !ItemCartLinkable.hasFreeConnectionIn(cart, EnumCouplingType.COUPLING_1) && !ItemCartLinkable.hasFreeConnectionIn(cart, EnumCouplingType.COUPLING_2);
    }

    public static boolean hasFreeConnectionIn(EntityMinecart cart, EnumCouplingType type) {
        UUID cartUUID = CouplingHandler.getConnection(cart, type);
        return cartUUID.equals(NULL_UUID);
    }

    private static float getMaxCouplingDistance(EntityMinecart cart1, EntityMinecart cart2) {
        float defaultDistance = 1.6f;
        float dist = 0.0f;
        dist = cart1 instanceof ICoupleCart ? (dist += ((ICoupleCart)cart1).getMaxCouplingDistance(cart2)) : (dist += defaultDistance);
        dist = cart2 instanceof ICoupleCart ? (dist += ((ICoupleCart)cart2).getMaxCouplingDistance(cart1)) : (dist += defaultDistance);
        return dist * dist;
    }
}

