/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.network;

import cassiokf.industrialrenewal.tileentity.redstone.TileEntityFuseBox;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketReturnFuseBox
implements IMessage {
    private BlockPos pos;
    private int dimension;
    private int playerID;
    private boolean messageValid;

    public PacketReturnFuseBox() {
        this.messageValid = false;
    }

    public PacketReturnFuseBox(BlockPos pos, int dimension, int playerID) {
        this.dimension = dimension;
        this.pos = pos;
        this.playerID = playerID;
        this.messageValid = true;
    }

    public PacketReturnFuseBox(TileEntityFuseBox te) {
        this(te.func_174877_v(), te.func_145831_w().field_73011_w.getDimension(), -1);
    }

    public PacketReturnFuseBox(TileEntityFuseBox te, int playerID) {
        this(te.func_174877_v(), te.func_145831_w().field_73011_w.getDimension(), playerID);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.dimension = buf.readInt();
            this.playerID = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            System.out.println(ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.dimension);
        buf.writeInt(this.playerID);
    }

    public static class Handler
    implements IMessageHandler<PacketReturnFuseBox, IMessage> {
        public IMessage onMessage(PacketReturnFuseBox message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.dimension);
            TileEntityFuseBox te = (TileEntityFuseBox)world.func_175625_s(message.pos);
            if (te != null) {
                if (message.playerID != -1) {
                    EntityPlayer player = (EntityPlayer)world.func_73045_a(message.playerID);
                    te.shockPlayer(player);
                }
                return null;
            }
            return null;
        }
    }
}

