/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.tubes;

import cassiokf.industrialrenewal.tileentity.tubes.TileEntityMultiBlocksTube;
import cassiokf.industrialrenewal.util.interfaces.ICompressedFluidCapability;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileEntityHighPressurePipe
extends TileEntityMultiBlocksTube<TileEntityHighPressurePipe>
implements ICompressedFluidCapability {
    public int maxOutput = 1000;
    private boolean inUse = false;

    @Override
    public void tick() {
        if (!this.field_145850_b.field_72995_K && this.isMaster()) {
            this.limitedOutPutMap.clear();
        }
    }

    @Override
    public boolean canAccept(EnumFacing face, BlockPos pos) {
        return true;
    }

    @Override
    public boolean canPipeConnect(EnumFacing face, BlockPos pos) {
        return false;
    }

    @Override
    public int passCompressedFluid(int amount, int y, boolean simulate) {
        if (!this.isMaster() && !this.isMasterInvalid()) {
            return ((TileEntityHighPressurePipe)this.getMaster()).passCompressedFluid(amount, y, simulate);
        }
        if (this.inUse) {
            return 0;
        }
        this.inUse = true;
        if (amount <= 0) {
            return 0;
        }
        int out = 0;
        Map<TileEntity, EnumFacing> mapPosSet = this.getMachineContainers();
        int quantity = this.getRealQuantity(mapPosSet);
        if (quantity > 0) {
            out = this.moveFluid(amount, y, simulate, mapPosSet);
            if (!simulate) {
                this.outPut += out;
            }
        }
        this.outPutCount = quantity;
        this.inUse = false;
        return out;
    }

    private int getRealQuantity(Map<TileEntity, EnumFacing> mapPosSet) {
        int out = 0;
        for (TileEntity te : mapPosSet.keySet()) {
            if (te != null && !te.func_145837_r()) {
                ++out;
                continue;
            }
            mapPosSet.remove(te);
        }
        return out;
    }

    public int moveFluid(int amount, int y, boolean simulate, Map<TileEntity, EnumFacing> mapPosSet) {
        int out = 0;
        int validOutputs = this.getMaxOutput(mapPosSet, amount, y);
        if (validOutputs == 0) {
            return 0;
        }
        int realMaxOutput = Math.min(amount / validOutputs, this.maxOutput);
        for (TileEntity te : mapPosSet.keySet()) {
            if (!(te instanceof ICompressedFluidCapability)) {
                return 0;
            }
            ICompressedFluidCapability tube = (ICompressedFluidCapability)te;
            EnumFacing face = mapPosSet.get(te).func_176734_d();
            if (!tube.canAccept(face, te.func_174877_v()) || (realMaxOutput = this.getLimitedValueForOutPut(realMaxOutput, this.maxOutput, te, simulate)) <= 0) continue;
            int fluid = tube.passCompressedFluid(realMaxOutput, y, simulate);
            out += fluid;
        }
        return out;
    }

    public int getMaxOutput(Map<TileEntity, EnumFacing> mapPosSet, int amount, int y) {
        int canAccept = 0;
        for (TileEntity te : mapPosSet.keySet()) {
            int fluid;
            EnumFacing face = mapPosSet.get(te).func_176734_d();
            if (!(te instanceof ICompressedFluidCapability) || !((ICompressedFluidCapability)te).canAccept(face, te.func_174877_v())) continue;
            int realMaxOutput = amount;
            if ((realMaxOutput = this.getLimitedValueForOutPut(realMaxOutput, this.maxOutput, te, true)) <= 0 || (fluid = ((ICompressedFluidCapability)te).passCompressedFluid(realMaxOutput, y, true)) <= 0) continue;
            ++canAccept;
        }
        return canAccept;
    }

    @Override
    public void checkForOutPuts() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockPos currentPos = this.field_174879_c.func_177972_a(face);
            TileEntity te = this.field_145850_b.func_175625_s(currentPos);
            if (!(te instanceof TileEntityHighPressurePipe) && te instanceof ICompressedFluidCapability && ((ICompressedFluidCapability)te).canAccept(face.func_176734_d(), currentPos)) {
                this.addMachine(te, face);
                continue;
            }
            this.removeMachine(te);
        }
    }

    @Override
    public boolean instanceOf(TileEntity te) {
        return te instanceof TileEntityHighPressurePipe;
    }
}

