/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.utils.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import info.openmods.calc.utils.DefaultMap;
import info.openmods.calc.utils.config.ConfigProperty;
import info.openmods.calc.utils.config.IStringReader;
import info.openmods.calc.utils.config.StringReader;
import info.openmods.calc.utils.reflection.FieldWrapper;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;

public class ConfigPropertyManager<T> {
    private final Class<? extends T> cls;
    private final Map<String, FieldAdapter<?>> fields;
    private static final DefaultMap<Class<?>, ConfigPropertyManager<?>> CACHE = new DefaultMap<Class<?>, ConfigPropertyManager<?>>(){

        @Override
        protected ConfigPropertyManager<?> create(Class<?> key) {
            return new ConfigPropertyManager(key);
        }
    };

    public ConfigPropertyManager(Class<? extends T> cls) {
        this.cls = cls;
        ImmutableMap.Builder fields = ImmutableMap.builder();
        for (Field f : cls.getFields()) {
            ConfigProperty ann = f.getAnnotation(ConfigProperty.class);
            if (ann == null) continue;
            String name = ann.name();
            if (name.isEmpty()) {
                name = f.getName();
            }
            FieldWrapper access = FieldWrapper.create(f);
            IStringReader<?> serializer = StringReader.get(f.getType());
            Preconditions.checkState((serializer != null ? 1 : 0) != 0, (String)"Can't find serializer for field %s", (Object)f);
            FieldAdapter adapter = new FieldAdapter(serializer, access);
            fields.put((Object)name, adapter);
        }
        this.fields = fields.build();
    }

    public Set<String> keys() {
        return this.fields.keySet();
    }

    private FieldAdapter<?> findField(String key) {
        FieldAdapter<?> fieldAdapter = this.fields.get(key);
        if (fieldAdapter == null) {
            throw new NoSuchPropertyException(String.format("Can't find key %s in class %s", key, this.cls));
        }
        return fieldAdapter;
    }

    public String get(T instance, String key) {
        return this.findField(key).get(instance);
    }

    public void set(T instance, String key, String value) {
        this.findField(key).set(instance, value);
    }

    public Object getRaw(T instance, String key) {
        return this.findField(key).getRaw(instance);
    }

    public void setRaw(T instance, String key, Object value) {
        this.findField(key).setRaw(instance, value);
    }

    public static <T> ConfigPropertyManager<T> getFor(Class<? extends T> cls) {
        return CACHE.getOrCreate(cls);
    }

    private static class FieldAdapter<T> {
        private final IStringReader<T> serializer;
        private final FieldWrapper<T> access;

        public FieldAdapter(IStringReader<T> serializer, FieldWrapper<T> access) {
            this.serializer = serializer;
            this.access = access;
        }

        public void set(Object instance, String value) {
            T converted = this.serializer.readFromString(value);
            this.access.set(instance, converted);
        }

        public String get(Object instance) {
            T value = this.access.get(instance);
            return String.valueOf(value);
        }

        public T getRaw(Object instance) {
            return this.access.get(instance);
        }

        public void setRaw(Object instance, Object value) {
            this.access.set(instance, this.access.getType().cast(value));
        }
    }

    public static class NoSuchPropertyException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NoSuchPropertyException(String message) {
            super(message);
        }
    }
}

