/*
 * Decompiled with CFR 0.152.
 */
package techguns.blocks.machines;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.api.machines.IMachineType;
import techguns.blocks.machines.BasicMachine;
import techguns.tileentities.MultiBlockMachineTileEntMaster;
import techguns.tileentities.MultiBlockMachineTileEntSlave;
import techguns.util.BlockUtils;

public class MultiBlockMachine<T extends Enum<T> & IMachineType>
extends BasicMachine<T> {
    public static final PropertyBool FORMED = PropertyBool.func_177716_a((String)"formed");
    public static final PropertyDirection MULTIBLOCK_DIRECTION = BlockHorizontal.field_185512_D;

    public MultiBlockMachine(String name, Class<T> clazz) {
        super(name, clazz);
        this.blockStateOverride = new BlockStateContainer.Builder((Block)this).add(new IProperty[]{this.MACHINE_TYPE}).add(new IProperty[]{FORMED}).add(new IProperty[]{MULTIBLOCK_DIRECTION}).build();
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FORMED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MULTIBLOCK_DIRECTION, (Comparable)EnumFacing.SOUTH));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)FORMED) != false ? 8 : 0) + ((IMachineType)((Object)((Enum)((Object)state.func_177229_b((IProperty)this.MACHINE_TYPE))))).getIndex();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FORMED, (Comparable)Boolean.valueOf(meta >= 8)).func_177226_a((IProperty)this.MACHINE_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[meta >= 8 ? meta - 8 : meta]));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        MultiBlockMachineTileEntMaster mastertile;
        IBlockState s = world.func_180495_p(pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof MultiBlockMachineTileEntMaster && (mastertile = (MultiBlockMachineTileEntMaster)tile).isFormed()) {
            EnumFacing dir = mastertile.getMultiblockDirection();
            s = s.func_177226_a((IProperty)MULTIBLOCK_DIRECTION, (Comparable)dir);
            return s;
        }
        return s.func_177226_a((IProperty)MULTIBLOCK_DIRECTION, (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)FORMED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        Enum t = (Enum)((Object)state.func_177229_b((IProperty)this.MACHINE_TYPE));
        return ((IMachineType)((Object)t)).getRenderType();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (((IMachineType)((Object)((Enum)((Object)state.func_177229_b((IProperty)this.MACHINE_TYPE))))).hideInCreative()) {
            return ItemStack.field_190927_a;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public boolean func_149730_j(IBlockState state) {
        return this.func_149686_d(state);
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        Block b = state.func_177230_c();
        if (b.getRegistryName() == null) {
            return false;
        }
        return this.func_149686_d(state);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile;
        if (((Boolean)blockState.func_177229_b((IProperty)FORMED)).booleanValue() && (tile = worldIn.func_175625_s(pos)) instanceof MultiBlockMachineTileEntSlave) {
            return ((MultiBlockMachineTileEntSlave)tile).getFormedCollisionBoundingBox();
        }
        return field_185505_j;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.func_180646_a(state, source, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemBlockModels() {
        for (int i = 0; i < ((Enum[])this.clazz.getEnumConstants()).length; ++i) {
            IBlockState state = this.func_176223_P().func_177226_a((IProperty)this.MACHINE_TYPE, (Comparable)((Object)((Enum[])this.clazz.getEnumConstants())[i]));
            ModelLoader.setCustomModelResourceLocation((Item)this.itemblock, (int)this.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), BlockUtils.getBlockStateVariantString(state)));
        }
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        boolean formed = (Boolean)state.func_177229_b((IProperty)FORMED);
        if (formed) {
            return BlockFaceShape.UNDEFINED;
        }
        return super.func_193383_a(worldIn, state, pos, face);
    }
}

