/*
 * Decompiled with CFR 0.152.
 */
package techguns.capabilities;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techguns.capabilities.TGSpawnerNPCDataCapProvider;
import techguns.entities.npcs.ITGSpawnerNPC;
import techguns.tileentities.TGSpawnerTileEnt;

public class TGSpawnerNPCData {
    protected BlockPos spawnerPos;

    public boolean hasSpawner() {
        return this.spawnerPos != null;
    }

    public BlockPos getSpawnerPos() {
        return this.spawnerPos;
    }

    public void setSpawnerPos(BlockPos spawnerPos) {
        this.spawnerPos = spawnerPos;
    }

    public static TGSpawnerNPCData get(ITGSpawnerNPC npc) {
        return npc.getCapability(TGSpawnerNPCDataCapProvider.TG_GENERICNPC_DATA);
    }

    public void tryRelink(World w, ITGSpawnerNPC npc) {
        TileEntity tile;
        if (this.hasSpawner() && (tile = w.func_175625_s(this.getSpawnerPos())) != null && tile instanceof TGSpawnerTileEnt) {
            ((TGSpawnerTileEnt)tile).relinkNPC(npc);
        }
    }

    public void saveToNBT(NBTTagCompound tags) {
        if (this.spawnerPos != null) {
            tags.func_74757_a("hasSpawner", true);
            tags.func_74768_a("spawnerX", this.spawnerPos.func_177958_n());
            tags.func_74768_a("spawnerY", this.spawnerPos.func_177956_o());
            tags.func_74768_a("spawnerZ", this.spawnerPos.func_177952_p());
        }
    }

    public void loadFromNBT(NBTTagCompound tags) {
        if (tags.func_74767_n("hasSpawner")) {
            int x = tags.func_74762_e("spawnerX");
            int y = tags.func_74762_e("spawnerY");
            int z = tags.func_74762_e("spawnerZ");
            this.spawnerPos = new BlockPos(x, y, z);
        }
    }
}

