/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.particle;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techguns.client.particle.ITGParticle;
import techguns.client.particle.TGParticleManager;
import techguns.client.particle.TGParticleSystem;
import techguns.client.particle.TGParticleSystemType;
import techguns.client.render.TGRenderHelper;
import techguns.util.MathUtil;

@SideOnly(value=Side.CLIENT)
public class TGParticle
extends Particle
implements ITGParticle {
    protected static final VertexFormat VERTEX_FORMAT = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181714_n).func_181721_a(DefaultVertexFormats.field_181716_p).func_181721_a(DefaultVertexFormats.field_181717_q).func_181721_a(DefaultVertexFormats.field_181718_r);
    int lifetime;
    float angle;
    float angleRate;
    float angleRateDamping;
    float size;
    float sizePrev;
    float sizeRate;
    float sizeRateDamping;
    float animationSpeed;
    double velX;
    double velY;
    double velZ;
    float velocityDamping;
    float velocityDampingOnGround;
    float systemVelocityFactor;
    TGParticleSystem particleSystem;
    TGParticleSystemType type;
    int variationFrame;
    protected double depth;
    protected boolean itemAttached = false;

    public TGParticle(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, TGParticleSystem particleSystem) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn);
        this.field_187129_i = xSpeedIn;
        this.field_187130_j = ySpeedIn;
        this.field_187131_k = zSpeedIn;
        this.particleSystem = particleSystem;
        this.type = particleSystem.type;
        this.init();
    }

    private void init() {
        this.field_70547_e = this.lifetime = MathUtil.randomInt(this.field_187136_p, this.type.lifetimeMin, this.type.lifetimeMax);
        this.size = MathUtil.randomFloat(this.field_187136_p, this.type.sizeMin, this.type.sizeMax) * this.particleSystem.scale;
        this.size += this.particleSystem.startSize;
        this.sizeRate = MathUtil.randomFloat(this.field_187136_p, this.type.sizeRateMin, this.type.sizeRateMax) * this.particleSystem.scale;
        this.sizeRateDamping = MathUtil.randomFloat(this.field_187136_p, this.type.sizeRateDampingMin, this.type.sizeRateDampingMax);
        this.animationSpeed = MathUtil.randomFloat(this.field_187136_p, this.type.animationSpeedMin, this.type.animationSpeedMax);
        this.velocityDamping = MathUtil.randomFloat(this.field_187136_p, this.type.velocityDampingMin, this.type.velocityDampingMax);
        this.systemVelocityFactor = MathUtil.randomFloat(this.field_187136_p, this.type.systemVelocityFactorMin, this.type.systemVelocityFactorMax);
        this.velocityDampingOnGround = MathUtil.randomFloat(this.field_187136_p, this.type.velocityDampingOnGroundMin, this.type.velocityDampingOnGroundMax);
        this.angle = MathUtil.randomFloat(this.field_187136_p, this.type.angleMin, this.type.angleMax);
        this.angleRate = MathUtil.randomFloat(this.field_187136_p, this.type.angleRateMin, this.type.angleRateMax);
        this.angleRateDamping = MathUtil.randomFloat(this.field_187136_p, this.type.angleRateDampingMin, this.type.angleRateDampingMax);
        this.field_187129_i += (double)this.systemVelocityFactor * this.particleSystem.motionX();
        this.field_187130_j += (double)this.systemVelocityFactor * this.particleSystem.motionY();
        this.field_187131_k += (double)this.systemVelocityFactor * this.particleSystem.motionZ();
        this.velX = this.field_187129_i;
        this.velY = this.field_187130_j;
        this.velZ = this.field_187131_k;
        this.variationFrame = this.field_187136_p.nextInt(this.type.frames);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.sizePrev = this.size;
        --this.lifetime;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
            return;
        }
        if (this.type.particlesStickToSystem) {
            if (this.particleSystem.entity != null) {
                if (!this.particleSystem.entity.func_70089_S()) {
                    this.func_187112_i();
                    return;
                }
                if (this.type.particlesMoveWithSystem && this.particleSystem.attachToHead && this.particleSystem.entity instanceof EntityLivingBase) {
                    EntityLivingBase ent = (EntityLivingBase)this.particleSystem.entity;
                    double p = (double)ent.field_70125_A * (Math.PI / 180);
                    double y = (double)ent.field_70759_as * (Math.PI / 180);
                    double prevP = (double)ent.field_70127_C * (Math.PI / 180);
                    double prevY = (double)ent.field_70758_at * (Math.PI / 180);
                    Vec3d offsetBase = this.particleSystem.entityOffset.func_178787_e(this.particleSystem.type.offset);
                    Vec3d offset = offsetBase.func_178789_a((float)(-p));
                    offset = offset.func_178785_b((float)(-y));
                    Vec3d offsetP = offsetBase.func_178789_a((float)(-prevP));
                    offsetP = offsetP.func_178785_b((float)(-prevY));
                    this.field_187123_c = this.particleSystem.entity.field_70169_q + offsetP.field_72450_a;
                    this.field_187124_d = this.particleSystem.entity.field_70167_r + (double)ent.func_70047_e() + offsetP.field_72448_b;
                    this.field_187125_e = this.particleSystem.entity.field_70166_s + offsetP.field_72449_c;
                    this.field_187126_f = this.particleSystem.entity.field_70165_t + offset.field_72450_a;
                    this.field_187127_g = this.particleSystem.entity.field_70163_u + (double)ent.func_70047_e() + offset.field_72448_b;
                    this.field_187128_h = this.particleSystem.entity.field_70161_v + offset.field_72449_c;
                } else {
                    this.field_187123_c = this.particleSystem.entity.field_70169_q;
                    this.field_187124_d = this.particleSystem.entity.field_70167_r;
                    this.field_187125_e = this.particleSystem.entity.field_70166_s;
                    this.field_187126_f = this.particleSystem.entity.field_70165_t;
                    this.field_187127_g = this.particleSystem.entity.field_70163_u;
                    this.field_187128_h = this.particleSystem.entity.field_70161_v;
                }
            } else {
                if (!this.particleSystem.func_187113_k()) {
                    this.func_187112_i();
                    return;
                }
                this.field_187126_f = this.particleSystem.posX();
                this.field_187127_g = this.particleSystem.posY();
                this.field_187128_h = this.particleSystem.posZ();
            }
        } else if (this.type.particlesMoveWithSystem) {
            double dP = (double)(this.particleSystem.rotationPitch - this.particleSystem.prevRotationPitch) * (Math.PI / 180);
            double dY = (double)(this.particleSystem.rotationYaw - this.particleSystem.prevRotationYaw) * (Math.PI / 180);
            Vec3d pos = new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h);
            Vec3d sysPos = new Vec3d(this.particleSystem.posX(), this.particleSystem.posY(), this.particleSystem.posZ());
            Vec3d offset = sysPos.func_178788_d(pos);
            offset = offset.func_178785_b((float)(-dY));
            offset = offset.func_178789_a((float)(-dP));
            Vec3d motion = new Vec3d(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            motion = motion.func_178785_b((float)(-dY));
            motion = motion.func_178789_a((float)(-dP));
            this.field_187126_f = sysPos.field_72450_a + offset.field_72450_a;
            this.field_187127_g = sysPos.field_72448_b + offset.field_72448_b;
            this.field_187128_h = sysPos.field_72449_c + offset.field_72449_c;
            this.field_187129_i = motion.field_72450_a;
            this.field_187130_j = motion.field_72448_b;
            this.field_187131_k = motion.field_72449_c;
        }
        this.field_187129_i = this.velX;
        this.field_187130_j = this.velY;
        this.field_187131_k = this.velZ;
        this.field_187130_j -= (double)this.type.gravity;
        this.func_187109_b(this.field_187126_f + this.field_187129_i, this.field_187127_g + this.field_187130_j, this.field_187128_h + this.field_187131_k);
        this.velX *= (double)this.velocityDamping;
        this.velY *= (double)this.velocityDamping;
        this.velZ *= (double)this.velocityDamping;
        if (this.field_187132_l) {
            this.velX *= (double)this.velocityDampingOnGround;
            this.velY *= (double)this.velocityDampingOnGround;
            this.velZ *= (double)this.velocityDampingOnGround;
            if (this.type.removeOnGround) {
                this.func_187112_i();
            }
        }
        this.size = Math.max(0.0f, this.size + this.sizeRate);
        this.sizeRate *= this.sizeRateDamping;
        this.angle = (this.angle + this.angleRate) % 360.0f;
        this.angleRate *= this.angleRateDamping;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTickTime, float rotX, float rotZ, float rotYZ, float rotXY, float rotXZ) {
        Vec3d p4;
        Vec3d p3;
        Vec3d p2;
        Vec3d p1;
        float progress = ((float)this.field_70546_d + partialTickTime) / (float)this.field_70547_e;
        this.preRenderStep(progress);
        int currentFrame = 0;
        currentFrame = this.type.hasVariations ? this.variationFrame : (int)((float)this.type.frames * (progress * this.animationSpeed)) % this.type.frames;
        this.field_70544_f = this.sizePrev + (this.size - this.sizePrev) * partialTickTime;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.type.texture);
        float fscale = 0.1f * this.field_70544_f;
        float fPosX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTickTime - (!this.itemAttached ? TGParticleManager.interpPosX : 0.0));
        float fPosY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTickTime - (!this.itemAttached ? TGParticleManager.interpPosY : 0.0));
        float fPosZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTickTime - (!this.itemAttached ? TGParticleManager.interpPosZ : 0.0));
        float r = fscale;
        int col = currentFrame % this.type.columns;
        int row = currentFrame / this.type.columns;
        float u = 1.0f / (float)this.type.columns;
        float v = 1.0f / (float)this.type.columns;
        float U1 = (float)col * u;
        float V1 = (float)row * v;
        float U2 = (float)(col + 1) * u;
        float V2 = (float)(row + 1) * v;
        float ua = U2;
        float va = V2;
        float ub = U2;
        float vb = V1;
        float uc = U1;
        float vc = V1;
        float ud = U1;
        float vd = V2;
        this.enableBlendMode();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.func_181668_a(7, VERTEX_FORMAT);
        double a = (double)(this.angle + partialTickTime * this.angleRate) * (Math.PI / 180);
        if (this.type.groundAligned) {
            float s = fscale;
            p1 = new Vec3d((double)(-s), 0.0, (double)(-s));
            p2 = new Vec3d((double)s, 0.0, (double)(-s));
            p3 = new Vec3d((double)s, 0.0, (double)s);
            p4 = new Vec3d((double)(-s), 0.0, (double)s);
            if (a > (double)1.0E-4f) {
                p1 = p1.func_178785_b((float)a);
                p2 = p2.func_178785_b((float)a);
                p3 = p3.func_178785_b((float)a);
                p4 = p4.func_178785_b((float)a);
            }
        } else {
            p1 = new Vec3d((double)(-rotX * fscale - rotXY * fscale), (double)(-rotZ * fscale), (double)(-rotYZ * fscale - rotXZ * fscale));
            p2 = new Vec3d((double)(-rotX * fscale + rotXY * fscale), (double)(rotZ * fscale), (double)(-rotYZ * fscale + rotXZ * fscale));
            p3 = new Vec3d((double)(rotX * fscale + rotXY * fscale), (double)(rotZ * fscale), (double)(rotYZ * fscale + rotXZ * fscale));
            p4 = new Vec3d((double)(rotX * fscale - rotXY * fscale), (double)(-rotZ * fscale), (double)(rotYZ * fscale - rotXZ * fscale));
            if (a > (double)1.0E-4f) {
                Vec3d axis = p1.func_72432_b().func_72431_c(p2.func_72432_b());
                double cosa = Math.cos(a);
                double sina = Math.sin(a);
                p1 = this.rotAxis(p1, axis, sina, cosa);
                p2 = this.rotAxis(p2, axis, sina, cosa);
                p3 = this.rotAxis(p3, axis, sina, cosa);
                p4 = this.rotAxis(p4, axis, sina, cosa);
            }
        }
        buffer.func_181662_b(p1.field_72450_a + (double)fPosX, p1.field_72448_b + (double)fPosY, p1.field_72449_c + (double)fPosZ).func_187315_a((double)ua, (double)va).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(0, 240).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_181662_b(p2.field_72450_a + (double)fPosX, p2.field_72448_b + (double)fPosY, p2.field_72449_c + (double)fPosZ).func_187315_a((double)ub, (double)vb).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(0, 240).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_181662_b(p3.field_72450_a + (double)fPosX, p3.field_72448_b + (double)fPosY, p3.field_72449_c + (double)fPosZ).func_187315_a((double)uc, (double)vc).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(0, 240).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_181662_b(p4.field_72450_a + (double)fPosX, p4.field_72448_b + (double)fPosY, p4.field_72449_c + (double)fPosZ).func_187315_a((double)ud, (double)vd).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(0, 240).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        this.disableBlendMode();
    }

    protected void preRenderStep(float progress) {
        TGParticleSystemType.ColorEntry c1 = null;
        TGParticleSystemType.ColorEntry c2 = null;
        if (this.type.colorEntries.size() == 0) {
            c2 = c1 = new TGParticleSystemType.ColorEntry(1.0f, 1.0f, 1.0f, 0.0f);
        } else if (this.type.colorEntries.size() == 1) {
            c2 = c1 = this.type.colorEntries.get(0);
        } else {
            c1 = this.type.colorEntries.get(0);
            for (int i = 1; i < this.type.colorEntries.size(); ++i) {
                c2 = this.type.colorEntries.get(i);
                if (progress < c2.time) break;
                c1 = c2;
            }
        }
        float p = (progress - c1.time) / (c2.time - c1.time);
        if (c1 != c2) {
            float[] hsb1 = Color.RGBtoHSB((int)(c1.r * 255.0f), (int)(c1.g * 255.0f), (int)(c1.b * 255.0f), null);
            float[] hsb2 = Color.RGBtoHSB((int)(c2.r * 255.0f), (int)(c2.g * 255.0f), (int)(c2.b * 255.0f), null);
            Color color = new Color(Color.HSBtoRGB(hsb1[0] * (1.0f - p) + hsb2[0] * p, hsb1[1] * (1.0f - p) + hsb2[1] * p, hsb1[2] * (1.0f - p) + hsb2[2] * p));
            this.field_70552_h = (float)color.getRed() / 255.0f;
            this.field_70553_i = (float)color.getGreen() / 255.0f;
            this.field_70551_j = (float)color.getBlue() / 255.0f;
        } else {
            this.field_70552_h = c1.r;
            this.field_70553_i = c1.g;
            this.field_70551_j = c1.b;
        }
        TGParticleSystemType.AlphaEntry a1 = null;
        TGParticleSystemType.AlphaEntry a2 = null;
        if (this.type.alphaEntries.size() == 0) {
            this.field_82339_as = 1.0f;
        } else if (this.type.alphaEntries.size() == 1) {
            a1 = this.type.alphaEntries.get(0);
            this.field_82339_as = a1.alpha;
        } else {
            a1 = this.type.alphaEntries.get(0);
            for (int i = 1; i < this.type.alphaEntries.size(); ++i) {
                a2 = this.type.alphaEntries.get(i);
                if (progress < a2.time) break;
                a1 = a2;
            }
            if (a1.time != a2.time) {
                p = (progress - a1.time) / (a2.time - a1.time);
                this.field_82339_as = a1.alpha * (1.0f - p) + a2.alpha * p;
            } else {
                this.field_82339_as = a1.alpha;
            }
        }
    }

    public int func_189214_a(float p_189214_1_) {
        return 61680;
    }

    protected void enableBlendMode() {
        if (this.type.renderType != TGRenderHelper.RenderType.SOLID) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179132_a((boolean)false);
        }
        if (this.type.renderType == TGRenderHelper.RenderType.ALPHA) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        } else if (this.type.renderType == TGRenderHelper.RenderType.ADDITIVE || this.type.renderType == TGRenderHelper.RenderType.NO_Z_TEST) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }
        if (this.type.renderType == TGRenderHelper.RenderType.NO_Z_TEST) {
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
        }
        if (this.type.renderType != TGRenderHelper.RenderType.ALPHA_SHADED) {
            TGRenderHelper.enableFXLighting();
        }
    }

    protected void disableBlendMode() {
        if (this.type.renderType != TGRenderHelper.RenderType.ALPHA_SHADED) {
            TGRenderHelper.disableFXLighting();
        }
        if (this.type.renderType != TGRenderHelper.RenderType.SOLID) {
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        }
        if (this.type.renderType == TGRenderHelper.RenderType.ALPHA) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        } else if (this.type.renderType == TGRenderHelper.RenderType.ADDITIVE || this.type.renderType == TGRenderHelper.RenderType.NO_Z_TEST) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        if (this.type.renderType == TGRenderHelper.RenderType.NO_Z_TEST) {
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
        }
    }

    public int func_70537_b() {
        return 3;
    }

    public double posX() {
        return this.field_187126_f;
    }

    public double posY() {
        return this.field_187127_g;
    }

    public double posZ() {
        return this.field_187128_h;
    }

    protected Vec3d rotAxis(Vec3d p1, Vec3d axis, double sina, double cosa) {
        Vec3d v1 = axis.func_72431_c(p1);
        double d1 = axis.func_72430_b(p1);
        return p1.func_186678_a(cosa).func_178787_e(v1.func_186678_a(sina)).func_178787_e(axis.func_186678_a(d1 * (1.0 - cosa)));
    }

    @Override
    public Vec3d getPos() {
        return new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    @Override
    public boolean shouldRemove() {
        return !this.func_187113_k();
    }

    @Override
    public void updateTick() {
        this.func_189213_a();
    }

    @Override
    public void doRender(BufferBuilder buffer, Entity entityIn, float partialTickTime, float rotX, float rotZ, float rotYZ, float rotXY, float rotXZ) {
        this.func_180434_a(buffer, entityIn, partialTickTime, rotX, rotZ, rotYZ, rotXY, rotXZ);
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox(float partialTickTime, Entity viewEnt) {
        double fPosX = this.field_187126_f - viewEnt.field_70165_t;
        double fPosY = this.field_187127_g - viewEnt.field_70163_u;
        double fPosZ = this.field_187128_h - viewEnt.field_70161_v;
        double s = (double)this.size * 0.5;
        return new AxisAlignedBB(fPosX - s, fPosY - s, fPosZ - s, fPosX + s, fPosY + s, fPosZ + s);
    }

    @Override
    public double getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(double depth) {
        this.depth = depth;
    }

    private Vec3d setupViewBobbing(float ptt) {
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
            float f1 = entityplayer.field_70140_Q - entityplayer.field_70141_P;
            float f2 = -(entityplayer.field_70140_Q + f1 * ptt);
            float f3 = entityplayer.field_71107_bF + (entityplayer.field_71109_bG - entityplayer.field_71107_bF) * ptt;
            float f4 = entityplayer.field_70727_aS + (entityplayer.field_70726_aT - entityplayer.field_70727_aS) * ptt;
            float F1 = 1.0f;
            float F2 = 1.0f;
            Vec3d vec = new Vec3d((double)(MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 0.5f * F1), (double)(-Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI)) * f3) * F2), 0.0);
            vec = MathUtil.rotateVec3dAroundZ(vec, MathHelper.func_76126_a((float)(f2 * (float)Math.PI)) * f3 * 3.0f * ((float)Math.PI / 180));
            return vec.func_178789_a(Math.abs(MathHelper.func_76134_b((float)(f2 * (float)Math.PI - 0.2f)) * f3) * 5.0f * ((float)Math.PI / 180)).func_178789_a(f4 * ((float)Math.PI / 180));
        }
        return new Vec3d(0.0, 0.0, 0.0);
    }

    @Override
    public void setItemAttached() {
        this.itemAttached = true;
    }

    public void func_187112_i() {
        super.func_187112_i();
        this.particleSystem = null;
    }
}

