/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.particle;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import techguns.client.particle.TGFXType;
import techguns.client.particle.TGParticle;
import techguns.client.particle.TGParticleSystem;
import techguns.client.particle.TGParticleSystemItemAttached;
import techguns.client.render.TGRenderHelper;
import techguns.util.MathUtil;

public class TGParticleSystemType
extends TGFXType {
    TGRenderHelper.RenderType renderType = TGRenderHelper.RenderType.SOLID;
    ResourceLocation texture = new ResourceLocation("techguns:textures/fx/fireball.png");
    int rows = 1;
    int columns = 1;
    int frames = 1;
    boolean hasVariations = false;
    boolean streak = false;
    float angleMin = 0.0f;
    float angleMax = 0.0f;
    float angleRateMin = 0.0f;
    float angleRateMax = 0.0f;
    float angleRateDampingMin = 0.0f;
    float angleRateDampingMax = 0.0f;
    int lifetimeMin = 20;
    int lifetimeMax = 20;
    int initialDelayMin = 0;
    int initialDelayMax = 0;
    float animationSpeedMin = 1.0f;
    float animationSpeedMax = 1.0f;
    float sizeMin = 1.0f;
    float sizeMax = 1.0f;
    float sizeRateMin = 1.0f;
    float sizeRateMax = 1.0f;
    float sizeRateDampingMin = 1.0f;
    float sizeRateDampingMax = 1.0f;
    float startSizeRateMin = 0.0f;
    float startSizeRateMax = 0.0f;
    float startSizeRateDampingMin = 1.0f;
    float startSizeRateDampingMax = 1.0f;
    List<ColorEntry> colorEntries = new ArrayList<ColorEntry>();
    List<AlphaEntry> alphaEntries = new ArrayList<AlphaEntry>();
    int particleCountMin = 1;
    int particleCountMax = 1;
    int spawnDelayMin = 1;
    int spawnDelayMax = 1;
    int systemLifetimeMin = 5;
    int systemLifetimeMax = 5;
    IVelocityType velocityType = VEL_NONE;
    float[] velocityDataMin = new float[3];
    float[] velocityDataMax = new float[3];
    float velocityDampingMin = 1.0f;
    float velocityDampingMax = 1.0f;
    float velocityDampingOnGroundMin = 1.0f;
    float velocityDampingOnGroundMax = 1.0f;
    float gravity = 0.0f;
    float systemVelocityFactorMin = 0.0f;
    float systemVelocityFactorMax = 0.0f;
    Vec3d offset = new Vec3d(0.0, 0.0, 0.0);
    IVolumeType volumeType = VOL_POINT;
    float[] volumeData = new float[3];
    boolean isHollow;
    boolean removeOnGround = false;
    boolean particlesMoveWithSystem = false;
    boolean groundAligned = false;
    String attachedSystem = null;
    boolean particlesStickToSystem = false;
    public static IVelocityType VEL_NONE = new IVelocityType(){

        @Override
        public Vec3d getVelocity(TGParticleSystem sys, float ... params) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
    };
    public static IVelocityType VEL_ORTHO = new IVelocityType(){

        @Override
        public Vec3d getVelocity(TGParticleSystem sys, float ... params) {
            Random rand = new Random();
            if (sys.type.velocityDataMin.length >= 3) {
                float x = MathUtil.randomFloat(rand, sys.type.velocityDataMin[0], sys.type.velocityDataMax[0]);
                float y = MathUtil.randomFloat(rand, sys.type.velocityDataMin[1], sys.type.velocityDataMax[1]);
                float z = MathUtil.randomFloat(rand, sys.type.velocityDataMin[2], sys.type.velocityDataMax[2]);
                return new Vec3d((double)x, (double)y, (double)z);
            }
            return new Vec3d(0.0, 0.0, 0.0);
        }
    };
    public static IVelocityType VEL_OUTWARD = new IVelocityType(){

        @Override
        public Vec3d getVelocity(TGParticleSystem sys, float ... params) {
            Random rand = new Random();
            if (sys.type.velocityDataMin.length >= 2) {
                float r = MathUtil.randomFloat(rand, sys.type.velocityDataMin[0], sys.type.velocityDataMax[0]);
                float y = MathUtil.randomFloat(rand, sys.type.velocityDataMin[1], sys.type.velocityDataMax[1]);
                if (params.length == 1) {
                    double angle = -params[0];
                    return new Vec3d((double)r * Math.cos(angle), (double)y, (double)r * Math.sin(angle));
                }
                if (params.length == 3) {
                    return new Vec3d((double)(params[0] * r), (double)(params[1] * r), (double)(params[2] * r));
                }
                double angle = rand.nextDouble() * 2.0 * Math.PI;
                return new Vec3d((double)r * Math.cos(angle), (double)y, (double)r * Math.sin(angle));
            }
            return new Vec3d(0.0, 0.0, 0.0);
        }
    };
    public static IVelocityType VEL_SPHERICAL = new IVelocityType(){

        @Override
        public Vec3d getVelocity(TGParticleSystem sys, float ... params) {
            Random rand = new Random();
            if (sys.type.velocityDataMin.length >= 1) {
                float r = MathUtil.randomFloat(rand, sys.type.velocityDataMin[0], sys.type.velocityDataMax[0]);
                double angle = rand.nextDouble() * 2.0 * Math.PI;
                double y = 1.0 - rand.nextDouble() * 2.0;
                double a = Math.sqrt(1.0 - Math.pow(y, 2.0));
                return new Vec3d((double)r * a * Math.cos(angle), (double)r * y, (double)r * a * Math.sin(angle));
            }
            return new Vec3d(0.0, 0.0, 0.0);
        }
    };
    public static IVelocityType VEL_HEMISPHERICAL = new IVelocityType(){

        @Override
        public Vec3d getVelocity(TGParticleSystem sys, float ... params) {
            Random rand = new Random();
            if (sys.type.velocityDataMin.length >= 1) {
                float r = MathUtil.randomFloat(rand, sys.type.velocityDataMin[0], sys.type.velocityDataMax[0]);
                double angle = rand.nextDouble() * 2.0 * Math.PI;
                double y = rand.nextDouble();
                double a = Math.sqrt(1.0 - Math.pow(y, 2.0));
                return new Vec3d((double)r * a * Math.cos(angle), (double)r * a * Math.sin(angle), (double)r * y);
            }
            return new Vec3d(0.0, 0.0, 0.0);
        }
    };
    public static IVolumeType VOL_POINT = new IVolumeType(){

        @Override
        public Vec3d getPosition(TGParticleSystem sys, DirResult dir, int i, int count) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
    };
    public static IVolumeType VOL_CYLINDER = new IVolumeType(){

        @Override
        public Vec3d getPosition(TGParticleSystem sys, DirResult dir, int i, int count) {
            Random rand = new Random();
            if (sys.type.volumeData.length >= 2) {
                float angle = rand.nextFloat() * (float)Math.PI * 2.0f;
                float r = sys.type.isHollow ? sys.type.volumeData[0] : MathUtil.randomFloat(rand, 0.0f, sys.type.volumeData[0]);
                float y = rand.nextFloat() * sys.type.volumeData[1];
                Vec3d direction = new Vec3d(1.0, 0.0, 0.0).func_178785_b(angle);
                dir.setValues(angle);
                Vec3d position = new Vec3d(direction.field_72450_a * (double)r, (double)y, direction.field_72449_c * (double)r);
                return position;
            }
            return new Vec3d(0.0, 0.0, 0.0);
        }
    };
    public static IVolumeType VOL_CYLINDER2 = new IVolumeType(){

        @Override
        public Vec3d getPosition(TGParticleSystem sys, DirResult dir, int i, int count) {
            Random rand = new Random();
            if (sys.type.volumeData.length >= 2) {
                float angle = rand.nextFloat() * (float)Math.PI * 2.0f;
                float r = sys.type.isHollow ? sys.type.volumeData[0] : MathUtil.randomFloat(rand, 0.0f, sys.type.volumeData[0]);
                float z = rand.nextFloat() * sys.type.volumeData[1];
                Vec3d direction = new Vec3d(0.0, 1.0, 0.0).func_178789_a(angle);
                dir.setValues((float)direction.field_72450_a, (float)direction.field_72448_b, (float)direction.field_72449_c);
                return new Vec3d(direction.field_72450_a * (double)r, direction.field_72448_b * (double)r, (double)z);
            }
            return new Vec3d(0.0, 0.0, 0.0);
        }
    };
    public static IVolumeType VOL_SPHERE = new IVolumeType(){

        @Override
        public Vec3d getPosition(TGParticleSystem sys, DirResult dir, int i, int count) {
            Random rand = new Random();
            if (sys.type.volumeData.length >= 1) {
                double angle = rand.nextDouble() * 2.0 * Math.PI;
                double y = 1.0 - rand.nextDouble() * 2.0;
                double a = Math.sqrt(1.0 - Math.pow(y, 2.0));
                float r = sys.type.isHollow ? sys.type.volumeData[0] : MathUtil.randomFloat(rand, 0.0f, sys.type.volumeData[0]);
                Vec3d direction = new Vec3d(a * Math.cos(angle), y, a * Math.sin(angle));
                dir.setValues((float)direction.field_72450_a, (float)direction.field_72448_b, (float)direction.field_72449_c);
                return new Vec3d(direction.field_72450_a * (double)r, direction.field_72448_b * (double)r, direction.field_72449_c * (double)r);
            }
            return new Vec3d(0.0, 0.0, 0.0);
        }
    };
    public static IVolumeType VOL_HEMISPHERE = new IVolumeType(){

        @Override
        public Vec3d getPosition(TGParticleSystem sys, DirResult dir, int i, int count) {
            Random rand = new Random();
            if (sys.type.volumeData.length >= 1) {
                double angle = rand.nextDouble() * 2.0 * Math.PI;
                double y = rand.nextDouble();
                double a = Math.sqrt(1.0 - Math.pow(y, 2.0));
                float r = sys.type.isHollow ? sys.type.volumeData[0] : MathUtil.randomFloat(rand, 0.0f, sys.type.volumeData[0]);
                Vec3d direction = new Vec3d(a * Math.cos(angle), y, a * Math.sin(angle));
                dir.setValues((float)direction.field_72450_a, (float)direction.field_72448_b, (float)direction.field_72449_c);
                return new Vec3d(direction.field_72450_a * (double)r, direction.field_72448_b * (double)r, direction.field_72449_c * (double)r);
            }
            return new Vec3d(0.0, 0.0, 0.0);
        }
    };
    public static IVolumeType VOL_TRAIL = new IVolumeType(){

        @Override
        public Vec3d getPosition(TGParticleSystem sys, DirResult dir, int i, int count) {
            Random rand = new Random();
            if (sys.type.volumeData.length >= 1) {
                Entity ent = sys.entity;
                if (ent == null) {
                    return new Vec3d(sys.posX(), sys.posY(), sys.posZ());
                }
                Vec3d motion = new Vec3d(ent.field_70159_w, ent.field_70181_x, ent.field_70179_y).func_72432_b();
                float len = sys.type.volumeData[0];
                float t = (float)i * 1.0f / ((float)count * 1.0f) * len;
                dir.setValues((float)motion.field_72450_a, (float)motion.field_72448_b, (float)motion.field_72449_c);
                return new Vec3d(-motion.field_72450_a * (double)t, -motion.field_72448_b * (double)t, -motion.field_72449_c * (double)t);
            }
            return new Vec3d(0.0, 0.0, 0.0);
        }
    };

    public void extend(TGParticleSystemType other) {
        int i;
        this.alphaEntries = new ArrayList<AlphaEntry>();
        other.alphaEntries.forEach(ae -> this.alphaEntries.add(ae.clone()));
        this.animationSpeedMax = other.animationSpeedMax;
        this.animationSpeedMin = other.animationSpeedMin;
        this.colorEntries = new ArrayList<ColorEntry>();
        other.colorEntries.forEach(ce -> this.colorEntries.add(new ColorEntry(ce.r, ce.g, ce.b, ce.time)));
        this.columns = other.columns;
        this.frames = other.frames;
        this.gravity = other.gravity;
        this.hasVariations = other.hasVariations;
        this.initialDelayMax = other.initialDelayMin;
        this.isHollow = other.isHollow;
        this.lifetimeMax = other.lifetimeMax;
        this.lifetimeMin = other.lifetimeMin;
        this.systemLifetimeMin = other.systemLifetimeMin;
        this.systemLifetimeMax = other.systemLifetimeMax;
        this.particleCountMax = other.particleCountMax;
        this.angleMin = other.angleMin;
        this.angleMax = other.angleMax;
        this.angleRateMin = other.angleRateMin;
        this.angleRateMax = other.angleRateMax;
        this.angleRateDampingMin = other.angleRateDampingMin;
        this.angleRateDampingMax = other.angleRateDampingMax;
        this.removeOnGround = other.removeOnGround;
        this.renderType = other.renderType;
        this.rows = other.rows;
        this.sizeMax = other.sizeMax;
        this.sizeMin = other.sizeMin;
        this.sizeRateDampingMax = other.sizeRateDampingMax;
        this.sizeRateDampingMin = other.sizeRateDampingMin;
        this.sizeRateMax = other.sizeRateMax;
        this.sizeRateMin = other.sizeRateMin;
        this.spawnDelayMax = other.spawnDelayMax;
        this.spawnDelayMin = other.spawnDelayMin;
        this.texture = other.texture;
        this.velocityDampingMax = other.velocityDampingMax;
        this.velocityDampingMin = other.velocityDampingMin;
        this.velocityDampingOnGroundMax = other.velocityDampingOnGroundMax;
        this.velocityDampingOnGroundMin = other.velocityDampingOnGroundMin;
        this.velocityDataMax = new float[other.velocityDataMax.length];
        this.velocityDataMin = new float[other.velocityDataMin.length];
        for (i = 0; i < other.velocityDataMax.length; ++i) {
            this.velocityDataMin[i] = other.velocityDataMin[i];
            this.velocityDataMax[i] = other.velocityDataMax[i];
        }
        this.velocityType = other.velocityType;
        this.volumeData = new float[other.volumeData.length];
        for (i = 0; i < other.volumeData.length; ++i) {
            this.volumeData[i] = other.volumeData[i];
        }
        this.volumeType = other.volumeType;
        this.offset = new Vec3d(other.offset.field_72450_a, other.offset.field_72448_b, other.offset.field_72449_c);
        this.particlesMoveWithSystem = other.particlesMoveWithSystem;
        this.streak = other.streak;
        this.groundAligned = other.groundAligned;
        this.attachedSystem = other.attachedSystem;
        this.systemVelocityFactorMin = other.systemVelocityFactorMin;
        this.systemVelocityFactorMax = other.systemVelocityFactorMax;
    }

    @Override
    public List<TGParticleSystem> createParticleSystems(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        ArrayList<TGParticleSystem> list = new ArrayList<TGParticleSystem>();
        list.add(new TGParticleSystem(world, this, posX, posY, posZ, motionX, motionY, motionZ));
        return list;
    }

    @Override
    public List<TGParticleSystem> createParticleSystemsOnEntity(Entity ent) {
        ArrayList<TGParticleSystem> list = new ArrayList<TGParticleSystem>();
        list.add(new TGParticleSystem(ent, this));
        return list;
    }

    @Override
    public List<TGParticleSystem> createParticleSystemsOnParticle(World worldIn, TGParticle ent) {
        ArrayList<TGParticleSystem> list = new ArrayList<TGParticleSystem>();
        list.add(new TGParticleSystem(worldIn, ent, this));
        return list;
    }

    @Override
    public List<TGParticleSystem> createParticleSystemsOnEntityItemAttached(Entity ent, EnumHand hand) {
        ArrayList<TGParticleSystem> list = new ArrayList<TGParticleSystem>();
        list.add(new TGParticleSystemItemAttached(ent, hand, this));
        return list;
    }

    class DirResult {
        public float[] values;

        public void setValues(float ... params) {
            this.values = params;
        }

        public DirResult(float ... params) {
            this.values = params;
        }
    }

    public static interface IVolumeType {
        public Vec3d getPosition(TGParticleSystem var1, DirResult var2, int var3, int var4);
    }

    public static interface IVelocityType {
        public Vec3d getVelocity(TGParticleSystem var1, float ... var2);
    }

    public static class AlphaEntry {
        float time;
        float alpha;

        public AlphaEntry(float alpha, float time) {
            this.time = time;
            this.alpha = alpha;
        }

        public AlphaEntry clone() {
            return new AlphaEntry(this.alpha, this.time);
        }
    }

    public static class ColorEntry {
        float time;
        float r;
        float g;
        float b;

        public ColorEntry(int r, int g, int b, float time) {
            this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, time);
        }

        public ColorEntry(float r, float g, float b, float time) {
            this.time = time;
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

