/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.particle.list;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ParticleList<E>
implements Iterable<E> {
    protected ParticleListElement<E> first = null;
    protected ParticleListElement<E> last = null;
    int size = 0;

    public void add(E e) {
        if (this.first == null) {
            this.first = new ParticleListElement<E>(e);
            this.last = this.first;
        } else {
            ParticleListElement<E> n = new ParticleListElement<E>(e);
            this.last.next = n;
            n.prev = this.last;
            this.last = n;
        }
        ++this.size;
    }

    public void debugPrintList() {
        int i = 0;
        ParticleListElement<E> elem = this.first;
        if (elem == null) {
            System.out.println("|EMPTY|");
            return;
        }
        while (elem.next != null) {
            System.out.println("|" + i + ":" + elem.e + "|");
            elem = elem.next;
            ++i;
        }
        System.out.println("|" + i + ":" + elem.e);
        System.out.println("<SIZE>:" + this.size);
    }

    public void doBubbleSort(int times, Comparator<E> comp) {
        if (this.size > 0) {
            boolean changes = true;
            for (int i = 0; i < times && changes; ++i) {
                changes = false;
                Iterator it = this.iterator();
                Object prev = null;
                Object current = null;
                while (((ParticleListIterator)it).hasNext()) {
                    current = ((ParticleListIterator)it).next();
                    if (prev != null && comp.compare(prev, current) > 0) {
                        ((ParticleListIterator)it).swapWithPrev();
                        changes = true;
                    }
                    prev = current;
                }
            }
        }
    }

    public void remove(ParticleListElement<E> listElem) {
        if (listElem == this.first) {
            this.first = listElem.next;
            if (this.first != null) {
                this.first.prev = null;
            }
        } else if (listElem == this.last) {
            this.last = listElem.prev;
            if (this.last != null) {
                this.last.next = null;
            }
        } else {
            listElem.prev.next = listElem.next;
            if (listElem.next != null) {
                listElem.next.prev = listElem.prev;
            }
            listElem.prev = null;
        }
        --this.size;
    }

    public int getSizeDebug() {
        if (this.first == null) {
            return 0;
        }
        ParticleListElement<E> elem = this.first;
        int i = 1;
        while (elem != this.last) {
            elem = elem.next;
            ++i;
        }
        return i;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public ParticleListIterator<E> iterator() {
        return new ParticleListIterator(this);
    }

    public static class ParticleListIterator<E>
    implements Iterator<E> {
        ParticleList<E> list;
        ParticleListElement<E> current;

        public ParticleListIterator(ParticleList<E> list) {
            this.list = list;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            if (this.current == null && this.list.first == null) {
                return false;
            }
            if (this.current != null && this.current.next == null) {
                return false;
            }
            return this.current != this.list.last;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("ParticleList has no more elements!");
            }
            this.current = this.current == null ? this.list.first : this.current.next;
            return this.current.e;
        }

        public void swapWithPrev() {
            if (this.current != null && this.current != this.list.first) {
                ParticleListElement prev = this.current.prev;
                if (prev.prev != null) {
                    prev.prev.next = this.current;
                } else {
                    this.list.first = this.current;
                }
                if (this.current.next != null) {
                    this.current.next.prev = prev;
                }
                if (this.list.last == this.current) {
                    this.list.last = prev;
                }
                this.current.prev = prev.prev;
                prev.next = this.current.next;
                this.current.next = prev;
                prev.prev = this.current;
                this.current = prev;
            }
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException("Current element is null!");
            }
            this.list.remove(this.current);
        }
    }

    protected static class ParticleListElement<E> {
        protected ParticleListElement<E> next;
        protected ParticleListElement<E> prev;
        protected E e;

        public ParticleListElement(E e) {
            this.e = e;
        }
    }
}

