/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.render.entities.projectiles;

import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import techguns.client.render.TGRenderHelper;
import techguns.client.render.entities.projectiles.RenderGenericProjectile;
import techguns.entities.projectiles.SonicShotgunProjectile;

public class RenderSonicShotgunProjectile
extends RenderGenericProjectile<SonicShotgunProjectile> {
    private static final ResourceLocation bulletTexture = new ResourceLocation("techguns", "textures/entity/bullet.png");
    private static final ResourceLocation waveTexture_A = new ResourceLocation("techguns", "textures/fx/sonicwave4x4.png");
    private static final ResourceLocation waveTexture = new ResourceLocation("techguns", "textures/fx/shockwave.png");

    public RenderSonicShotgunProjectile(RenderManager renderManager) {
        super(renderManager);
    }

    @Override
    public void doRender(SonicShotgunProjectile proj, double x, double y, double z, float entityYaw, float partialTicks) {
        if (proj.field_70173_aa >= 3 && proj.mainProjectile) {
            Random rand = new Random(proj.func_145782_y());
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179114_b((float)(proj.field_70177_z - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)proj.field_70125_A, (float)0.0f, (float)0.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            GlStateManager.func_179091_B();
            double d = (double)((float)proj.field_70173_aa + partialTicks) * 0.3;
            TGRenderHelper.enableBlendMode(TGRenderHelper.RenderType.ADDITIVE);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float prog = (float)Math.min(1.0, (double)(((float)proj.field_70173_aa + partialTicks) / 20.0f));
            float opacity = 1.0f - (float)Math.pow(prog, 2.0);
            this.func_110776_a(waveTexture);
            BufferBuilder buf = tessellator.func_178180_c();
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (int i = 0; i <= 5; ++i) {
                float r = opacity * rand.nextFloat();
                float g = opacity * rand.nextFloat();
                float b = opacity * (0.5f + rand.nextFloat() * 0.5f);
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)opacity);
                double offset = 2.5 - (double)i;
                double size = d * (0.5 + rand.nextDouble());
                this.drawWave(buf, size, offset);
            }
            tessellator.func_78381_a();
            TGRenderHelper.disableBlendMode(TGRenderHelper.RenderType.ADDITIVE);
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
        }
    }

    private void drawWave(BufferBuilder buf, double size, double offset) {
        buf.func_181662_b(offset, -size, -size).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(offset, -size, size).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(offset, size, size).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(offset, size, -size).func_187315_a(1.0, 0.0).func_181675_d();
    }
}

