/*
 * Decompiled with CFR 0.152.
 */
package techguns.damagesystem;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import techguns.TGConfig;
import techguns.api.damagesystem.DamageType;
import techguns.api.npc.INpcTGDamageSystem;
import techguns.damagesystem.ShieldStats;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.npcs.NPCTurret;
import techguns.items.armors.GenericArmor;
import techguns.util.MathUtil;

public class DamageSystem {
    protected static Field ENT_rand = ReflectionHelper.findField(Entity.class, (String)"rand", (String)"field_70146_Z");
    protected static Field ELB_idleTime = ReflectionHelper.findField(EntityLivingBase.class, (String)"idleTime", (String)"field_70708_bq");
    protected static Field ELB_lastDamage = ReflectionHelper.findField(EntityLivingBase.class, (String)"lastDamage", (String)"field_110153_bc");
    protected static Field ELB_recentlyHit = ReflectionHelper.findField(EntityLivingBase.class, (String)"recentlyHit", (String)"field_70718_bc");
    protected static Field ELB_attackingPlayer = ReflectionHelper.findField(EntityLivingBase.class, (String)"attackingPlayer", (String)"field_70717_bb");
    protected static Field ELB_lastDamageSource = ReflectionHelper.findField(EntityLivingBase.class, (String)"lastDamageSource", (String)"field_189750_bF");
    protected static Field ELB_lastDamageStamp = ReflectionHelper.findField(EntityLivingBase.class, (String)"lastDamageStamp", (String)"field_189751_bG");
    protected static Method ELB_canBlockDamageSource = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"canBlockDamageSource", (String)"func_184583_d", (Class[])new Class[]{DamageSource.class});
    protected static Method ELB_damageShield = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"damageShield", (String)"func_184590_k", (Class[])new Class[]{Float.TYPE});
    protected static Method ELB_blockUsingShield = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"blockUsingShield", (String)"func_190629_c", (Class[])new Class[]{EntityLivingBase.class});
    protected static Method ELB_damageEntity = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"damageEntity", (String)"func_70665_d", (Class[])new Class[]{DamageSource.class, Float.TYPE});
    protected static Method ELB_setBeenAttacked = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"markVelocityChanged", (String)"func_70018_K", (Class[])new Class[0]);
    protected static Method ELB_checkTotemDeathProtection = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"checkTotemDeathProtection", (String)"func_190628_d", (Class[])new Class[]{DamageSource.class});
    protected static Method ELB_getDeathSound = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"getDeathSound", (String)"func_184615_bR", (Class[])new Class[0]);
    protected static Method ELB_getSoundVolume = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"getSoundVolume", (String)"func_70599_aP", (Class[])new Class[0]);
    protected static Method ELB_getSoundPitch = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"getSoundPitch", (String)"func_70647_i", (Class[])new Class[0]);
    protected static Method ELB_playHurtSound = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"playHurtSound", (String)"func_184581_c", (Class[])new Class[]{DamageSource.class});
    protected static Method ELB_applyPotionDamageCalculations = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"applyPotionDamageCalculations", (String)"func_70672_c", (Class[])new Class[]{DamageSource.class, Float.TYPE});
    protected static Method ELB_damageArmor = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"damageArmor", (String)"func_70675_k", (Class[])new Class[]{Float.TYPE});

    public static float getDamageFactor(EntityLivingBase attacker, EntityLivingBase target) {
        if (attacker instanceof EntityPlayer && target instanceof EntityPlayer) {
            if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W()) {
                return TGConfig.damagePvP;
            }
            return 0.0f;
        }
        if (target instanceof EntityPlayer) {
            if (attacker instanceof NPCTurret) {
                return TGConfig.damageTurretToPlayer;
            }
            return TGConfig.damageFactorNPC;
        }
        if (attacker instanceof EntityPlayer) {
            return 1.0f;
        }
        return TGConfig.damageFactorNPC;
    }

    public static float getTotalArmorAgainstType(EntityPlayer ply, DamageType type) {
        float value = 0.0f;
        for (int i = 0; i < 4; ++i) {
            ItemStack armor = (ItemStack)ply.field_71071_by.field_70460_b.get(i);
            if (armor == null) continue;
            Item item = armor.func_77973_b();
            if (item instanceof GenericArmor) {
                value += ((GenericArmor)item).getArmorValue(armor, type);
                continue;
            }
            if (!(item instanceof ItemArmor) || type != DamageType.PHYSICAL) continue;
            value += (float)((ItemArmor)item).func_82812_d().func_78044_b(((ItemArmor)item).field_77881_a);
        }
        return value;
    }

    public static float getArmorAgainstDamageTypeDefault(EntityLivingBase elb, float armor, DamageType damageType) {
        switch (damageType) {
            case PHYSICAL: 
            case PROJECTILE: {
                return armor;
            }
            case EXPLOSION: 
            case ENERGY: 
            case ICE: 
            case LIGHTNING: 
            case DARK: {
                return armor * 0.5f;
            }
            case FIRE: {
                if (elb.func_70045_F()) {
                    return armor * 2.0f;
                }
                return armor * 0.5f;
            }
            case POISON: {
                return 0.0f;
            }
            case RADIATION: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public static boolean attackEntityFrom(EntityLivingBase ent, DamageSource source, float amount) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        boolean flag2;
        TGDamageSource dmgsrc = TGDamageSource.getFromGenericDamageSource(source);
        if (ent.func_180431_b(source)) {
            return false;
        }
        if (ent.field_70170_p.field_72995_K) {
            return false;
        }
        ELB_idleTime.setInt(ent, 0);
        if (ent.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (source.func_76347_k() && ent.func_70644_a(MobEffects.field_76426_n)) {
            return false;
        }
        float f = amount;
        if (!(source != DamageSource.field_82728_o && source != DamageSource.field_82729_p || ent.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b())) {
            ent.func_184582_a(EntityEquipmentSlot.HEAD).func_77972_a((int)(amount * 4.0f + ((Random)ENT_rand.get(ent)).nextFloat() * amount * 2.0f), ent);
            amount *= 0.75f;
        }
        boolean flag = false;
        if (amount > 0.0f && ((Boolean)ELB_canBlockDamageSource.invoke((Object)ent, source)).booleanValue()) {
            Entity entity;
            ELB_damageShield.invoke((Object)ent, Float.valueOf(amount));
            amount = DamageSystem.calculateShieldDamage(ent, amount, dmgsrc);
            ShieldStats.playBlockSound(ent, dmgsrc);
            if (dmgsrc.knockbackOnShieldBlock() && (entity = source.func_76364_f()) instanceof EntityLivingBase) {
                ELB_blockUsingShield.invoke((Object)ent, (EntityLivingBase)entity);
            }
            flag = true;
        }
        ent.field_70721_aZ = 1.5f;
        boolean flag1 = true;
        if (!dmgsrc.ignoreHurtresistTime && (float)ent.field_70172_ad > (float)ent.field_70771_an / 2.0f) {
            if (amount <= ELB_lastDamage.getFloat(ent)) {
                return false;
            }
            ELB_damageEntity.invoke((Object)ent, source, Float.valueOf(amount - ELB_lastDamage.getFloat(ent)));
            ELB_lastDamage.setFloat(ent, amount);
            flag1 = false;
        } else {
            if (!dmgsrc.ignoreHurtresistTime) {
                ELB_lastDamage.setFloat(ent, amount);
                ent.field_70172_ad = ent.field_70771_an;
            }
            ELB_damageEntity.invoke((Object)ent, source, Float.valueOf(amount));
            if (!dmgsrc.ignoreHurtresistTime) {
                ent.field_70737_aN = ent.field_70738_aO = 10;
            }
        }
        ent.field_70739_aP = 0.0f;
        Entity entity1 = source.func_76346_g();
        if (entity1 != null) {
            EntityTameable entitywolf;
            if (entity1 instanceof EntityLivingBase) {
                ent.func_70604_c((EntityLivingBase)entity1);
            }
            if (entity1 instanceof EntityPlayer) {
                ELB_recentlyHit.setInt(ent, 100);
                ELB_attackingPlayer.set(ent, (EntityPlayer)entity1);
            } else if (entity1 instanceof EntityTameable && (entitywolf = (EntityTameable)entity1).func_70909_n()) {
                ELB_recentlyHit.setInt(ent, 100);
                ELB_attackingPlayer.set(ent, null);
            }
        }
        if (flag1) {
            if (flag) {
                ent.field_70170_p.func_72960_a((Entity)ent, (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
                ent.field_70170_p.func_72960_a((Entity)ent, (byte)33);
            } else {
                byte b0 = source == DamageSource.field_76369_e ? (byte)36 : (source.func_76347_k() ? (byte)37 : 2);
                ent.field_70170_p.func_72960_a((Entity)ent, b0);
            }
            if (source != DamageSource.field_76369_e && (!flag || amount > 0.0f)) {
                ELB_setBeenAttacked.invoke((Object)ent, new Object[0]);
            }
            if (entity1 != null) {
                double d1 = entity1.field_70165_t - ent.field_70165_t;
                double d0 = entity1.field_70161_v - ent.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                ent.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.29577951308232 - (double)ent.field_70177_z);
                float knockback_strength = 0.4f * dmgsrc.knockbackMultiplier;
                if (knockback_strength > 0.0f) {
                    ent.func_70653_a(entity1, knockback_strength, d1, d0);
                }
            } else {
                ent.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (ent.func_110143_aJ() <= 0.0f) {
            if (!((Boolean)ELB_checkTotemDeathProtection.invoke((Object)ent, source)).booleanValue()) {
                SoundEvent soundevent = (SoundEvent)ELB_getDeathSound.invoke((Object)ent, new Object[0]);
                if (flag1 && soundevent != null) {
                    ent.func_184185_a(soundevent, ((Float)ELB_getSoundVolume.invoke((Object)ent, new Object[0])).floatValue(), ((Float)ELB_getSoundPitch.invoke((Object)ent, new Object[0])).floatValue());
                }
                ent.func_70645_a(source);
            }
        } else if (flag1) {
            ELB_playHurtSound.invoke((Object)ent, source);
        }
        boolean bl = flag2 = !flag || amount > 0.0f;
        if (flag2) {
            ELB_lastDamageSource.set(ent, source);
            ELB_lastDamageStamp.setLong(ent, ent.field_70170_p.func_82737_E());
        }
        if (ent instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192128_h.func_192200_a((EntityPlayerMP)ent, source, f, amount, flag);
        }
        if (entity1 instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192127_g.func_192220_a((EntityPlayerMP)entity1, (Entity)ent, source, f, amount, flag);
        }
        if (flag2) {
            dmgsrc.setAttackSuccessful();
        }
        return flag2;
    }

    public static float calculateShieldDamage(EntityLivingBase ent, float amount, TGDamageSource source) {
        ItemStack active = ent.func_184607_cu();
        ShieldStats s = ShieldStats.getStats(active, ent);
        if (s != null) {
            return s.getAmount(amount, source);
        }
        return amount;
    }

    public static void livingHurt(EntityLivingBase elb, DamageSource damageSrc, float damageAmount) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        damageAmount = DamageSystem.ELB_applyArmorCalculations(elb, damageSrc, damageAmount);
        float f = damageAmount = ((Float)ELB_applyPotionDamageCalculations.invoke((Object)elb, damageSrc, Float.valueOf(damageAmount))).floatValue();
        damageAmount = Math.max(damageAmount - elb.func_110139_bj(), 0.0f);
        elb.func_110149_m(elb.func_110139_bj() - (f - damageAmount));
        damageAmount = ForgeHooks.onLivingDamage((EntityLivingBase)elb, (DamageSource)damageSrc, (float)damageAmount);
        if (damageAmount != 0.0f) {
            float f1 = elb.func_110143_aJ();
            elb.func_70606_j(f1 - damageAmount);
            elb.func_110142_aN().func_94547_a(damageSrc, f1, damageAmount);
            elb.func_110149_m(elb.func_110139_bj() - damageAmount);
        }
    }

    public static float ELB_applyArmorCalculations(EntityLivingBase elb, DamageSource source, float damage) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!source.func_76363_c()) {
            ELB_damageArmor.invoke((Object)elb, Float.valueOf(damage));
            TGDamageSource dmgsrc = TGDamageSource.getFromGenericDamageSource(source);
            INpcTGDamageSystem tg = (INpcTGDamageSystem)elb;
            float toughness = (float)elb.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e();
            damage = (float)DamageSystem.getDamageAfterAbsorb_TGFormula(damage, tg.getTotalArmorAgainstType(dmgsrc), toughness, dmgsrc.armorPenetration * 4.0f);
        }
        return damage;
    }

    public static double getDamageAfterAbsorb_TGFormula(float damage, float totalArmor, float toughnessAttribute, float penetration) {
        float pen = Math.max(penetration - toughnessAttribute, 0.0f);
        double armor = MathUtil.clamp((double)(totalArmor - pen), 0.0, 24.0);
        return (double)damage * (1.0 - armor / 25.0);
    }
}

