/*
 * Decompiled with CFR 0.152.
 */
package techguns.damagesystem;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import techguns.api.damagesystem.DamageType;
import techguns.deatheffects.EntityDeathUtils;

public class TGDamageSource
extends EntityDamageSource {
    protected boolean attackSuccessful = false;
    public Entity attacker = null;
    public DamageType field_76373_n;
    public EntityDeathUtils.DeathType deathType;
    public float goreChance = 0.5f;
    public boolean knockbackOnShieldBlock = true;
    public float armorPenetration = 0.0f;
    public boolean ignoreHurtresistTime = false;
    public float knockbackMultiplier = 1.0f;
    public boolean wasConverted = false;
    protected static ArrayList<String> unresistableTypes = new ArrayList();

    public void setAttackSuccessful() {
        this.attackSuccessful = true;
    }

    public boolean wasSuccessful() {
        return this.attackSuccessful;
    }

    public static TGDamageSource causeBulletDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_bullet", projectile, shooter, DamageType.PROJECTILE, deathType);
        src.knockbackOnShieldBlock = false;
        src.ignoreHurtresistTime = true;
        return src;
    }

    public static TGDamageSource causeExplosionDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        return new TGDamageSource("tg_explosion", projectile, shooter, DamageType.EXPLOSION, deathType);
    }

    public static TGDamageSource causePoisonDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_poison", projectile, shooter, DamageType.POISON, deathType);
        src.ignoreHurtresistTime = true;
        src.knockbackOnShieldBlock = false;
        return src;
    }

    public static TGDamageSource causeFireDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_fire", projectile, shooter, DamageType.FIRE, deathType);
        src.ignoreHurtresistTime = true;
        src.knockbackOnShieldBlock = false;
        return src;
    }

    public static TGDamageSource getKnockbackDummyDmgSrc(Entity projectile, Entity shooter) {
        return new TGDamageSource("tg_knockback", projectile, shooter, DamageType.PHYSICAL, EntityDeathUtils.DeathType.DEFAULT);
    }

    public static TGDamageSource causeEnergyDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_energy", projectile, shooter, DamageType.ENERGY, deathType);
        src.ignoreHurtresistTime = true;
        src.knockbackOnShieldBlock = false;
        return src;
    }

    public static TGDamageSource causeRadiationDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_rad", projectile, shooter, DamageType.RADIATION, deathType);
        src.ignoreHurtresistTime = true;
        src.knockbackOnShieldBlock = false;
        return src;
    }

    public static TGDamageSource causeLethalRadPoisoningDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_rad_poisoning", projectile, shooter, DamageType.UNRESISTABLE, deathType);
        src.ignoreHurtresistTime = true;
        src.knockbackOnShieldBlock = false;
        src.goreChance = 1.0f;
        return src;
    }

    public static TGDamageSource causeLightningDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_lightning", projectile, shooter, DamageType.LIGHTNING, deathType);
        src.ignoreHurtresistTime = true;
        src.knockbackOnShieldBlock = false;
        return src;
    }

    public static TGDamageSource causeDarkDamage(Entity projectile, Entity shooter, EntityDeathUtils.DeathType deathType) {
        TGDamageSource src = new TGDamageSource("tg_dark", projectile, shooter, DamageType.DARK, deathType);
        src.ignoreHurtresistTime = true;
        src.knockbackOnShieldBlock = false;
        return src;
    }

    public static TGDamageSource getFromGenericDamageSource(DamageSource src) {
        if (src instanceof TGDamageSource) {
            return (TGDamageSource)src;
        }
        return new TGDamageSource(src);
    }

    public TGDamageSource setNoKnockback() {
        this.knockbackMultiplier = 0.0f;
        return this;
    }

    public TGDamageSource setKnockback(float mult) {
        this.knockbackMultiplier = mult;
        return this;
    }

    public boolean hasKnockback() {
        return this.knockbackMultiplier > 0.0f;
    }

    public ITextComponent func_151519_b(EntityLivingBase entityLivingBaseIn) {
        ITextComponent itextcomponent;
        ItemStack itemstack = ItemStack.field_190927_a;
        if (this.attacker == null && this.field_76386_o == null) {
            itextcomponent = entityLivingBaseIn.func_145748_c_();
        } else {
            itextcomponent = this.attacker == null ? this.field_76386_o.func_145748_c_() : this.attacker.func_145748_c_();
            itemstack = this.attacker instanceof EntityLivingBase ? ((EntityLivingBase)this.attacker).func_184614_ca() : ItemStack.field_190927_a;
        }
        String s = "death.attack." + this.func_76355_l();
        String s1 = s + ".item";
        return !itemstack.func_190926_b() && itemstack.func_82837_s() && I18n.func_94522_b((String)s1) ? new TextComponentTranslation(s1, new Object[]{entityLivingBaseIn.func_145748_c_(), itextcomponent, itemstack.func_151000_E()}) : new TextComponentTranslation(s, new Object[]{entityLivingBaseIn.func_145748_c_(), itextcomponent});
    }

    public static TGDamageSource copyWithNewEnt(TGDamageSource other, Entity damagingEntity, Entity attacker) {
        TGDamageSource newSrc = new TGDamageSource(other.func_76355_l(), damagingEntity, attacker, other.field_76373_n, other.deathType);
        newSrc.knockbackMultiplier = other.knockbackMultiplier;
        newSrc.armorPenetration = other.armorPenetration;
        newSrc.goreChance = other.goreChance;
        newSrc.ignoreHurtresistTime = other.ignoreHurtresistTime;
        return newSrc;
    }

    public TGDamageSource(String name, Entity damagingEntity, Entity attacker, DamageType damageType, EntityDeathUtils.DeathType deathType) {
        super(name, damagingEntity);
        this.attacker = attacker;
        this.field_76373_n = damageType;
        this.deathType = deathType;
        this.setBehaviourForVanilla();
    }

    public void setBehaviourForVanilla() {
        switch (this.field_76373_n) {
            case ENERGY: {
                this.func_82726_p();
                break;
            }
            case EXPLOSION: {
                this.func_94540_d();
                break;
            }
            case FIRE: {
                this.func_82726_p();
                break;
            }
            case ICE: {
                this.func_82726_p();
                break;
            }
            case LIGHTNING: {
                this.func_82726_p();
                break;
            }
            case PHYSICAL: {
                break;
            }
            case POISON: {
                this.func_82726_p();
                break;
            }
            case PROJECTILE: {
                this.func_76349_b();
                break;
            }
            case RADIATION: {
                this.func_82726_p();
                break;
            }
            case DARK: {
                this.func_82726_p();
                break;
            }
            case UNRESISTABLE: {
                this.func_76348_h();
                this.func_151518_m();
                break;
            }
        }
    }

    public TGDamageSource(EntityDamageSourceIndirect dmg) {
        super(dmg.field_76373_n, dmg.func_76364_f());
        this.attacker = dmg.func_76346_g();
        this.determineTGDamageType((DamageSource)dmg);
        this.wasConverted = true;
        if (dmg.func_76357_e()) {
            this.func_76359_i();
        }
        if (dmg.func_151517_h()) {
            this.func_151518_m();
        }
        if (dmg.func_76350_n()) {
            this.func_151518_m();
        }
        if (dmg.func_94541_c()) {
            this.func_94540_d();
        }
        if (dmg.func_76347_k()) {
            this.func_76361_j();
        }
        if (dmg.func_82725_o()) {
            this.func_82726_p();
        }
        if (dmg.func_76352_a()) {
            this.func_76349_b();
        }
        if (dmg.func_76363_c()) {
            this.func_76348_h();
        }
    }

    public TGDamageSource(EntityDamageSource dmg) {
        super(dmg.field_76373_n, dmg.func_76364_f());
        this.attacker = dmg.func_76346_g();
        this.determineTGDamageType((DamageSource)dmg);
        this.wasConverted = true;
        if (dmg.func_76357_e()) {
            this.func_76359_i();
        }
        if (dmg.func_151517_h()) {
            this.func_151518_m();
        }
        if (dmg.func_76350_n()) {
            this.func_151518_m();
        }
        if (dmg.func_94541_c()) {
            this.func_94540_d();
        }
        if (dmg.func_76347_k()) {
            this.func_76361_j();
        }
        if (dmg.func_82725_o()) {
            this.func_82726_p();
        }
        if (dmg.func_76352_a()) {
            this.func_76349_b();
        }
        if (dmg.func_76363_c()) {
            this.func_76348_h();
        }
    }

    public TGDamageSource(DamageSource dmg) {
        super(dmg.field_76373_n, dmg.func_76364_f());
        this.attacker = dmg.func_76346_g();
        this.determineTGDamageType(dmg);
        this.wasConverted = true;
        if (dmg.func_76357_e()) {
            this.func_76359_i();
        }
        if (dmg.func_151517_h()) {
            this.func_151518_m();
        }
        if (dmg.func_76350_n()) {
            this.func_76351_m();
        }
        if (dmg.func_94541_c()) {
            this.func_94540_d();
        }
        if (dmg.func_76347_k()) {
            this.func_76361_j();
        }
        if (dmg.func_82725_o()) {
            this.func_82726_p();
        }
        if (dmg.func_76352_a()) {
            this.func_76349_b();
            this.knockbackOnShieldBlock = false;
        }
        if (dmg.func_76363_c()) {
            this.func_76348_h();
        }
    }

    private void determineTGDamageType(DamageSource dmg) {
        this.field_76373_n = dmg.func_94541_c() ? DamageType.EXPLOSION : (dmg.func_82725_o() ? DamageType.ENERGY : (dmg.func_76347_k() || dmg.func_76355_l().equals("dragonBreath") ? DamageType.FIRE : (dmg.func_76352_a() ? DamageType.PROJECTILE : (dmg.func_76355_l().equals("wither") ? DamageType.POISON : (dmg.func_76355_l().equals("lightningBolt") ? DamageType.LIGHTNING : (dmg.func_76357_e() || unresistableTypes.contains(dmg.field_76373_n) ? DamageType.UNRESISTABLE : DamageType.PHYSICAL))))));
    }

    public Entity func_76346_g() {
        return this.attacker;
    }

    public Entity func_76364_f() {
        return this.field_76386_o;
    }

    public boolean knockbackOnShieldBlock() {
        return this.knockbackOnShieldBlock;
    }

    public TGDamageSource setKnockbackOnShieldBlock(boolean knockbackOnShieldBlock) {
        this.knockbackOnShieldBlock = knockbackOnShieldBlock;
        return this;
    }

    static {
        unresistableTypes.add("inWall");
        unresistableTypes.add("drown");
        unresistableTypes.add("starve");
        unresistableTypes.add("fall");
        unresistableTypes.add("outOfWorld");
    }
}

