/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import techguns.TGBlocks;
import techguns.TGSounds;
import techguns.Techguns;
import techguns.api.damagesystem.DamageType;
import techguns.blocks.BlockBioblob;
import techguns.client.ClientProxy;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IChargedProjectileFactory;
import techguns.tileentities.BioBlobTileEnt;

public class BioGunProjectile
extends GenericProjectile
implements IEntityAdditionalSpawnData {
    public int level;

    public BioGunProjectile(World worldIn, double posX, double posY, double posZ, float yaw, float pitch, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, double gravity, int level) {
        super(worldIn, posX, posY, posZ, yaw, pitch, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.level = level;
        this.gravity = gravity;
    }

    public BioGunProjectile(World par2World, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos leftGun, double gravity, int level) {
        super(par2World, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, leftGun);
        this.level = level;
        this.gravity = gravity;
    }

    public BioGunProjectile(World worldIn) {
        super(worldIn);
        ClientProxy.get().createFXOnEntity("BioGunTrail", this);
    }

    @Override
    protected void onHitEffect(EntityLivingBase ent, RayTraceResult rayTraceResult) {
        ent.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 3, false, true));
        this.doImpactEffects(null, rayTraceResult, null);
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causePoisonDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.BIO);
        src.goreChance = 1.0f;
        src.armorPenetration = this.penetration;
        src.setNoKnockback();
        return src;
    }

    @Override
    protected void doImpactEffects(Material mat, RayTraceResult rayTraceResult, SoundType sound) {
        double x = rayTraceResult.field_72307_f.field_72450_a;
        double y = rayTraceResult.field_72307_f.field_72448_b;
        double z = rayTraceResult.field_72307_f.field_72449_c;
        boolean distdelay = true;
        float pitch = 0.0f;
        float yaw = 0.0f;
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (rayTraceResult.field_178784_b == EnumFacing.UP) {
                pitch = -90.0f;
            } else if (rayTraceResult.field_178784_b == EnumFacing.DOWN) {
                pitch = 90.0f;
            } else {
                yaw = rayTraceResult.field_178784_b.func_185119_l();
            }
        } else {
            pitch = -this.field_70125_A;
            yaw = -this.field_70177_z;
        }
        this.field_70170_p.func_184134_a(x, y, z, TGSounds.BIOGUN_IMPACT, SoundCategory.AMBIENT, 1.0f, 1.0f, distdelay);
        Techguns.proxy.createFX("biogunImpact", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0, pitch, yaw);
    }

    @Override
    protected void hitBlock(RayTraceResult mop) {
        IBlockState statehit = this.field_70170_p.func_180495_p(mop.func_178782_a());
        if (statehit.func_177230_c() == TGBlocks.BIOBLOB) {
            TileEntity tile = this.field_70170_p.func_175625_s(mop.func_178782_a());
            if (tile != null && tile instanceof BioBlobTileEnt) {
                ((BioBlobTileEnt)tile).hitBlob(this.level, this.shooter);
            }
        } else if (!this.field_70170_p.field_72995_K) {
            BlockPos blobPos = mop.func_178782_a().func_177972_a(mop.field_178784_b);
            if (this.field_70170_p.func_175623_d(blobPos)) {
                if (this.blockdamage) {
                    boolean canPlace = true;
                    if (this.shooter instanceof EntityPlayer) {
                        BlockEvent.PlaceEvent placeEvent = new BlockEvent.PlaceEvent(BlockSnapshot.getBlockSnapshot((World)this.field_70170_p, (BlockPos)blobPos), statehit, (EntityPlayer)this.shooter, EnumHand.MAIN_HAND);
                        MinecraftForge.EVENT_BUS.post((Event)placeEvent);
                        boolean bl = canPlace = !placeEvent.isCanceled();
                    }
                    if (canPlace) {
                        IBlockState state = TGBlocks.BIOBLOB.func_176223_P().func_177226_a((IProperty)BlockBioblob.FACING_ALL, (Comparable)mop.field_178784_b.func_176734_d()).func_177226_a((IProperty)BlockBioblob.SIZE, (Comparable)Integer.valueOf(0));
                        int lvl = 0;
                        this.field_70170_p.func_175656_a(blobPos, TGBlocks.BIOBLOB.func_176223_P());
                        if (this.level > 1) {
                            TileEntity tile = this.field_70170_p.func_175625_s(blobPos);
                            if (tile != null && tile instanceof BioBlobTileEnt) {
                                BioBlobTileEnt blob = (BioBlobTileEnt)tile;
                                blob.hitBlob(this.level - 1, this.shooter);
                            }
                            lvl = this.level - 1;
                        }
                        this.field_70170_p.func_180501_a(blobPos, state.func_177226_a((IProperty)BlockBioblob.SIZE, (Comparable)Integer.valueOf(lvl)), 3);
                    }
                }
            } else {
                TileEntity tile = this.field_70170_p.func_175625_s(blobPos);
                if (tile != null && tile instanceof BioBlobTileEnt) {
                    ((BioBlobTileEnt)tile).hitBlob(this.level, this.shooter);
                }
            }
        }
        super.hitBlock(mop);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            for (int l = 0; l < 4; ++l) {
                float f4 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            this.func_70106_y();
        }
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte((int)((byte)this.level));
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        this.level = additionalData.readByte();
    }

    public static class Factory
    implements IChargedProjectileFactory<BioGunProjectile> {
        @Override
        public BioGunProjectile createProjectile(GenericGun gun, World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity) {
            return this.createChargedProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos, radius, gravity, 0.0f, 1);
        }

        @Override
        public DamageType getDamageType() {
            return DamageType.POISON;
        }

        @Override
        public BioGunProjectile createChargedProjectile(World world, EntityLivingBase p, float damage, float speed, int TTL, float spread, float dmgDropStart, float dmgDropEnd, float dmgMin, float penetration, boolean blockdamage, EnumBulletFirePos firePos, float radius, double gravity, float charge, int ammoConsumed) {
            return new BioGunProjectile(world, p, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage, firePos, gravity, ammoConsumed);
        }
    }
}

