/*
 * Decompiled with CFR 0.152.
 */
package techguns.gui;

import java.util.ArrayList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTankInfo;
import techguns.TGConfig;
import techguns.gui.PoweredTileEntGui;
import techguns.gui.containers.OreDrillContainer;
import techguns.tileentities.OreDrillTileEntMaster;
import techguns.util.TextUtil;

public class OreDrillGui
extends PoweredTileEntGui {
    public static final ResourceLocation texture = new ResourceLocation("techguns", "textures/gui/ore_drill_gui.png");
    public static final int INPUT_TANK_X = 15;
    public static final int TANK_Y = 17;
    public static final int OUTPUT_TANK_X = 157;
    public static final int TANK_W = 10;
    public static final int TANK_H = 50;
    protected OreDrillTileEntMaster tile;

    public OreDrillGui(InventoryPlayer ply, OreDrillTileEntMaster tileent) {
        super((Container)new OreDrillContainer(ply, tileent), tileent);
        this.tex = texture;
        this.tile = tileent;
        this.hasUpgradeSlot = false;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        FluidTankInfo info;
        super.func_146979_b(mouseX, mouseY);
        int color = 0x404040;
        int mx = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int my = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (!this.tile.isFormed()) {
            String s1 = TextUtil.trans("techguns.container.oredrill.broken");
            int startx = this.field_146999_f / 2 - s1.length() * 6 / 2;
            int red = -57312;
            this.field_146289_q.func_78276_b(s1, startx - 16 + 30, 24, red);
        } else if (this.tile.getDrillItemMiningLevel() < 0) {
            int rad = this.tile.getDrillRadius();
            String s1 = "2";
            if (rad == 0) {
                s1 = "0";
            } else if (rad == 1 || rad == 2) {
                s1 = "1";
            }
            String s2 = TextUtil.trans("techguns.container.oredrill.drillrequired." + s1);
            int startx = this.field_146999_f / 2 - s2.length() * 6 / 2;
            int red = -57312;
            this.field_146289_q.func_78276_b(s2, startx - 16 + 30, 24, red);
        }
        if (OreDrillGui.isInRect(mx, my, 74, 16, 27, 39)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(String.format("%.2f", Float.valueOf((float)this.tile.progress * 1.0f / (float)this.tile.totaltime * 100.0f)) + "%");
            tooltip.add(TextUtil.trans("techguns.gui.oredrill.orehour") + ": " + String.format("%.2f", 1200.0 / (double)this.tile.totaltime * 60.0));
            if (this.tile.getPowerPerTick() > 0) {
                tooltip.add(TextUtil.trans("techguns.gui.oredrill.rftick") + ": " + this.tile.getPowerPerTick());
            }
            tooltip.add("");
            tooltip.add(TextUtil.trans("techguns.oredrill.drillsize") + ": " + (this.tile.getRods() + this.tile.getEngines()));
            tooltip.add(TextUtil.trans("techguns.oredrill.drillradius") + ": " + this.tile.getDrillRadius());
            this.func_146283_a(tooltip, mx, my);
        } else if (OreDrillGui.isInRect(mx, my, 15, 16, 11, 51)) {
            info = this.tile.inputTank.getInfo();
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(info.fluid != null ? info.fluid.getFluid().getLocalizedName(info.fluid) : TextUtil.trans("techguns.gui.empty"));
            tooltip.add(this.tile.inputTank.getFluidAmount() + "/" + info.capacity + "mB");
            this.func_146283_a(tooltip, mx, my);
        } else if (OreDrillGui.isInRect(mx, my, 157, 16, 11, 51)) {
            info = this.tile.outputTank.getInfo();
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(info.fluid != null ? info.fluid.getFluid().getLocalizedName(info.fluid) : TextUtil.trans("techguns.gui.empty"));
            tooltip.add(this.tile.outputTank.getFluidAmount() + "/" + info.capacity + "mB");
            this.func_146283_a(tooltip, mx, my);
        } else if (OreDrillGui.isInRect(mx, my, 34, 36, 8, 14)) {
            if (this.tile.getCurrentFuelBufferMax() > 0) {
                int buf = this.tile.getCurrentFuelBufferMax();
                int fuel = this.tile.getFuelBuffer();
                int pwrtick = this.tile.getPowerPerTick();
                float FACTOR = TGConfig.oreDrillMultiplierFuel;
                int ticksLeft = 0;
                ticksLeft = FACTOR <= 0.0f || pwrtick <= 0 ? -1 : (int)((float)fuel / ((float)pwrtick / FACTOR));
                ArrayList<String> tooltip = new ArrayList<String>(2);
                tooltip.add(TextUtil.trans("techguns.oredrill.currentfuel") + " " + fuel + "/" + buf);
                tooltip.add(TextUtil.trans("techguns.oredrill.remaining") + ": " + ticksLeft + " " + TextUtil.trans("techguns.oredrill.ticks"));
                this.func_146283_a(tooltip, mx, my);
            } else {
                this.func_146279_a(TextUtil.trans("techguns.oredrill.nofuel"), mx, my);
            }
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        TextureAtlasSprite tex;
        int px;
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        if (this.tile.inputTank.getFluidAmount() > 0) {
            px = this.tile.inputTank.getFluidAmount() * 50 / this.tile.inputTank.getCapacity();
            tex = this.field_146297_k.func_147117_R().getTextureExtry(this.tile.inputTank.getFluid().getFluid().getStill().toString());
            this.drawFluidWithTesselator(tex, k + 15 + 1, l + 17, 10, 50, px);
        }
        if (this.tile.outputTank.getFluidAmount() > 0) {
            px = this.tile.outputTank.getFluidAmount() * 50 / this.tile.outputTank.getCapacity();
            tex = this.field_146297_k.func_147117_R().getTextureExtry(this.tile.outputTank.getFluid().getFluid().getStill().toString());
            this.drawFluidWithTesselator(tex, k + 157 + 1, l + 17, 10, 50, px);
        }
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        this.func_73729_b(k + 15, l + 17, 176, 40, 12, 52);
        this.func_73729_b(k + 157, l + 17, 176, 40, 12, 52);
        if (this.tile.isWorking()) {
            int i1 = this.tile.getProgressScaled(36);
            this.func_73729_b(k + 73, l + 17, 177, 1, 25, i1 + 1);
        }
        if (this.tile.getCurrentFuelBufferMax() > 0) {
            int s = 12 - this.tile.getFuelBufferScaled(12);
            this.func_73729_b(k + 35, l + 36 + s, 188, 39 + s, 6, 12 - s);
        }
    }
}

