/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.additionalslots;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGItems;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.api.tginventory.TGSlotType;
import techguns.capabilities.TGExtendedPlayer;
import techguns.client.audio.TGSoundCategory;
import techguns.items.additionalslots.ItemTGSpecialSlotAmmo;
import techguns.items.armors.TGArmorBonus;
import techguns.packets.PacketPlaySound;
import techguns.packets.PacketSpawnParticle;
import techguns.packets.PacketSpawnParticleOnEntity;
import techguns.util.TextUtil;

public class ItemJumpPack
extends ItemTGSpecialSlotAmmo {
    private static int durPerUse = 1;
    private static final float JUMPBOOST = 0.8f;
    private static final float FREEHEIGHT = 8.0f;
    private static final float FALLDMG = 0.2f;

    public ItemJumpPack(String unlocalizedName, int camoCount, int dur) {
        super(unlocalizedName, TGSlotType.BACKSLOT, camoCount, dur, TGItems.COMPRESSED_AIR_TANK, TGItems.COMPRESSED_AIR_TANK_EMPTY);
    }

    @Override
    public void onPlayerTick(ItemStack item, TickEvent.PlayerTickEvent event) {
        if (item.func_77952_i() + durPerUse > item.func_77958_k()) {
            this.tryReloadAndRepair(item, event.player);
        }
    }

    @Override
    public float getBonus(TGArmorBonus type, ItemStack stack, boolean consume, EntityPlayer player) {
        if (type == TGArmorBonus.JUMP) {
            if (consume) {
                TGExtendedPlayer props = TGExtendedPlayer.get(player);
                if (props.enableJetpack) {
                    if (stack.func_77952_i() + durPerUse <= stack.func_77958_k()) {
                        stack.func_77964_b(stack.func_77952_i() + durPerUse);
                        if (!player.field_70170_p.field_72995_K) {
                            this.doJumpEffect(player);
                        }
                        return 0.8f;
                    }
                }
            } else if (stack.func_77952_i() + durPerUse <= stack.func_77958_k()) {
                return 0.8f;
            }
        } else if (type == TGArmorBonus.FREEHEIGHT) {
            if (stack.func_77952_i() < stack.func_77958_k()) {
                return 8.0f;
            }
        } else if (type == TGArmorBonus.FALLDMG) {
            if (consume) {
                TGExtendedPlayer props = TGExtendedPlayer.get(player);
                if (props.enableJetpack) {
                    if (stack.func_77952_i() + durPerUse <= stack.func_77958_k()) {
                        stack.func_77964_b(stack.func_77952_i() + durPerUse);
                        if (!player.field_70170_p.field_72995_K) {
                            this.doFallEffect(player);
                        }
                        return 0.2f;
                    }
                }
            } else if (stack.func_77952_i() < stack.func_77958_k()) {
                return 0.2f;
            }
        }
        return 0.0f;
    }

    public void doJumpEffect(EntityPlayer ply) {
        if (!ply.field_70170_p.field_72995_K) {
            NetworkRegistry.TargetPoint targetPoint = TGPackets.targetPointAroundEnt((Entity)ply, 50.0);
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticleOnEntity("JumpPackBoost", (Entity)ply), targetPoint);
            TGPackets.network.sendToAllAround((IMessage)new PacketPlaySound(TGSounds.STEAM_JUMP_2, (Entity)ply, 1.0f, 1.0f, false, true, false, true, TGSoundCategory.PLAYER_EFFECT), targetPoint);
        }
    }

    public void doFallEffect(EntityPlayer ply) {
        if (!ply.field_70170_p.field_72995_K) {
            TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("JumpPackFall", ply.field_70165_t, ply.field_70163_u, ply.field_70161_v), TGPackets.targetPointAroundEnt((Entity)ply, 50.0));
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(TextUtil.trans("techguns.armorTooltip.jumpheight") + ": +" + 0.8f);
        tooltip.add(TextUtil.trans("techguns.armorTooltip.falldamage") + ": -" + 20.0f + "%");
        tooltip.add(TextUtil.trans("techguns.armorTooltip.fallheight") + ": -" + 8.0f);
    }
}

