/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.guns;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import techguns.TGPackets;
import techguns.api.damagesystem.DamageType;
import techguns.api.render.IItemTGRenderer;
import techguns.client.audio.TGSoundCategory;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GrenadeProjectile;
import techguns.items.GenericItem;
import techguns.items.guns.GenericGun;
import techguns.items.guns.IGrenadeProjectileFactory;
import techguns.packets.PacketPlaySound;
import techguns.util.TextUtil;

public class GenericGrenade
extends GenericItem
implements IItemTGRenderer {
    private int maxUseDur;
    public float damage = 20.0f;
    public float radius = 3.0f;
    public int maxBounces = 3;
    public float damageMin = 10.0f;
    public float radiusMin = 5.0f;
    public float fullChargeTime = 30.0f;
    public int ticksToLive = 200;
    public float speed = 0.75f;
    public float spread = 0.1f;
    public float penetration = 0.0f;
    protected SoundEvent startSound = null;
    IGrenadeProjectileFactory<? extends GrenadeProjectile> projectile_factory;

    public GenericGrenade(String name, int stacksize, int maxUseDur, IGrenadeProjectileFactory<? extends GrenadeProjectile> projectile_factory) {
        super(name, false);
        this.func_77625_d(stacksize);
        this.setNoRepair();
        this.maxUseDur = maxUseDur;
        this.projectile_factory = projectile_factory;
    }

    public GenericGrenade setStartSound(SoundEvent sound) {
        this.startSound = sound;
        return this;
    }

    public GenericGrenade setDamageAndRadius(float damage, float radiusMax, float damageMin, float radiusMin) {
        this.damage = damage;
        this.radius = radiusMax;
        this.damageMin = damageMin;
        this.radiusMin = radiusMin;
        return this;
    }

    public GenericGrenade setMaxBounces(int maxBounces) {
        this.maxBounces = maxBounces;
        return this;
    }

    public GenericGrenade setFullChargeTime(float fullChargeTime) {
        this.fullChargeTime = fullChargeTime;
        return this;
    }

    public GenericGrenade setTicksToLive(int ticksToLive) {
        this.ticksToLive = ticksToLive;
        return this;
    }

    public GenericGrenade setSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    public GenericGrenade setSpread(float spread) {
        this.spread = spread;
        return this;
    }

    public GenericGrenade setPenetration(float penetration) {
        this.penetration = penetration;
        return this;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        if (!worldIn.field_72995_K && this.startSound != null) {
            TGPackets.network.sendToAllAround((IMessage)new PacketPlaySound(this.startSound, (Entity)playerIn, 1.0f, 1.0f, false, false, true, true, TGSoundCategory.PLAYER_EFFECT), TGPackets.targetPointAroundEnt((Entity)playerIn, 24.0));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        boolean leftHand;
        int j = this.func_77626_a(stack) - timeLeft;
        boolean bl = leftHand = entityLiving.func_184600_cs() == EnumHand.OFF_HAND;
        if (entityLiving.func_184591_cq() == EnumHandSide.LEFT) {
            leftHand = !leftHand;
        }
        EnumBulletFirePos firePos = leftHand ? EnumBulletFirePos.LEFT : EnumBulletFirePos.RIGHT;
        float f = (float)j / this.fullChargeTime;
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer ply = (EntityPlayer)entityLiving;
            if (!ply.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        if (!worldIn.field_72995_K) {
            this.spawnGrenade(worldIn, entityLiving, f, firePos);
        }
        entityLiving.func_184609_a(entityLiving.func_184600_cs());
    }

    public void spawnGrenade(World world, EntityLivingBase entityLiving, float charge, EnumBulletFirePos firePos) {
        float grav = 0.015f / charge;
        GrenadeProjectile proj = this.projectile_factory.createProjectile(world, entityLiving, this.damage, this.speed, this.ticksToLive, this.spread, this.radius, this.radiusMin, this.damageMin, this.penetration, GenericGun.getDoBlockDamage(entityLiving), firePos, this.radiusMin, grav, charge, this.maxBounces);
        world.func_72838_d((Entity)proj);
    }

    public int func_77626_a(ItemStack item) {
        return 72000;
    }

    protected DamageType getDamageType() {
        return DamageType.EXPLOSION;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextUtil.trans("techguns.gun.tooltip.damageType") + ": " + this.getDamageType().toString());
            tooltip.add(TextUtil.trans("techguns.gun.tooltip.damage") + ": " + this.damage);
            tooltip.add(TextUtil.trans("techguns.gun.tooltip.radius") + ": " + this.radius);
            tooltip.add(TextUtil.trans("techguns.gun.tooltip.bounces") + ": " + this.maxBounces);
        } else {
            tooltip.add(TextUtil.trans("techguns.gun.tooltip.damage") + ": " + this.damage);
            tooltip.add(TextUtil.trans("techguns.gun.tooltip.shift1") + " " + ChatFormatting.GREEN + TextUtil.trans("techguns.gun.tooltip.shift2") + " " + ChatFormatting.GRAY + TextUtil.trans("techguns.gun.tooltip.shift3"));
        }
    }
}

