/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.guns;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import techguns.TGItems;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.Techguns;
import techguns.api.damagesystem.DamageType;
import techguns.api.guns.GunHandType;
import techguns.api.guns.IGenericGun;
import techguns.api.render.IItemTGRenderer;
import techguns.capabilities.TGExtendedPlayer;
import techguns.client.ClientProxy;
import techguns.client.ShooterValues;
import techguns.client.audio.TGSoundCategory;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.entities.ai.EntityAIRangedAttack;
import techguns.entities.npcs.NPCTurret;
import techguns.entities.projectiles.EnumBulletFirePos;
import techguns.entities.projectiles.GenericProjectile;
import techguns.items.GenericItem;
import techguns.items.armors.GenericArmor;
import techguns.items.armors.ICamoChangeable;
import techguns.items.armors.TGArmorBonus;
import techguns.items.guns.EnumCrosshairStyle;
import techguns.items.guns.IProjectileFactory;
import techguns.items.guns.ProjectileSelector;
import techguns.items.guns.RangeTooltipType;
import techguns.items.guns.ammo.AmmoType;
import techguns.items.guns.ammo.AmmoTypes;
import techguns.items.guns.ammo.DamageModifier;
import techguns.packets.GunFiredMessage;
import techguns.packets.ReloadStartedMessage;
import techguns.plugins.crafttweaker.EnumGunStat;
import techguns.util.InventoryUtil;
import techguns.util.MathUtil;
import techguns.util.SoundUtil;
import techguns.util.TextUtil;

public class GenericGun
extends GenericItem
implements IGenericGun,
IItemTGRenderer,
ICamoChangeable {
    public static final float SOUND_DISTANCE = 4.0f;
    boolean semiAuto = false;
    int minFiretime = 4;
    int clipsize = 10;
    int reloadtime = 40;
    float damage = 2.0f;
    SoundEvent firesound = TGSounds.M4_FIRE;
    SoundEvent reloadsound = TGSounds.M4_RELOAD;
    SoundEvent firesoundStart = TGSounds.M4_FIRE;
    SoundEvent rechamberSound = null;
    int ammoCount;
    float zoomMult = 1.0f;
    boolean canZoom = false;
    boolean toggleZoom = false;
    boolean fireCenteredZoomed = false;
    int ticksToLive = 40;
    float speed = 2.0f;
    float damageMin = 1.0f;
    float damageDropStart = 20.0f;
    float damageDropEnd = 40.0f;
    float penetration = 0.0f;
    AmmoType ammoType = AmmoTypes.PISTOL_ROUNDS;
    boolean shotgun = false;
    boolean burst = false;
    float spread = 0.015f;
    int bulletcount = 7;
    float accuracy = 0.0f;
    float projectileForwardOffset = 0.0f;
    int maxLoopDelay = 0;
    int recoiltime = 5;
    int muzzleFlashtime = 5;
    boolean silenced = false;
    boolean checkRecoil = false;
    boolean checkMuzzleFlash = false;
    float AI_attackRange = 15.0f;
    int AI_attackTime = 60;
    int AI_burstCount = 0;
    int AI_burstAttackTime = 0;
    int camoCount = 1;
    int lockOnTicks = 0;
    int lockOnPersistTicks = 0;
    EnumCrosshairStyle crossHairStyle = EnumCrosshairStyle.GUN_DYNAMIC;
    public ArrayList<ResourceLocation> textures;
    protected ProjectileSelector projectile_selector;
    GunHandType handType = GunHandType.TWO_HANDED;
    int miningAmmoConsumption = 1;
    float meleeDamagePwr = 6.0f;
    float meleeDamageEmpty = 2.0f;
    float digSpeed = 1.0f;
    float zoombonus = 1.0f;
    float radius = 1.0f;
    double gravity = 0.0;
    boolean shootWithLeftClick = true;
    public float turretPosOffsetX = 0.0f;
    public float turretPosOffsetY = 0.0f;
    public float turretPosOffsetZ = 0.0f;
    public static ArrayList<GenericGun> guns = new ArrayList();
    public int light_lifetime = 2;
    public float light_radius_start = 3.0f;
    public float light_radius_end = 3.0f;
    public float light_r = 1.0f;
    public float light_g = 0.9f;
    public float light_b = 0.2f;
    protected boolean muzzelight = true;
    boolean hasAimedBowAnim = true;
    boolean hasAmbientEffect = false;
    public boolean hasCustomTexture = true;
    protected RangeTooltipType rangeTooltipType = RangeTooltipType.DROP;

    private GenericGun(String name) {
        super(name, false);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public GenericGun(String name, ProjectileSelector projectileSelector, boolean semiAuto, int minFiretime, int clipsize, int reloadtime, float damage, SoundEvent firesound, SoundEvent reloadsound, int TTL, float accuracy) {
        this(true, name, projectileSelector, semiAuto, minFiretime, clipsize, reloadtime, damage, firesound, reloadsound, TTL, accuracy);
    }

    public GenericGun setMuzzleLight(float r, float g, float b) {
        this.light_r = r;
        this.light_g = g;
        this.light_b = b;
        return this;
    }

    public GenericGun setNoMuzzleLight() {
        this.muzzelight = false;
        return this;
    }

    public GenericGun setMuzzleLight(int lifetime, float radius_start, float radius_end, float r, float g, float b) {
        this.light_lifetime = lifetime;
        this.light_radius_start = radius_start;
        this.light_radius_end = radius_end;
        this.setMuzzleLight(r, g, b);
        return this;
    }

    public GenericGun setRangeTooltipType(RangeTooltipType type) {
        this.rangeTooltipType = type;
        return this;
    }

    public GenericGun setHasAmbient() {
        this.hasAmbientEffect = true;
        return this;
    }

    public boolean hasAmbientEffect() {
        return this.hasAmbientEffect;
    }

    public GenericGun setNoCustomTexture() {
        this.hasCustomTexture = false;
        return this;
    }

    public GenericGun setNoBowAnim() {
        this.hasAimedBowAnim = false;
        return this;
    }

    public boolean hasBowAnim() {
        return this.hasAimedBowAnim;
    }

    public GenericGun(boolean addToGunList, String name, ProjectileSelector projectile_selector, boolean semiAuto, int minFiretime, int clipsize, int reloadtime, float damage, SoundEvent firesound, SoundEvent reloadsound, int TTL, float accuracy) {
        this(name);
        this.func_77656_e(clipsize);
        this.ammoType = projectile_selector.ammoType;
        this.semiAuto = semiAuto;
        this.minFiretime = minFiretime;
        this.clipsize = clipsize;
        this.reloadtime = reloadtime;
        this.damage = damage;
        this.firesound = firesound;
        this.reloadsound = reloadsound;
        this.ammoCount = 1;
        this.ticksToLive = TTL;
        this.accuracy = accuracy;
        this.damageDropStart = TTL;
        this.damageDropEnd = TTL;
        this.damageMin = damage;
        this.projectile_selector = projectile_selector;
        if (addToGunList) {
            guns.add(this);
        }
    }

    public GenericGun setGravity(double grav) {
        this.gravity = grav;
        return this;
    }

    public GenericGun setAmmoCount(int count) {
        this.ammoCount = count;
        return this;
    }

    public GenericGun setZoom(float mult, boolean toggle, float bonus, boolean fireCenteredWhileZooming) {
        this.canZoom = true;
        this.zoomMult = mult;
        this.toggleZoom = toggle;
        this.zoombonus = bonus;
        this.fireCenteredZoomed = fireCenteredWhileZooming;
        return this;
    }

    public GenericGun setShotgunSpred(int count, float spread) {
        return this.setShotgunSpread(count, spread, false);
    }

    public GenericGun setShotgunSpread(int count, float spread, boolean burst) {
        this.shotgun = true;
        this.spread = spread;
        this.bulletcount = count;
        this.burst = burst;
        return this;
    }

    public GenericGun setForwardOffset(float offset) {
        this.projectileForwardOffset = offset;
        return this;
    }

    public GenericGun setBulletSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    public GenericGun setPenetration(float pen) {
        this.penetration = pen;
        return this;
    }

    public GenericGun setMuzzleFlashTime(int time) {
        this.muzzleFlashtime = time;
        return this;
    }

    public GenericGun setFiresoundStart(SoundEvent firesoundStart) {
        this.firesoundStart = firesoundStart;
        return this;
    }

    public GenericGun setMaxLoopDelay(int maxLoopDelay) {
        this.maxLoopDelay = maxLoopDelay;
        return this;
    }

    public GenericGun setRecoiltime(int recoiltime) {
        this.recoiltime = recoiltime;
        return this;
    }

    public GenericGun setRechamberSound(SoundEvent rechamberSound) {
        this.rechamberSound = rechamberSound;
        return this;
    }

    public GenericGun setTurretPosOffset(float x, float y, float z) {
        this.turretPosOffsetX = x;
        this.turretPosOffsetY = y;
        this.turretPosOffsetZ = z;
        return this;
    }

    protected int getScaledTTL() {
        return (int)Math.ceil((float)this.ticksToLive / this.speed);
    }

    public GenericGun setLockOn(int ticks, int lockExtraTicks) {
        this.lockOnTicks = ticks;
        this.lockOnPersistTicks = lockExtraTicks;
        return this;
    }

    public int getLockOnTicks() {
        return this.lockOnTicks;
    }

    public int getLockOnPersistTicks() {
        return this.lockOnPersistTicks;
    }

    public boolean gunSecondaryAction(EntityPlayer player, ItemStack stack) {
        if (player.field_70170_p.field_72995_K && this.canZoom && this.toggleZoom && !ShooterValues.getPlayerIsReloading((EntityLivingBase)player, false)) {
            ClientProxy cp = ClientProxy.get();
            cp.player_zoom = cp.player_zoom != 1.0f ? 1.0f : this.zoomMult;
            return true;
        }
        return false;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (this.shootWithLeftClick) {
            return true;
        }
        return this.getCurrentAmmo(stack) >= this.miningAmmoConsumption;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        this.gunSecondaryAction(playerIn, playerIn.func_184586_b(handIn));
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public ItemStack[] getReloadItem(ItemStack stack) {
        return this.ammoType.getAmmo(this.getCurrentAmmoVariant(stack));
    }

    public int getAmmoCount() {
        return this.ammoCount;
    }

    public int getAmmoLeftCountTooltip(ItemStack item) {
        int ammo = this.getCurrentAmmo(item);
        if (this.burst) {
            return ammo * (this.bulletcount + 1);
        }
        return ammo;
    }

    public int getClipsizeTooltip() {
        if (this.burst) {
            return this.clipsize * (this.bulletcount + 1);
        }
        return this.clipsize;
    }

    public int getAmmoLeftCount(int mags) {
        int count = this.clipsize / this.ammoCount * mags;
        if (this.burst) {
            return count * (this.bulletcount + 1);
        }
        return count;
    }

    protected void spawnProjectile(World world, EntityLivingBase player, ItemStack itemstack, float spread, float offset, float damagebonus, EnumBulletFirePos firePos, Entity target) {
        IProjectileFactory projectile = this.projectile_selector.getFactoryForType(this.getCurrentAmmoVariantKey(itemstack));
        Object proj = projectile.createProjectile(this, world, player, this.damage * damagebonus, this.speed, this.getScaledTTL(), spread, this.damageDropStart, this.damageDropEnd, this.damageMin * damagebonus, this.penetration, GenericGun.getDoBlockDamage(player), firePos, this.radius, this.gravity);
        float f = 1.0f;
        if (this.muzzelight) {
            Techguns.proxy.createLightPulse(((GenericProjectile)((Object)proj)).field_70165_t + player.func_70040_Z().field_72450_a * (double)f, ((GenericProjectile)((Object)proj)).field_70163_u + player.func_70040_Z().field_72448_b * (double)f, ((GenericProjectile)((Object)proj)).field_70161_v + player.func_70040_Z().field_72449_c * (double)f, this.light_lifetime, this.light_radius_start, this.light_radius_end, this.light_r, this.light_g, this.light_b);
        }
        if (this.silenced) {
            ((GenericProjectile)((Object)proj)).setSilenced();
        }
        if (offset > 0.0f) {
            ((GenericProjectile)((Object)proj)).shiftForward(offset / this.speed);
        }
        world.func_72838_d(proj);
    }

    public static boolean getDoBlockDamage(EntityLivingBase elb) {
        TGExtendedPlayer caps;
        boolean blockdamage = false;
        if (elb instanceof EntityPlayer && (caps = TGExtendedPlayer.get((EntityPlayer)elb)) != null) {
            blockdamage = !caps.enableSafemode;
        }
        return blockdamage;
    }

    @Override
    public boolean isShootWithLeftClick() {
        return this.shootWithLeftClick;
    }

    @Override
    public boolean isSemiAuto() {
        return this.semiAuto;
    }

    public GenericGun setCheckRecoil() {
        this.checkRecoil = true;
        return this;
    }

    public GenericGun setCheckMuzzleFlash() {
        this.checkMuzzleFlash = true;
        return this;
    }

    @Override
    public boolean isZooming() {
        return ClientProxy.get().player_zoom == this.zoomMult;
    }

    @Override
    public void shootGunPrimary(ItemStack stack, World world, EntityPlayer player, boolean zooming, EnumHand hand, Entity target) {
        int ammo = this.getCurrentAmmo(stack);
        byte ATTACK_TYPE = 0;
        TGExtendedPlayer extendedPlayer = TGExtendedPlayer.get(player);
        if (ammo > 0) {
            int firedelay = extendedPlayer.getFireDelay(hand);
            if (firedelay <= 0) {
                extendedPlayer.setFireDelay(hand, this.minFiretime);
                if (!player.field_71075_bZ.field_75098_d) {
                    this.useAmmo(stack, 1);
                }
                if (!world.field_72995_K) {
                    float accuracybonus = MathUtil.clamp(1.0f - GenericArmor.getArmorBonusForPlayer(player, TGArmorBonus.GUN_ACCURACY, false), 0.0f, 1.0f);
                    if (hand == EnumHand.MAIN_HAND && player.func_184585_cz()) {
                        accuracybonus = this.handType == GunHandType.ONE_HANDED ? (accuracybonus *= 4.0f) : (accuracybonus *= 8.0f);
                    }
                    EnumBulletFirePos firePos = hand == EnumHand.MAIN_HAND && player.func_184591_cq() == EnumHandSide.RIGHT || hand == EnumHand.OFF_HAND && player.func_184591_cq() == EnumHandSide.LEFT ? EnumBulletFirePos.RIGHT : EnumBulletFirePos.LEFT;
                    if (zooming) {
                        accuracybonus *= this.zoombonus;
                        if (this.fireCenteredZoomed) {
                            firePos = EnumBulletFirePos.CENTER;
                        }
                    }
                    this.shootGun(world, (EntityLivingBase)player, stack, accuracybonus, 1.0f, ATTACK_TYPE, hand, firePos, target);
                } else {
                    int recoiltime_l = (int)((float)this.recoiltime / 20.0f * 1000.0f);
                    int muzzleFlashtime_l = (int)((float)this.muzzleFlashtime / 20.0f * 1000.0f);
                    if (!this.checkRecoil || !ShooterValues.isStillRecoiling((EntityLivingBase)player, hand == EnumHand.OFF_HAND, ATTACK_TYPE)) {
                        ShooterValues.setRecoiltime((EntityLivingBase)player, hand == EnumHand.OFF_HAND, System.currentTimeMillis() + (long)recoiltime_l, recoiltime_l, ATTACK_TYPE);
                    }
                    ClientProxy cp = ClientProxy.get();
                    if (!this.checkMuzzleFlash || ShooterValues.getMuzzleFlashTime((EntityLivingBase)player, hand == EnumHand.OFF_HAND) <= System.currentTimeMillis()) {
                        ShooterValues.setMuzzleFlashTime((EntityLivingBase)player, hand == EnumHand.OFF_HAND, System.currentTimeMillis() + (long)muzzleFlashtime_l, muzzleFlashtime_l);
                        Random rand = world.field_73012_v;
                        cp.muzzleFlashJitterX = 1.0f - rand.nextFloat() * 2.0f;
                        cp.muzzleFlashJitterY = 1.0f - rand.nextFloat() * 2.0f;
                        cp.muzzleFlashJitterScale = 1.0f - rand.nextFloat() * 2.0f;
                        cp.muzzleFlashJitterAngle = 1.0f - rand.nextFloat() * 2.0f;
                    }
                    this.client_weaponFired();
                }
                if (this.maxLoopDelay > 0 && extendedPlayer.getLoopSoundDelay(hand) <= 0) {
                    SoundUtil.playSoundOnEntityGunPosition(world, (Entity)player, this.firesoundStart, 4.0f, 1.0f, false, false, TGSoundCategory.GUN_FIRE);
                    extendedPlayer.setLoopSoundDelay(hand, this.maxLoopDelay);
                } else {
                    SoundUtil.playSoundOnEntityGunPosition(world, (Entity)player, this.firesound, 4.0f, 1.0f, false, false, TGSoundCategory.GUN_FIRE);
                    if (this.maxLoopDelay > 0) {
                        extendedPlayer.setLoopSoundDelay(hand, this.maxLoopDelay);
                    }
                }
                if (this.rechamberSound != null) {
                    SoundUtil.playSoundOnEntityGunPosition(world, (Entity)player, this.rechamberSound, 1.0f, 1.0f, false, false, TGSoundCategory.RELOAD);
                }
            }
        } else if (InventoryUtil.consumeAmmoPlayer(player, this.ammoType.getAmmo(this.getCurrentAmmoVariant(stack)))) {
            Arrays.stream(this.ammoType.getEmptyMag()).forEach(e -> {
                int amount;
                if (!e.func_190926_b() && (amount = InventoryUtil.addAmmoToPlayerInventory(player, TGItems.newStack(e, 1))) > 0 && !world.field_72995_K) {
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, TGItems.newStack(e, amount)));
                }
            });
            if (world.field_72995_K && this.canZoom && this.toggleZoom) {
                ClientProxy cp = ClientProxy.get();
                if (cp.player_zoom != 1.0f) {
                    cp.player_zoom = 1.0f;
                }
            }
            extendedPlayer.setFireDelay(hand, this.reloadtime - this.minFiretime);
            if (this.ammoCount > 1) {
                int i;
                for (i = 1; i < this.ammoCount && InventoryUtil.consumeAmmoPlayer(player, this.ammoType.getAmmo(this.getCurrentAmmoVariant(stack))); ++i) {
                }
                this.reloadAmmo(stack, i);
            } else {
                this.reloadAmmo(stack);
            }
            SoundUtil.playReloadSoundOnEntity(world, (Entity)player, this.reloadsound, 1.0f, 1.0f, false, true, TGSoundCategory.RELOAD);
            if (world.field_72995_K) {
                int time = (int)((float)this.reloadtime / 20.0f * 1000.0f);
                ShooterValues.setReloadtime((EntityLivingBase)player, hand == EnumHand.OFF_HAND, System.currentTimeMillis() + (long)time, time, ATTACK_TYPE);
                this.client_startReload();
            } else {
                int msg_reloadtime = (int)((float)this.reloadtime / 20.0f * 1000.0f);
                TGPackets.network.sendToAllAround((IMessage)new ReloadStartedMessage((EntityLivingBase)player, hand, msg_reloadtime, ATTACK_TYPE), TGPackets.targetPointAroundEnt((Entity)player, 100.0));
            }
        } else if (!world.field_72995_K) {
            // empty if block
        }
    }

    protected void client_weaponFired() {
    }

    protected void client_startReload() {
    }

    public GenericGun setAIStats(float attackRange, int attackTime, int burstCount, int burstAttackTime) {
        this.AI_attackRange = attackRange;
        this.AI_attackTime = attackTime;
        this.AI_burstCount = burstCount;
        this.AI_burstAttackTime = burstAttackTime;
        return this;
    }

    public GenericGun setTexture(String path) {
        return this.setTextures(path, 1);
    }

    public GenericGun setTextures(String path, int variations) {
        Techguns.proxy.setGunTextures(this, path, variations);
        this.camoCount = variations;
        return this;
    }

    public GenericGun setTexture(ResourceLocation path) {
        return this.setTextures(path, 1);
    }

    public GenericGun setTextures(ResourceLocation path, int variations) {
        Techguns.proxy.setGunTextures(this, path, variations);
        this.camoCount = variations;
        return this;
    }

    @Override
    public ResourceLocation getCurrentTexture(ItemStack stack) {
        int camo = this.getCurrentCamoIndex(stack);
        if (camo < this.textures.size()) {
            return this.textures.get(camo);
        }
        return this.textures.get(0);
    }

    protected void shootGun(World world, EntityLivingBase player, ItemStack itemstack, float accuracybonus, float damagebonus, int attackType, EnumHand hand, EnumBulletFirePos firePos, Entity target) {
        if (!world.field_72995_K) {
            int msg_recoiltime = (int)((float)this.recoiltime / 20.0f * 1000.0f);
            int msg_muzzleflashtime = (int)((float)this.muzzleFlashtime / 20.0f * 1000.0f);
            TGPackets.network.sendToAllAround((IMessage)new GunFiredMessage(player, msg_recoiltime, msg_muzzleflashtime, attackType, this.checkRecoil, hand == EnumHand.OFF_HAND), TGPackets.targetPointAroundEnt((Entity)player, 100.0));
        }
        this.spawnProjectile(world, player, itemstack, this.accuracy * accuracybonus, this.projectileForwardOffset, damagebonus, firePos, target);
        if (this.shotgun) {
            float offset = 0.0f;
            if (this.burst) {
                offset = this.speed / (float)this.bulletcount;
            }
            for (int i = 0; i < this.bulletcount; ++i) {
                this.spawnProjectile(world, player, itemstack, this.spread * accuracybonus, this.projectileForwardOffset + offset * ((float)i + 1.0f), damagebonus, firePos, target);
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            stack.func_77982_d(tags);
            int dmg = stack.func_77952_i();
            tags.func_74774_a("camo", (byte)0);
            tags.func_74778_a("ammovariant", "default");
            tags.func_74777_a("ammo", dmg == 0 ? (short)this.clipsize : (short)(this.clipsize - dmg));
            stack.func_77964_b(0);
            this.addInitialTags(tags);
        } else {
            stack.func_77964_b(0);
        }
    }

    protected void addInitialTags(NBTTagCompound tags) {
    }

    public int getCurrentAmmo(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            this.func_77622_d(stack, null, null);
            tags = stack.func_77978_p();
        }
        return tags.func_74765_d("ammo");
    }

    public int getCurrentAmmoVariant(ItemStack stack) {
        String variant = this.getCurrentAmmoVariantKey(stack);
        return this.getAmmoType().getIDforVariantKey(variant);
    }

    public String getCurrentAmmoVariantKey(ItemStack stack) {
        String var;
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            this.func_77622_d(stack, null, null);
            tags = stack.func_77978_p();
        }
        if ((var = tags.func_74779_i("ammovariant")) == null || var.equals("")) {
            return "default";
        }
        return var;
    }

    public int useAmmo(ItemStack stack, int amount) {
        int ammo = this.getCurrentAmmo(stack);
        NBTTagCompound tags = stack.func_77978_p();
        if (ammo - amount >= 0) {
            tags.func_74777_a("ammo", (short)(ammo - amount));
            return amount;
        }
        tags.func_74777_a("ammo", (short)0);
        return ammo;
    }

    public void reloadAmmo(ItemStack stack) {
        this.reloadAmmo(stack, this.clipsize);
    }

    public void reloadAmmo(ItemStack stack, int amount) {
        int ammo = this.getCurrentAmmo(stack);
        NBTTagCompound tags = stack.func_77978_p();
        tags.func_74777_a("ammo", (short)(ammo + amount));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack gun = new ItemStack((Item)this, 1, 0);
            this.func_77622_d(gun, null, null);
            items.add((Object)gun);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getPercentAmmoLeft(stack);
    }

    public double getPercentAmmoLeft(ItemStack stack) {
        return (double)this.getCurrentAmmo(stack) / (double)this.clipsize;
    }

    @Override
    public int getAmmoLeft(ItemStack stack) {
        return this.getCurrentAmmo(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !oldStack.func_77969_a(newStack);
    }

    public GenericGun setDamageDrop(float start, float end, float minDamage) {
        this.damageDropStart = start;
        this.damageDropEnd = end;
        this.damageMin = minDamage;
        return this;
    }

    public GenericGun setSilenced(boolean s) {
        this.silenced = s;
        return this;
    }

    @Override
    public GunHandType getGunHandType() {
        return this.handType;
    }

    public GenericGun setHandType(GunHandType type) {
        this.handType = type;
        return this;
    }

    @Override
    public boolean isHoldZoom() {
        return !this.toggleZoom;
    }

    @Override
    public float getZoomMult() {
        return this.zoomMult;
    }

    protected String getTooltipTextDmg(ItemStack stack, boolean expanded) {
        DamageModifier mod = this.projectile_selector.getFactoryForType(this.getCurrentAmmoVariantKey(stack)).getDamageModifier();
        float dmg = mod.getDamage(this.damage);
        if (dmg == this.damage) {
            return "" + this.damage + (this.damageMin < this.damage ? "-" + this.damageMin : "");
        }
        float dmgmin = mod.getDamage(this.damageMin);
        ChatFormatting prefix = ChatFormatting.GREEN;
        String sgn = "+";
        if (dmg < this.damage) {
            prefix = ChatFormatting.RED;
            sgn = "-";
        }
        String suffix = "";
        if (expanded) {
            if (mod.getDmgMul() != 1.0f) {
                float f = mod.getDmgMul() - 1.0f;
                String x = String.format("%.0f", Float.valueOf(f * 100.0f));
                suffix = suffix + " (" + sgn + x + "%)";
            }
            if (mod.getDmgAdd() != 0.0f) {
                float add = mod.getDmgAdd();
                suffix = suffix + " (" + (add > 0.0f ? "+" : "") + String.format("%.1f", Float.valueOf(add)) + ")";
            }
        }
        String sd = String.format("%.1f", Float.valueOf(dmg));
        String sm = String.format("%.1f", Float.valueOf(dmgmin));
        return prefix + "" + sd + (dmgmin < dmg ? "-" + sm : "") + suffix;
    }

    protected String getTooltipTextRange(ItemStack stack) {
        DamageModifier mod = this.projectile_selector.getFactoryForType(this.getCurrentAmmoVariantKey(stack)).getDamageModifier();
        int ttl = mod.getTTL(this.ticksToLive);
        float rangeStart = mod.getRange(this.damageDropStart);
        float rangeEnd = mod.getRange(this.damageDropEnd);
        String prefix = "";
        String suffix = "";
        if (rangeStart != this.damageDropStart) {
            String sgn = "+";
            if (rangeStart > this.damageDropStart) {
                prefix = ChatFormatting.GREEN.toString();
            } else {
                prefix = ChatFormatting.RED.toString();
                sgn = "-";
            }
            if (mod.getRangeMul() != 1.0f) {
                float f = mod.getRangeMul() - 1.0f;
                String x = String.format("%.0f", Float.valueOf(f * 100.0f));
                suffix = suffix + " (" + sgn + x + "%)";
            }
            if (mod.getRangeAdd() != 0.0f) {
                float add = mod.getRangeAdd();
                suffix = suffix + " (" + (add > 0.0f ? "+" : "") + String.format("%.1f", Float.valueOf(add)) + ")";
            }
        }
        String sStart = String.format("%.1f", Float.valueOf(rangeStart));
        String sEnd = String.format("%.1f", Float.valueOf(rangeEnd));
        if (this.rangeTooltipType == RangeTooltipType.DROP) {
            return TextUtil.trans("techguns.gun.tooltip.range") + ": " + prefix + sStart + "," + sEnd + "," + ttl + suffix;
        }
        if (this.rangeTooltipType == RangeTooltipType.NO_DROP) {
            return TextUtil.trans("techguns.gun.tooltip.range") + ": " + prefix + sStart + suffix;
        }
        return TextUtil.trans("techguns.gun.tooltip.radius") + ": " + prefix + sStart + "-" + sEnd + suffix;
    }

    protected String getTooltipTextVelocity(ItemStack stack) {
        DamageModifier mod = this.projectile_selector.getFactoryForType(this.getCurrentAmmoVariantKey(stack)).getDamageModifier();
        float velocity = mod.getVelocity(this.speed);
        String prefix = "";
        String suffix = "";
        if (velocity != this.speed) {
            String sgn = "+";
            if (velocity >= this.speed) {
                prefix = ChatFormatting.GREEN.toString();
            } else {
                prefix = ChatFormatting.RED.toString();
                sgn = "";
            }
            if (mod.getVelocityMul() != 1.0f) {
                float f = mod.getVelocityMul() - 1.0f;
                String x = String.format("%.0f", Float.valueOf(f * 100.0f));
                suffix = suffix + " (" + sgn + x + "%)";
            }
            if (mod.getVelocityAdd() != 0.0f) {
                float add = mod.getVelocityAdd();
                suffix = suffix + " (" + (add > 0.0f ? "+" : "") + String.format("%.1f", Float.valueOf(add)) + ")";
            }
        }
        String sVelocity = String.format("%.1f", Float.valueOf(velocity));
        return TextUtil.trans("techguns.gun.tooltip.velocity") + ": " + prefix + sVelocity + suffix;
    }

    protected void addMiningTooltip(ItemStack stack, World world, List<String> list, ITooltipFlag flagIn, boolean longTooltip) {
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, list, flagIn);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextUtil.trans("techguns.gun.tooltip.handtype") + ": " + this.getGunHandType().toString());
            ItemStack[] ammo = this.ammoType.getAmmo(this.getCurrentAmmoVariant(stack));
            for (int i = 0; i < ammo.length; ++i) {
                list.add(TextUtil.trans("techguns.gun.tooltip.ammo") + ": " + (this.ammoCount > 1 ? this.ammoCount + "x " : "") + ChatFormatting.WHITE + TextUtil.trans(ammo[i].func_77977_a() + ".name"));
            }
            this.addMiningTooltip(stack, worldIn, list, flagIn, true);
            list.add(TextUtil.trans("techguns.gun.tooltip.damageType") + ": " + this.getDamageType(stack).toString());
            list.add(TextUtil.trans("techguns.gun.tooltip.damage") + (this.shotgun ? "(x" + (this.bulletcount + 1) + ")" : "") + ": " + this.getTooltipTextDmg(stack, true));
            list.add(this.getTooltipTextRange(stack));
            list.add(this.getTooltipTextVelocity(stack));
            list.add(TextUtil.trans("techguns.gun.tooltip.spread") + ": " + this.accuracy + ((double)this.zoombonus != 1.0 ? " Z:" + this.zoombonus * this.accuracy : ""));
            list.add(TextUtil.trans("techguns.gun.tooltip.clipsize") + ": " + this.clipsize);
            list.add(TextUtil.trans("techguns.gun.tooltip.reloadTime") + ": " + (float)this.reloadtime * 0.05f + "s");
            if (this.penetration > 0.0f) {
                list.add(TextUtil.trans("techguns.gun.tooltip.armorPen") + ": " + String.format("%.1f", Float.valueOf(this.penetration)));
            }
            if (this.canZoom) {
                list.add(TextUtil.trans("techguns.gun.tooltip.zoom") + ":" + (this.toggleZoom ? "(" + TextUtil.trans("techguns.gun.tooltip.zoom.toogle") + ")" : "(" + TextUtil.trans("techguns.gun.tooltip.zoom.hold") + ")") + " " + TextUtil.trans("techguns.gun.tooltip.zoom.multiplier") + ":" + this.zoomMult);
            }
        } else {
            ItemStack[] ammo = this.ammoType.getAmmo(this.getCurrentAmmoVariant(stack));
            for (int i = 0; i < ammo.length; ++i) {
                list.add(TextUtil.trans("techguns.gun.tooltip.ammo") + ": " + (this.ammoCount > 1 ? this.ammoCount + "x " : "") + ChatFormatting.WHITE + TextUtil.trans(ammo[i].func_77977_a() + ".name"));
            }
            this.addMiningTooltip(stack, worldIn, list, flagIn, false);
            list.add(TextUtil.trans("techguns.gun.tooltip.damage") + (this.shotgun ? "(x" + (this.bulletcount + 1) + ")" : "") + ": " + this.getTooltipTextDmg(stack, false));
            list.add(TextUtil.trans("techguns.gun.tooltip.shift1") + " " + ChatFormatting.GREEN + TextUtil.trans("techguns.gun.tooltip.shift2") + " " + ChatFormatting.GRAY + TextUtil.trans("techguns.gun.tooltip.shift3"));
        }
    }

    public DamageType getDamageType(ItemStack stack) {
        return this.projectile_selector.getFactoryForType(this.getCurrentAmmoVariantKey(stack)).getDamageType();
    }

    @Override
    public int getCamoCount() {
        return this.camoCount;
    }

    @Override
    public String getCurrentCamoName(ItemStack item) {
        NBTTagCompound tags = item.func_77978_p();
        int camoID = 0;
        if (tags != null && tags.func_74764_b("camo")) {
            camoID = tags.func_74771_c("camo");
        }
        if (camoID > 0) {
            return TextUtil.trans(this.func_77658_a() + ".camoname." + camoID);
        }
        return TextUtil.trans("techguns.item.defaultcamo");
    }

    public GenericGun setShootWithLeftClick(boolean shootWithLeftClick) {
        this.shootWithLeftClick = shootWithLeftClick;
        return this;
    }

    public GenericGun setMiningAmmoConsumption(int ammo) {
        this.miningAmmoConsumption = ammo;
        return this;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity targetEntity) {
        if (this.shootWithLeftClick) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            int time = (int)((float)this.recoiltime / 20.0f * 1000.0f);
            ShooterValues.setRecoiltime((EntityLivingBase)player, false, System.currentTimeMillis() + (long)time, time, (byte)0);
        }
        if (targetEntity.func_70075_an() && GenericProjectile.BULLET_TARGETS.apply((Object)targetEntity) && !targetEntity.func_85031_j((Entity)player)) {
            float f = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            float f1 = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)player.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)player.func_184614_ca(), (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            float f2 = player.func_184825_o(0.5f);
            f1 *= f2;
            player.func_184821_cY();
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                int i = 0;
                i += EnchantmentHelper.func_77501_a((EntityLivingBase)player);
                if (player.func_70051_ag() && flag) {
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187721_dT, player.func_184176_by(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                boolean flag2 = flag && player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(MobEffects.field_76440_q) && !player.func_184218_aH() && targetEntity instanceof EntityLivingBase;
                boolean bl = flag2 = flag2 && !player.func_70051_ag();
                if (flag2) {
                    f *= 1.5f;
                }
                f += f1;
                boolean flag3 = false;
                double d0 = player.field_70140_Q - player.field_70141_P;
                if (flag && !flag2 && !flag1 && player.field_70122_E && d0 < (double)player.func_70689_ay()) {
                    ItemStack itemstack = player.func_184586_b(EnumHand.MAIN_HAND);
                    flag3 = this.hasSwordSweep() && this.getAmmoLeft(stack) > 0;
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.func_90036_a((EntityLivingBase)player);
                if (targetEntity instanceof EntityLivingBase) {
                    f4 = ((EntityLivingBase)targetEntity).func_110143_aJ();
                    if (j > 0 && !targetEntity.func_70027_ad()) {
                        flag4 = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                double d1 = targetEntity.field_70159_w;
                double d2 = targetEntity.field_70181_x;
                double d3 = targetEntity.field_70179_y;
                TGDamageSource src = this.getMeleeDamageSource(player, stack);
                targetEntity.func_70097_a((DamageSource)src, f);
                boolean flag5 = src.wasSuccessful();
                if (flag5) {
                    IEntityMultiPart ientitymultipart;
                    this.consumeAmmoOnMeleeHit((EntityLivingBase)player, stack);
                    if (i > 0) {
                        if (targetEntity instanceof EntityLivingBase) {
                            ((EntityLivingBase)targetEntity).func_70653_a((Entity)player, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f));
                        }
                        player.field_70159_w *= 0.6;
                        player.field_70179_y *= 0.6;
                        player.func_70031_b(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + EnchantmentHelper.func_191527_a((EntityLivingBase)player) * f;
                        for (EntityLivingBase entitylivingbase : player.field_70170_p.func_72872_a(EntityLivingBase.class, targetEntity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                            if (entitylivingbase == player || entitylivingbase == targetEntity || player.func_184191_r((Entity)entitylivingbase) || !(player.func_70068_e((Entity)entitylivingbase) < 9.0)) continue;
                            entitylivingbase.func_70653_a((Entity)player, 0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                            TGDamageSource dmgsrc = this.getMeleeDamageSource(player, stack);
                            entitylivingbase.func_70097_a((DamageSource)dmgsrc, f3);
                            if (!dmgsrc.wasSuccessful()) continue;
                            this.onMeleeHitTarget(stack, (Entity)entitylivingbase);
                        }
                        this.doSweepAttackEffect(player);
                    }
                    this.onMeleeHitTarget(stack, targetEntity);
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                        ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.field_70159_w = d1;
                        targetEntity.field_70181_x = d2;
                        targetEntity.field_70179_y = d3;
                    }
                    if (flag2) {
                        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187718_dS, player.func_184176_by(), 1.0f, 1.0f);
                        player.func_71009_b(targetEntity);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, player.func_184176_by(), 1.0f, 1.0f);
                        } else {
                            player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187733_dX, player.func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        player.func_71047_c(targetEntity);
                    }
                    player.func_130011_c(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)player);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)targetEntity);
                    ItemStack itemstack1 = player.func_184614_ca();
                    Entity entity = targetEntity;
                    if (targetEntity instanceof MultiPartEntityPart && (ientitymultipart = ((MultiPartEntityPart)targetEntity).field_70259_a) instanceof EntityLivingBase) {
                        entity = (EntityLivingBase)ientitymultipart;
                    }
                    if (!itemstack1.func_190926_b() && entity instanceof EntityLivingBase) {
                        ItemStack beforeHitCopy = itemstack1.func_77946_l();
                        itemstack1.func_77961_a((EntityLivingBase)entity, player);
                        if (itemstack1.func_190926_b()) {
                            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)beforeHitCopy, (EnumHand)EnumHand.MAIN_HAND);
                            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (targetEntity instanceof EntityLivingBase) {
                        float f5 = f4 - ((EntityLivingBase)targetEntity).func_110143_aJ();
                        player.func_71064_a(StatList.field_188111_y, Math.round(f5 * 10.0f));
                        if (j > 0) {
                            targetEntity.func_70015_d(j * 4);
                        }
                        if (player.field_70170_p instanceof WorldServer && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((WorldServer)player.field_70170_p).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)(targetEntity.field_70131_O * 0.5f), targetEntity.field_70161_v, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                        }
                    }
                    player.func_71020_j(0.1f);
                } else {
                    player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187724_dU, player.func_184176_by(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.func_70066_B();
                    }
                }
            }
        }
        return true;
    }

    protected void onMeleeHitTarget(ItemStack stack, Entity target) {
    }

    protected void consumeAmmoOnMeleeHit(EntityLivingBase elb, ItemStack stack) {
        if (elb instanceof EntityPlayer) {
            EntityPlayer ply = (EntityPlayer)elb;
            if (ply.field_71075_bZ.field_75098_d) {
                return;
            }
        }
        this.useAmmo(stack, 1);
    }

    protected void doSweepAttackEffect(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            double d0 = -MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180)));
            double d1 = MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)));
            double x = player.field_70165_t + d0;
            double y = player.field_70163_u + (double)player.field_70131_O * 0.8;
            double z = player.field_70161_v + d1;
            this.spawnSweepParticle(player.field_70170_p, x, y, z, d0, 0.0, d1);
            this.playSweepSoundEffect(player);
        }
    }

    protected void playSweepSoundEffect(EntityPlayer player) {
        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
    }

    protected void spawnSweepParticle(World w, double x, double y, double z, double motionX, double motionY, double motionZ) {
    }

    protected TGDamageSource getMeleeDamageSource(EntityPlayer player, ItemStack stack) {
        TGDamageSource src = new TGDamageSource("player", (Entity)player, (Entity)player, DamageType.PHYSICAL, EntityDeathUtils.DeathType.GORE);
        return src;
    }

    protected boolean hasSwordSweep() {
        return true;
    }

    public int getMiningAmmoConsumption() {
        return this.miningAmmoConsumption;
    }

    @Override
    public boolean isModelBase(ItemStack stack) {
        return this.hasCustomTexture;
    }

    public EntityAIRangedAttack getAIAttack(IRangedAttackMob shooter) {
        return new EntityAIRangedAttack(shooter, 1.0, this.AI_attackTime / 3, this.AI_attackTime, this.AI_attackRange, this.AI_burstCount, this.AI_burstAttackTime);
    }

    public AmmoType getAmmoType() {
        return this.ammoType;
    }

    public float getAI_attackRange() {
        return this.AI_attackRange;
    }

    public boolean isFullyLoaded(ItemStack stack) {
        return this.clipsize == this.getCurrentAmmo(stack);
    }

    public boolean hasRightClickAction() {
        return this.getGunHandType() == GunHandType.TWO_HANDED && this.canZoom;
    }

    public void fireWeaponFromNPC(EntityLivingBase shooter, float dmgscale, float accscale) {
        SoundUtil.playSoundOnEntityGunPosition(shooter.field_70170_p, (Entity)shooter, this.firesound, 4.0f, 1.0f, false, false, TGSoundCategory.GUN_FIRE);
        EnumBulletFirePos firePos = EnumBulletFirePos.RIGHT;
        if (shooter instanceof NPCTurret) {
            firePos = EnumBulletFirePos.CENTER;
        }
        if (!shooter.field_70170_p.field_72995_K) {
            this.shootGun(shooter.field_70170_p, shooter, shooter.func_184614_ca(), this.zoombonus * accscale, dmgscale, 0, EnumHand.MAIN_HAND, firePos, null);
        }
    }

    public List<ItemStack> getAmmoOnUnload(ItemStack stack) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int ammo = this.getCurrentAmmo(stack);
        if (this.ammoCount > 1 && this.getAmmoLeft(stack) > 0) {
            for (ItemStack s : this.getAmmoType().getBullet(this.getCurrentAmmoVariant(stack))) {
                items.add(TGItems.newStack(s, this.getAmmoLeft(stack)));
            }
        } else if (!this.isFullyLoaded(stack)) {
            int amount = this.ammoType.getEmptyMag().length;
            for (int i = 0; i < amount; ++i) {
                int bulletsBack = (int)Math.floor((float)ammo / this.ammoType.getShotsPerBullet(this.clipsize, ammo));
                if (bulletsBack > 0) {
                    items.add(TGItems.newStack(this.getAmmoType().getBullet(this.getCurrentAmmoVariant(stack))[i], bulletsBack));
                }
                if (this.ammoType.getEmptyMag()[i].func_190926_b()) continue;
                items.add(TGItems.newStack(this.ammoType.getEmptyMag()[i], 1));
            }
        } else {
            int amount = this.ammoType.getEmptyMag().length;
            for (int i = 0; i < amount; ++i) {
                items.add(TGItems.newStack(this.ammoType.getAmmo(this.getCurrentAmmoVariant(stack))[i], 1));
            }
        }
        return items;
    }

    public void tryForcedReload(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        TGExtendedPlayer extendedPlayer = TGExtendedPlayer.get(player);
        if (extendedPlayer.getFireDelay(hand) <= 0 && !this.isFullyLoaded(item)) {
            int oldAmmo = this.getCurrentAmmo(item);
            if (InventoryUtil.consumeAmmoPlayer(player, this.getReloadItem(item))) {
                int i;
                if (this.ammoCount <= 1) {
                    this.useAmmo(item, oldAmmo);
                }
                int ammos = this.getAmmoType().getEmptyMag().length;
                for (i = 0; i < ammos; ++i) {
                    int amount2;
                    int bulletsBack;
                    if (this.ammoType.getEmptyMag()[i].func_190926_b()) continue;
                    int amount = InventoryUtil.addAmmoToPlayerInventory(player, TGItems.newStack(this.ammoType.getEmptyMag()[i], 1));
                    if (amount > 0 && !world.field_72995_K) {
                        player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, TGItems.newStack(this.ammoType.getEmptyMag()[i], amount)));
                    }
                    if ((bulletsBack = (int)Math.floor((float)oldAmmo / this.ammoType.getShotsPerBullet(this.clipsize, oldAmmo))) <= 0 || (amount2 = InventoryUtil.addAmmoToPlayerInventory(player, TGItems.newStack(this.ammoType.getBullet(this.getCurrentAmmoVariant(item))[i], bulletsBack))) <= 0 || world.field_72995_K) continue;
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, TGItems.newStack(this.ammoType.getBullet(this.getCurrentAmmoVariant(item))[i], amount2)));
                }
                if (world.field_72995_K && this.canZoom && this.toggleZoom) {
                    ClientProxy cp = ClientProxy.get();
                    if (cp.player_zoom != 1.0f) {
                        cp.player_zoom = 1.0f;
                    }
                }
                extendedPlayer.setFireDelay(hand, this.reloadtime - this.minFiretime);
                if (this.ammoCount > 1) {
                    for (i = 1; i < this.ammoCount - oldAmmo && InventoryUtil.consumeAmmoPlayer(player, this.ammoType.getAmmo(this.getCurrentAmmoVariant(item))); ++i) {
                    }
                    this.reloadAmmo(item, i);
                } else {
                    this.reloadAmmo(item);
                }
                SoundUtil.playReloadSoundOnEntity(world, (Entity)player, this.reloadsound, 1.0f, 1.0f, false, true, TGSoundCategory.RELOAD);
                if (world.field_72995_K) {
                    int time = (int)((float)this.reloadtime / 20.0f * 1000.0f);
                    ShooterValues.setReloadtime((EntityLivingBase)player, hand == EnumHand.OFF_HAND, System.currentTimeMillis() + (long)time, time, (byte)0);
                    this.client_startReload();
                } else {
                    int msg_reloadtime = (int)((float)this.reloadtime / 20.0f * 1000.0f);
                    TGPackets.network.sendToAllAround((IMessage)new ReloadStartedMessage((EntityLivingBase)player, hand, msg_reloadtime, 0), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 100.0));
                }
            }
        }
    }

    public int getClipsize() {
        return this.clipsize;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return this.handType != GunHandType.TWO_HANDED;
    }

    public boolean canClickBlock(World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult raytraceresult = this.func_77621_a(world, player, false);
        return raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK;
    }

    public boolean setGunStat(EnumGunStat stat, float value) {
        switch (stat) {
            case DAMAGE: {
                this.damage = value;
                return true;
            }
            case DAMAGE_MIN: {
                this.damageMin = value;
                return true;
            }
            case DAMAGE_DROP_START: {
                this.damageDropStart = value;
                return true;
            }
            case DAMAGE_DROP_END: {
                this.damageDropEnd = value;
                return true;
            }
            case BULLET_SPEED: {
                this.speed = value;
                return true;
            }
            case BULLET_DISTANCE: {
                this.ticksToLive = (int)value;
                return true;
            }
            case GRAVITY: {
                this.gravity = value;
                return true;
            }
            case SPREAD: {
                this.spread = value;
                return true;
            }
        }
        return false;
    }

    public float getSpread() {
        return this.spread;
    }

    public GunHandType getHandType() {
        return this.handType;
    }

    public float getZoombonus() {
        return this.zoombonus;
    }

    public EnumCrosshairStyle getCrossHairStyle() {
        return this.crossHairStyle;
    }

    public GenericGun setCrossHair(EnumCrosshairStyle crosshair) {
        this.crossHairStyle = crosshair;
        return this;
    }
}

