/*
 * Decompiled with CFR 0.152.
 */
package techguns.items.guns;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import techguns.TGPackets;
import techguns.TGSounds;
import techguns.api.damagesystem.DamageType;
import techguns.damagesystem.TGDamageSource;
import techguns.deatheffects.EntityDeathUtils;
import techguns.items.guns.ChargedProjectileSelector;
import techguns.items.guns.GenericGunMeleeCharge;
import techguns.packets.PacketNotifyAmbientEffectChange;
import techguns.packets.PacketSpawnParticle;

public class Shishkebap
extends GenericGunMeleeCharge {
    public Shishkebap(String name, ChargedProjectileSelector projectile_selector, boolean semiAuto, int minFiretime, int clipsize, int reloadtime, float damage, SoundEvent firesound, SoundEvent reloadsound, int TTL, float accuracy, float fullChargeTime, int ammoConsumedOnFullCharge) {
        super(name, projectile_selector, semiAuto, minFiretime, clipsize, reloadtime, damage, firesound, reloadsound, TTL, accuracy, fullChargeTime, ammoConsumedOnFullCharge);
        this.setHasCustomAnim(false);
        this.setNoBowAnim();
    }

    @Override
    public DamageType getDamageType(ItemStack stack) {
        return DamageType.FIRE;
    }

    @Override
    protected TGDamageSource getMeleeDamageSource(EntityPlayer player, ItemStack stack) {
        TGDamageSource src = new TGDamageSource("player", (Entity)player, (Entity)player, DamageType.FIRE, EntityDeathUtils.DeathType.GORE);
        if (this.getCurrentAmmo(stack) > 0) {
            src.goreChance = 0.25f;
            src.armorPenetration = this.penetration;
            src.knockbackMultiplier = 1.0f;
        } else {
            src.deathType = EntityDeathUtils.DeathType.DEFAULT;
        }
        return src;
    }

    @Override
    protected void spawnSweepParticle(World w, double x, double y, double z, double motionX, double motionY, double motionZ) {
        TGPackets.network.sendToAllAround((IMessage)new PacketSpawnParticle("PowerhammerImpact", x, y, z), new NetworkRegistry.TargetPoint(w.field_73011_w.getDimension(), x, y, z, 32.0));
    }

    @Override
    protected void consumeAmmoOnMeleeHit(EntityLivingBase elb, ItemStack stack) {
        boolean empty = this.getAmmoLeft(stack) <= 0;
        super.consumeAmmoOnMeleeHit(elb, stack);
        if (!elb.field_70170_p.field_72995_K && !empty && this.getAmmoLeft(stack) <= 0) {
            TGPackets.network.sendToDimension((IMessage)new PacketNotifyAmbientEffectChange(elb, EnumHand.MAIN_HAND), elb.field_70170_p.field_73011_w.getDimension());
        }
    }

    @Override
    protected void onMeleeHitTarget(ItemStack stack, Entity target) {
        if (this.getAmmoLeft(stack) > 0) {
            target.func_70015_d(3);
        }
    }

    @Override
    protected SoundEvent getSwingSound() {
        return TGSounds.SHISHKEBAP_SWING;
    }

    @Override
    protected SoundEvent getBlockBreakSound() {
        return null;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(handIn));
    }

    @Override
    public boolean canCharge() {
        return false;
    }

    @Override
    public void func_77615_a(ItemStack item, World world, EntityLivingBase entityLiving, int timeLeft) {
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        return 0;
    }
}

